'
'	Frank Lupo (Wolf) !!
'	Frank_lupo@email.it

'	This is a Psql command for Postgresql write in Visual Basic Script
'
'	Utility
'	Library utility
'
Option Explicit

Class ClsUtility
	Public Misc
	Public Env
	Public String
	Public Math
	Public FileSystem

	Private Sub Class_Initialize
		Set Misc = New ClsMisc
		Set Env = New ClsEnvironment
		Set String = New ClsString
		Set Math = New ClsMath
		Set FileSystem = New ClsFileSystem
	End Sub

	Private Sub Class_Terminate
		Set Misc = Nothing
		Set Env = Nothing
		Set String = Nothing
		Set Math = Nothing
		Set FileSystem = Nothing
	End Sub
End Class

Class ClsMisc
	'	run program
	Public Function RunProgram(szRun,ModalRun,WaitExit)
		dim WshShell

		on error resume next 
		Set WshShell = WScript.CreateObject("WScript.Shell")
		RunProgram=WshShell.Run(szRun, ModalRun, WaitExit)
		if err.number <> 0 then wscript.echo err.Description
		on error goto 0
	End Function

	'	MultiMsgBox if the message is upper 20 line split in the more msgbox
	Public Function MMsgBox(prompt,buttons,title,filehelp,contest) 
	Dim vIbuf, iCount, szTemp, ii
	Const LineForMsgBox = 20

		vIbuf=Split(prompt,VbCrlf)
		iCount=0
		szTemp=""
		For ii=0 to ubound(vIbuf)
			If iCount > LineForMsgBox-1 Then
				if contest > 0 then
					MMsgBox=MsgBox(szTemp,buttons,title,filehelp,contest) 
				elseif len(filehelp) > 0 then
					MMsgBox=MsgBox(szTemp,buttons,title,filehelp) 
				elseif len(title) > 0 then
					MMsgBox=MsgBox(szTemp,buttons,title) 
				else
					MMsgBox=MsgBox(szTemp,buttons) 
				end if
				iCount=-1
				szTemp=""
			else
				szTemp=szTemp & vIbuf(ii) & vbCrLf
				iCount=iCount+1
			end if
		next
		If iCount > 0 Then
			if contest > 0 then
				MMsgBox=MsgBox(szTemp,buttons,title,filehelp,contest) 
			elseif len(filehelp) > 0 then
				MMsgBox=MsgBox(szTemp,buttons,title,filehelp) 
			elseif len(title) > 0 then
				MMsgBox=MsgBox(szTemp,buttons,title) 
			else
				MMsgBox=MsgBox(szTemp,buttons) 
			end if
		End If 
	End Function
End Class

Class ClsEnvironment
    Public Property Get GetEnv(Ivar)
	Dim WshShell, WshEnv
		Set WshShell = WScript.CreateObject("WScript.Shell")
		Set WshEnv = WshShell.Environment("SYSTEM")

		GetEnv=WshEnv(Ivar)
	End Property

    Public Sub SetEnv(Ivar,Ival)
	Dim WshShell, WshEnv
		Set WshShell = WScript.CreateObject("WScript.Shell")
		Set WshEnv = WshShell.Environment("SYSTEM")

		WshEnv(Ivar)=Ival
	End Sub
End Class

Class ClsString
	'	center string in specific length
	Public Function CenterStr(szIstr,LngStr)
		dim Inum

		CenterStr=szIstr
		Inum=LngStr-len(trim(szIstr))
		if inum=1 then
			CenterStr= Trim(szIstr) & " "
		else
			Inum=Fix((LngStr-len(trim(szIstr)))/2)
			if Inum > 0 then CenterStr=space(Inum) & Trim(szIstr) & space(LngStr-Inum-len(Trim(szIstr)))
		end if
	End Function
End Class

Class ClsMath
	'	max for argument
	Public Function Max(Arg1,Arg2)
		Max=Arg2
		if Arg1 > Arg2 then Max=Arg1
	End Function

	'	min for argument
	Public Function Min(Arg1,Arg2)
		Min=Arg2
		if Arg1 < Arg2 then Min=Arg1
	End Function
End Class

Class ClsFileSystem

	'write string to file
	Public Sub WriteFile(PathFile,Istr,ModalWrite)
		'Modal write = ForAppending ForWriting

		Dim fso,f
		on error resume next
		Set fso = CreateObject("Scripting.FileSystemObject")
		Set f = fso.OpenTextFile(PathFile, ModalWrite, True)
		if err.number <> 0 then wscript.echo Err.Description

	   	f.Write Istr
		
   		f.Close
		if err.number <> 0 then wscript.echo Err.Description
		on error goto 0
	End Sub

	'read file
	Public Function ReadFile(PathFile,TypeReturn)
		'Type Return = 0 string = 1 array

		Dim fso,f,szArray
		on error resume next
		Set fso = CreateObject("Scripting.FileSystemObject")
		Set f = fso.OpenTextFile(PathFile, ForReading, True)
		if err.number <> 0 then wscript.echo Err.Description

		if TypeReturn = 1  then
			redim szArray(0)
			while not f.AtEndOfLine 
    	  		szArray(ubound(szArray))= f.ReadLine
				redim preserve szArray(ubound(szArray)+1)
   			Wend
			if ubound(szArray) > 0 then redim preserve szArray(ubound(szArray)-1)
			ReadFile=szArray
		else
			ReadFile=f.ReadAll
		end if

   		f.Close
		if err.number <> 0 then wscript.echo Err.Description
		on error goto 0
	End Function

	Public Function DeleteFile(PathFile)
		Dim fso

		on error resume next

		Set fso = CreateObject("Scripting.FileSystemObject")
   		fso.DeleteFile(PathFile)

		on error goto 0
	End Function
End Class
