include	clib.inc
include	iost.inc
include	conio.inc
include	string.inc
include	stdio.inc
include	malloc.inc
include	stdlib.inc

	.186

	extrn	IDD_CMMEMORY:WORD

LINESIZE	= 64
MAXLINES	= 64
ID_COUNT 	= 11
ID_QUIT		= ID_COUNT
ID_VIEW		= ID_COUNT + 3

S_MCB		STRUC
mcb_flag	db ?
mcb_owner	dw ?
mcb_size	dw ?
mcb_unused	db 3 dup(?)
mcb_name	db 8 dup(?)
S_MCB		ENDS

_DATA	SEGMENT
M0000	db '000000 -- Interrupt vector table',0
M0400	db '000400 -- BIOS Data area',0
M0500	db '000500 -- Data area',0
M0600	db '000600 -- MS-DOS 1.x Load address',0
M0700	db '000700 -- MS-DOS 2.+ Load address',0
format	db '%06lX          %7lu byte %04X',0
formatz	db '%7lu byte',0
o_list	dw ?
dialog	label dword
dlg_ax	dw ?
dlg_dx	dw ?
_DATA	ENDS

_TEXT	SEGMENT

normalize PROC
	mov	cl,dh
	shl	dx,4
	add	ax,dx
	adc	cl,0
	shr	cl,4
	mov	dl,cl
	mov	dh,0
	ret
normalize ENDP

readmem PROC
	push	si
	push	di
	push	bp
	mov	bx,o_list
	push	[bx.ll_list_dx]
	push	[bx.ll_list_ax]
	push	ds
	push	offset M0000
	call	strcpy
	add	ax,LINESIZE
	push	dx
	push	ax
	push	ds
	push	offset M0400
	call	strcpy
	add	ax,LINESIZE
	push	dx
	push	ax
	push	ds
	push	offset M0500
	call	strcpy
	add	ax,LINESIZE
	push	dx
	push	ax
	push	ds
	push	offset M0600
	call	strcpy
	add	ax,LINESIZE
	push	dx
	push	ax
	push	ds
	push	offset M0700
	call	strcpy
	add	ax,LINESIZE
	mov	si,ax
	mov	[bx.ll_count],5
	mov	ah,52h
	int	21h
	mov	di,es:[bx-2]	; segment of first memory control block
    readmem_loop:
	mov	es,di
	xor	ax,ax
	mov	bx,ax
	mov	cx,es:[bx.mcb_owner]
	push	cx
	mov	dx,es:[bx.mcb_size]
	call	normalize
	push	dx
	push	ax
	mov	dx,di
	xor	ax,ax
	call	normalize
	push	dx
	push	ax
	mov	ax,offset format
	mov	bx,o_list
	mov	dx,[bx.ll_list_dx]
	mov	bx,si
	call	@sprintf
	add	sp,10
	mov	bx,o_list
	inc	[bx.ll_count]
	cmp	[bx.ll_count],MAXLINES
	je	readmem_end
	xor	bx,bx
	mov	ax,es:[bx.mcb_owner]
	mov	bx,o_list
	mov	dx,[bx.ll_list_dx]
	dec	ax
	cmp	ax,di
	je	readmem_copy
	inc	ax
	jz	readmem_free
	cmp	ax,8
	je	readmem_dos
	cmp	ax,6
	je	readmem_next
	cmp	ax,7
	je	readmem_next
	cmp	ax,0FFF7h
	jb	readmem_next
	mov	es,dx
	mov	ax,'83'
	mov	es:[si+7],ax
	mov	ax,'M6'
	mov	es:[si+9],ax
	mov	ax,'XA'
	mov	es:[si+11],ax
	jmp	readmem_next
    readmem_free:
	mov	es,dx
	mov	ax,'RF'
	mov	es:[si+7],ax
	mov	ax,'EE'
	mov	es:[si+9],ax
	jmp	readmem_next
    readmem_dos:
	mov	es,dx
	mov	ax,'OD'
	mov	es:[si+7],ax
	mov	al,'S'
	mov	es:[si+9],al
	jmp	readmem_next
    readmem_copy:
	mov	cx,8
	mov	ax,[bx.ll_list_dx]
	mov	es,di
	mov	bx,cx
	mov	dx,ds
	mov	ds,ax
	push	si
	add	si,7
    readmem_cpyl:
	mov	al,es:[bx]
	inc	bx
	or	al,al
	jz	readmem_endc
	mov	[si],al
	inc	si
	dec	cx
	jnz	readmem_cpyl
    readmem_endc:
	pop	si
	mov	ds,dx
    readmem_next:
	add	si,LINESIZE
	mov	es,di
	xor	bx,bx
	add	di,es:[bx.mcb_size]
	inc	di
	mov	es,di
	mov	al,es:[bx.mcb_flag]
	cmp	al,4Dh
	je	readmem_loop
    readmem_end:
	pop	bp
	pop	di
	pop	si
	ret
readmem ENDP

init_list PROC
	push	si
	push	di
	push	bp
	push	ds
	cld
	mov	cx,ID_COUNT
	mov	bx,o_list
	mov	[bx.ll_numcel],0
	mov	ax,LINESIZE
	mul	[bx.ll_index]
	add	ax,[bx.ll_list_ax]
	mov	dx,[bx.ll_list_dx]
	mov	bp,bx
	les	di,dialog
	add	di,16+to_data_ax	; &object[0].data
	mov	ds,dx			; DS:SI to list
	mov	si,ax
    event_list_loop:
	mov	ax,7F80h
	or	es:[di-7],al		; object.flag to unused
	cmp	byte ptr [si],0		; entry in use ?
	jz	event_list_next
	and	es:[di-7],ah
	inc	[bp.ll_numcel]
    event_list_next:
	mov	ax,si			; store pointer
	stosw
	mov	ax,ds
	stosw
	add	di,12			; next object
	add	si,LINESIZE		; next info line
	dec	cx
	jnz	event_list_loop
	pop	ds
	pop	bp
	pop	di
	pop	si
	ret
init_list ENDP

event_list PROC DIST
	call	init_list
	push	dlg_dx
	push	dlg_ax
	call	tdinit
	mov	ax,_C_NORMAL
	ret
event_list ENDP

event_view PROC	DIST
	mov	STDI.ios_flag,IO_MEMREAD
	xor	ax,ax
	push	ax
	push	ax
	mov	bx,o_list
	add	ax,[bx.ll_celoff]
	inc	al
	shl	ax,4
	les	bx,dialog
	add	bx,ax
	push	es:[bx.to_data_dx]
	push	es:[bx.to_data_ax]
	call	xtol
	shr	ax,4
	shl	dx,4
	or	ah,dl
	xor	dx,dx
	xchg	ax,dx
	push	dx
	push	ax
	push	ax
	push	ax
	push	000Fh
	dec	ax
	push	ax
	call	textview
    event_view_end:
	xor	ax,ax
	ret
event_view ENDP

_TEXT	ENDS

PPROC	cmmemory
local	list:S_LOBJ
	push	si
	push	di
	lea	ax,list
	mov	o_list,ax
	push	LINESIZE * MAXLINES
	call	malloc
	jz	cmmemory_ernomem
	mov	list.ll_list_ax,ax	; pointer to list buffer
	mov	list.ll_list_dx,dx
	push	dx
	push	ax
	push	LINESIZE * MAXLINES
	call	memzero
	push	ds
	push	IDD_CMMEMORY
	call	rsopen
	jz	cmmemory_free
	mov	dlg_dx,dx
	mov	dlg_ax,ax
	push	dx
	push	ax
	call	twshow
	LMOV	ax,cs
	LMOV	es:[bx+16+ID_VIEW*16+TO_OPROC+2],ax
	mov	es:[bx+16+ID_VIEW*16+TO_OPROC],offset event_view
	LMOV	word ptr list.ll_proc+2,ax
	mov	word ptr list.ll_proc,offset event_list
	xor	ax,ax
	mov	list.ll_dcount,ID_COUNT	; number of cells (max)
	mov	list.ll_celoff,ID_COUNT	; cell offset
	mov	list.ll_dlgoff,ax	; start index in dialog
	mov	list.ll_numcel,ax	; number of visible cells
	mov	list.ll_count,ax	; total number of items in list
	mov	list.ll_index,ax	; index in list buffer
	call	readmem
	call	event_list
	int	12h
	mov	dx,1024
	mul	dx
	mov	si,dx
	mov	di,ax
	push	dx
	push	ax
	mov	bx,IDD_CMMEMORY
	mov	bx,[bx+6]
	add	bx,0E14h
	xor	cx,cx
	mov	dx,ds
	mov	ax,offset formatz
	call	@scputf
	mov	dx,_psp
	add	dx,2
	xor	ax,ax
	call	normalize
	push	dx
	push	ax
	inc	bh
	xor	cx,cx
	mov	ax,offset formatz
	call	@scputf
	pop	ax
	pop	dx
	sub	di,ax
	sbb	si,dx
	push	si
	push	di
	inc	bh
	mov	ax,offset formatz
	call	@scputf
	add	sp,8
    cmmemory_event:
	push	dlg_dx
	push	dlg_ax
	lea	ax,list
	push	ss
	push	ax
	call	tdlevent
	jz	cmmemory_close
	cmp	ax,ID_COUNT
	ja	cmmemory_close
	call	event_view
	jz	cmmemory_event
    cmmemory_close:
	push	dlg_dx
	push	dlg_ax
	call	twclose
    cmmemory_free:
	push	list.ll_list_dx
	push	list.ll_list_ax
	call	free
    cmmemory_toend:
	pop	di
	pop	si
	ret
    cmmemory_ernomem:
	xor	ax,ax
	jmp	cmmemory_toend
PEND	cmmemory

	END
