	.186

include	clib.inc
ifdef __EDIT__
include	tinfo.inc
include	ctype.inc
include	ini.inc
include	stdlib.inc
include	string.inc

	public	tireadstyle

_DATA	SEGMENT

cp_defaultfile	db 'file_*',0	; file_asm, file_c, ...

_DATA	ENDS

ID_TYPE		= 0
ID_ATTRIB	= 1

; --------------------	[CPU]		[operator]
; 00h	type	BYTE    00=word		00=char
; 01h	attrib	BYTE	01=0B		01=0F
; 02h	string	BYTES	02=ax bx cx dx	02=.:+-!%&{[]}=?
; ??h	0	BYTE	03=ds es cs ss

ST_ATTRIB	= 1	; attrib	01 at
ST_CHAR		= 2	; char		01 at, 02=<chars>
ST_WORD		= 3	; word		01 at, 02=<words>,...
ST_START	= 4	; start		01 at, 02=<string>
ST_NESTED	= 5	; nested	01 at, 02=<string1> <string2>
ST_CONTROL	= 6	; control	01 at
ST_STRING	= 7	; string	01 at, 02=<string>
ST_QUOTE	= 8	; quote		01 at
ST_NUMBER	= 9	; number	01 at
ST_COUNT	= ST_NUMBER

S_RDST		STRUC
st_section	DB 64 dup(?)
st_label	DB 64 dup(?)
st_offset	DW ?
st_style_eof	DW ?	; style + SIZE style - 2
S_RDST		ENDS

_TEXT	SEGMENT

ticlrstyle PROC
	push	di
	mov	di,tinfo
	lea	ax,[di.ti_style]
	mov	di,ax
	add	ax,STYLESIZE - 4
	mov	[bp.st_style_eof],ax
	xor	ax,ax
	push	ds
	pop	es
	cld
	mov	cx,STYLESIZE / 2
	rep	stosw
	pop	di
	ret
ticlrstyle ENDP

tireadlabel PROC
	push	si
	push	di
	lea	si,[bp.st_label]
	push	ss
	push	si
	push	ID_TYPE
	call	inientryid
	jz	tireadlabel_end
	mov	di,[bp.st_offset]
	cmp	di,[bp.st_style_eof]
	ja	tireadlabel_end
	mov	bx,ax
	mov	al,ST_CHAR
	mov	ah,[bx]
	or	ah,20h
	cmp	ah,'a'
	je	tireadlabel_at
	cmp	ah,'q'
	je	tireadlabel_quote
	cmp	ah,'w'
	je	tireadlabel_word
	cmp	ah,'n'
	je	tireadlabel_nested
	cmp	ah,'c'
	jne	tireadlabel_s
	mov	ah,[bx+1]
	cmp	ah,'h'
	je	tireadlabel_type
	mov	al,ST_CONTROL
	jmp	tireadlabel_type
    tireadlabel_s:
	mov	ah,[bx+2]
	cmp	ah,'r'
	je	tireadlabel_string
	mov	al,ST_START
	jmp	tireadlabel_type
    tireadlabel_string:
	mov	al,ST_STRING
	jmp	tireadlabel_type
    tireadlabel_quote:
	mov	al,ST_QUOTE
	jmp	tireadlabel_type
    tireadlabel_word:
	mov	al,ST_WORD
	jmp	tireadlabel_type
    tireadlabel_at:
	mov	al,ST_ATTRIB
	jmp	tireadlabel_type
    tireadlabel_nested:
	mov	al,ST_NESTED
	mov	ah,[bx+1]
	cmp	ah,'e'
	je	tireadlabel_type
	mov	al,ST_NUMBER
    tireadlabel_type:
	stosb
	push	ss
	push	si
	mov	ah,0
	mov	si,ax
	push	ID_ATTRIB
	call	inientryid
	jz	tireadlabel_break
	push	ax
	mov	bx,ax
	mov	ax,[bx]
	or	ax,2020h
	cmp	al,'x'
	je	tireadlabel_fg
	cmp	ah,'x'
	je	tireadlabel_bg
    tireadlabel_getat:
	push	dx
	push	bx
	call	xtol
    tireadlabel_stoat:
	stosb
	pop	bx
	cmp	si,ST_ATTRIB
	mov	si,2
	jne	tireadlabel_label
	add	bx,si
	mov	si,tinfo
	mov	[si.ti_stat],al
	mov	al,' '
	cmp	[bx],al
	je	tireadlabel_char
	inc	bx
	cmp	[bx],al
	jne	tireadlabel_nochar
    tireadlabel_char:
	inc	bx
	push	ss
	push	bx
	call	strtol
	mov	[si.ti_stch],al
	stosb
	jmp	tireadlabel_break
    tireadlabel_nochar:
	mov	si,2
    tireadlabel_label:
	cmp	si,100
	je	tireadlabel_break
	lea	ax,[bp.st_label]
	push	ss
	push	ax
	push	si
	inc     si
	call	inientryid
	jz	tireadlabel_break
	mov	bx,si
	mov	cx,[bp.st_style_eof]
	mov	si,ax
    tireadlabel_copy:
	lodsb
	cmp	di,cx
	jae	tireadlabel_endcopy
	cmp	al,' '
	jne	tireadlabel_sto
	mov	al,0
	stosb
	jmp	tireadlabel_copy
    tireadlabel_fg:	; X?
	mov	al,ah
	call	getctype
	and	ah,_HEX or _DIGIT
	jz 	tireadlabel_getat
	sub	al,'0'
	and	ah,_DIGIT
	jnz	tireadlabel_fgset
	sub	al,39
    tireadlabel_fgset:
	mov	bx,tinfo
	mov	ah,[bx.ti_stat]
	and	ah,0F0h
	or	al,ah
	jmp	tireadlabel_stoat
    tireadlabel_bg:
	call	getctype
	and	ah,_HEX or _DIGIT
	jz 	tireadlabel_getat
	sub	al,'0'
	and	ah,_DIGIT
	jnz	tireadlabel_bgset
	sub	al,39
    tireadlabel_bgset:
	shl	al,4
	mov	bx,tinfo
	mov	ah,[bx.ti_stat]
	and	ah,0Fh
	or	al,ah
	jmp	tireadlabel_stoat
    tireadlabel_sto:
	stosb
	or	al,al
	jnz	tireadlabel_copy
    tireadlabel_endcopy:
	mov	si,bx
	jmp	tireadlabel_label
    tireadlabel_break:
	xor	ax,ax
	cmp	[di-1],al
	je	tireadlabel_stosb
	stosb
    tireadlabel_stosb:
	stosb
	mov	[bp.st_offset],di
	inc	ax
    tireadlabel_end:
	pop	di
	pop	si
	ret
tireadlabel ENDP

tidosection PROC
	push	si
	push	di
	sub	sp,64
	mov	di,sp
	push	ss
	push	di
	push	ss
	lea	ax,[bp.st_section]
	push	ax
	push	64
	call	memcpy
	xor	si,si
    tidosection_do:
	push	ss
	lea	ax,[bp.st_section]
	push	ax
	push	si
	inc     si
	call	inientryid
	jz	tidosection_end
	mov	di,ax
	mov	al,[di]
	cmp	al,'['
	jne	tidosection_label
	mov	bx,si
	mov	dx,di
	mov	si,di
	inc	si
	lea	di,[bp.st_section]
    tidosection_rep:
	lodsb
	stosb
	or	al,al
	jz	tidosection_endc
	cmp	al,']'
	jne	tidosection_rep
    tidosection_endc:
	dec	di
	xor	ax,ax
	stosb
	mov	si,bx
	mov	di,dx
	call	tidosection
	mov	dx,sp
	lea	ax,[bp.st_section]
	push	ss
	push	ax
	push	ss
	push	dx
	push	64
	call	memcpy
	jmp	tidosection_do
    tidosection_label:
	lea	ax,[bp.st_label]
	push	dx
	push	ax
	push	dx
	push	di
	call	strcpy
	call	tireadlabel
	jmp	tidosection_do
    tidosection_end:
	add	sp,64
	pop	di
	pop	si
	ret
tidosection ENDP

tireadstyle PROC PASCAL
local	rdst:S_RDST
	push	si
	push	di
	push	bp
	lea	bp,rdst
	mov	si,tinfo
	lea	ax,[si.ti_style]
	mov	[bp.st_offset],ax
	call	ticlrstyle
	mov	si,offset cp_defaultfile
	lea	di,[bp.st_section]
	mov	cx,5
	rep	movsb
	mov	si,tinfo
	pushm	[si.ti_file]
	call	strext
	jnz	tireadstyle_ext
	pushm	[si.ti_file]
	call	strfn
	dec	ax
    tireadstyle_ext:
	inc	ax
	push	ss
	push	di
	push	dx
	push	ax
	call	strcpy
	push	dx
	lea	ax,[bp.st_section]
	push	ax
	push	0
	call	inientryid
	jnz	tireadstyle_do
	lea	ax,[bp.st_section]
	push	ss
	push	ax
	push	ss
	push	offset cp_defaultfile
	call	strcpy
    tireadstyle_do:
	call	tidosection
	mov	di,[bp.st_offset]
	xor	ax,ax
	stosw
    tireadstyle_end:
	pop	bp
	pop	di
	pop	si
	ret
tireadstyle ENDP

_TEXT	ENDS
endif
	END
