### Name: vgram
### Title: Finds a traditional or robust variogram for spatial data.
### Aliases: vgram
### Keywords: spatial

### ** Examples

#
# compute variogram for the midwest ozone field  day 16
# (BTW this looks a bit strange!)
#
data( ozone2)
good<- !is.na(ozone2$y[16,])
x<- ozone2$lon.lat[good,] 
y<- ozone2$y[16,good]

look<-vgram( x,y, N=15, lon.lat=TRUE) # locations are in lon/lat so use right
#distance
# take a look:
#plot( look$d, look$vgram)
#lines(look$centers, look$stats["mean",], col=4)

brk<- seq( 0, 250,,25)
 
## or some boxplot bin summaries

bplot.xy( look$d, sqrt(look$vgram), breaks=brk,ylab="sqrt(VG)")
lines(look$centers, look$stats["mean",], col=4)




