/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.ChromHMM;

import edu.mit.compbio.ChromHMM.ChromHMM;
import edu.mit.compbio.ChromHMM.Util;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class BrowserOutput {
    HashMap hmcolor = new HashMap();
    HashMap hmlabelExtend = new HashMap();
    String szsegmentfile;
    String szcolormapping;
    String szidlabelmapping;
    String szsegmentationname;
    String szoutputfileprefix;
    int numstates;
    boolean bgzip;

    public BrowserOutput(String string, String string2, String string3, String string4, String string5, int n, boolean bl) throws IOException {
        this.szsegmentfile = string;
        this.szcolormapping = string2;
        this.szidlabelmapping = string3;
        this.szsegmentationname = string4;
        this.szoutputfileprefix = string5;
        this.numstates = n;
        this.bgzip = bl;
        this.hmcolor = new HashMap();
        this.hmlabelExtend = new HashMap();
        this.makeColorMapping();
        this.makeLabelMapping();
    }

    private void makeColorMapping() throws IOException {
        if (this.szcolormapping != null) {
            String string;
            BufferedReader bufferedReader = Util.getBufferedReader(this.szcolormapping);
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                this.hmcolor.put(string2, string3);
            }
            bufferedReader.close();
        } else {
            Object object;
            String string;
            BufferedReader bufferedReader = Util.getBufferedReader(this.szsegmentfile);
            HashSet<String> hashSet = new HashSet<String>();
            while ((string = bufferedReader.readLine()) != null) {
                object = string.split("\\s+");
                hashSet.add(object[3].substring(1));
            }
            bufferedReader.close();
            object = hashSet.iterator();
            int n = 1;
            int n2 = 1;
            while (object.hasNext()) {
                int n3 = Integer.parseInt((String)object.next());
                if (n3 < n2) {
                    n2 = n3;
                    continue;
                }
                if (n3 <= n) continue;
                n = n3;
            }
            n = Math.max(n, n2 + this.numstates - 1);
            String[] stringArray = new String[n - n2 + 1];
            for (int i = n2; i <= n; ++i) {
                stringArray[i - n2] = "" + i;
            }
            int[][] nArray = this.getMaxDiverseOrder(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                this.hmcolor.put(stringArray[i], nArray[i][0] + "," + nArray[i][1] + "," + nArray[i][2]);
            }
        }
    }

    private int[][] getMaxDiverseOrder(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Random random = new Random(132L);
        int[] nArray = new int[]{0, 51, 102, 153, 204, 255};
        int[][] nArray2 = new int[nArray.length * nArray.length * nArray.length][3];
        boolean[] blArray = new boolean[nArray2.length];
        blArray[0] = true;
        blArray[blArray.length - 1] = true;
        int n8 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (n7 = 0; n7 < nArray.length; ++n7) {
                for (n6 = 0; n6 < nArray.length; ++n6) {
                    nArray2[n8][0] = nArray[i];
                    nArray2[n8][1] = nArray[n7];
                    nArray2[n8][2] = nArray[n6];
                    ++n8;
                }
            }
        }
        int[][] nArray3 = new int[n][3];
        nArray3[0][0] = nArray2[nArray.length - 1][0];
        nArray3[0][1] = nArray2[nArray.length - 1][1];
        nArray3[0][2] = nArray2[nArray.length - 1][2];
        for (n7 = 1; n7 < nArray3.length; ++n7) {
            n6 = -1;
            n5 = -1;
            for (n8 = 1; n8 < nArray2.length - 1; ++n8) {
                if (blArray[n8]) continue;
                n4 = Integer.MAX_VALUE;
                for (n3 = 0; n3 < n7; ++n3) {
                    n2 = Math.abs(nArray2[n8][0] - nArray3[n3][0]) + Math.abs(nArray2[n8][1] - nArray3[n3][1]) + Math.abs(nArray2[n8][2] - nArray3[n3][2]);
                    if (n2 >= n4) continue;
                    n4 = n2;
                }
                if (n4 <= n6) continue;
                n6 = n4;
                n5 = n8;
            }
            if (n5 == -1) {
                n5 = random.nextInt(nArray2.length);
            }
            nArray3[n7][0] = nArray2[n5][0];
            nArray3[n7][1] = nArray2[n5][1];
            nArray3[n7][2] = nArray2[n5][2];
            blArray[n5] = true;
        }
        boolean[] blArray2 = new boolean[nArray3.length];
        int[][] nArray4 = new int[nArray3.length][3];
        nArray4[0][0] = nArray3[0][0];
        nArray4[0][1] = nArray3[0][1];
        nArray4[0][2] = nArray3[0][2];
        for (n5 = 1; n5 < nArray4.length; ++n5) {
            n2 = Integer.MAX_VALUE;
            n4 = -1;
            for (n8 = 1; n8 < nArray4.length; ++n8) {
                if (blArray2[n8] || (n3 = Math.abs(nArray3[n8][0] - nArray4[n5 - 1][0]) + Math.abs(nArray3[n8][1] - nArray4[n5 - 1][1]) + Math.abs(nArray3[n8][2] - nArray4[n5 - 1][2])) >= n2) continue;
                n2 = n3;
                n4 = n8;
            }
            blArray2[n4] = true;
            nArray4[n5][0] = nArray3[n4][0];
            nArray4[n5][1] = nArray3[n4][1];
            nArray4[n5][2] = nArray3[n4][2];
        }
        return nArray4;
    }

    private void makeLabelMapping() throws IOException {
        if (this.szidlabelmapping != null) {
            String string;
            BufferedReader bufferedReader = Util.getBufferedReader(this.szidlabelmapping);
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                this.hmlabelExtend.put(string2, string3);
            }
            bufferedReader.close();
        }
    }

    public void makebrowserdense() throws IOException {
        if (this.bgzip) {
            String string;
            System.out.println("Writing to file " + this.szoutputfileprefix + ChromHMM.SZBROWSERDENSEEXTENSION + ".bed.gz");
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(this.szoutputfileprefix + ChromHMM.SZBROWSERDENSEEXTENSION + ".bed.gz"));
            BufferedReader bufferedReader = Util.getBufferedReader(this.szsegmentfile);
            boolean bl = true;
            while ((string = bufferedReader.readLine()) != null) {
                Object object;
                String string2;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                String string3 = stringTokenizer.nextToken();
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                String string4 = stringTokenizer.nextToken();
                String string5 = string4.substring(1);
                if (bl) {
                    string2 = "track name=\"" + this.szsegmentationname + "\" description=\"" + this.szsegmentationname + " (" + ChromHMM.convertCharOrderToStringOrder(string4.charAt(0)) + " ordered)" + "\" visibility=1 itemRgb=\"On\"" + "\n";
                    object = string2.getBytes();
                    gZIPOutputStream.write((byte[])object, 0, ((Object)object).length);
                    bl = false;
                }
                if ((string2 = (String)this.hmcolor.get(string5)) == null) {
                    throw new IllegalArgumentException("Color not given for " + string5);
                }
                object = (String)this.hmlabelExtend.get(string4);
                if (object != null) {
                    string5 = string5 + "_" + (String)object;
                }
                String string6 = string3 + "\t" + n + "\t" + n2 + "\t" + string5 + "\t0\t.\t" + n + "\t" + n2 + "\t" + string2 + "\n";
                byte[] byArray = string6.getBytes();
                gZIPOutputStream.write(byArray, 0, byArray.length);
            }
            bufferedReader.close();
            gZIPOutputStream.finish();
            gZIPOutputStream.close();
        } else {
            String string;
            System.out.println("Writing to file " + this.szoutputfileprefix + ChromHMM.SZBROWSERDENSEEXTENSION + ".bed");
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.szoutputfileprefix + ChromHMM.SZBROWSERDENSEEXTENSION + ".bed"));
            BufferedReader bufferedReader = Util.getBufferedReader(this.szsegmentfile);
            boolean bl = true;
            while ((string = bufferedReader.readLine()) != null) {
                String string7;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                String string8 = stringTokenizer.nextToken();
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                String string9 = stringTokenizer.nextToken();
                String string10 = string9.substring(1);
                if (bl) {
                    printWriter.println("track name=\"" + this.szsegmentationname + "\" description=\"" + this.szsegmentationname + " (" + ChromHMM.convertCharOrderToStringOrder(string9.charAt(0)) + " ordered)" + "\" visibility=1 itemRgb=\"On\"");
                    bl = false;
                }
                if ((string7 = (String)this.hmcolor.get(string10)) == null) {
                    throw new IllegalArgumentException("Color not given for " + string10);
                }
                String string11 = (String)this.hmlabelExtend.get(string9);
                if (string11 != null) {
                    string10 = string10 + "_" + string11;
                }
                printWriter.println(string8 + "\t" + n + "\t" + n3 + "\t" + string10 + "\t0\t.\t" + n + "\t" + n3 + "\t" + string7);
            }
            bufferedReader.close();
            printWriter.close();
        }
    }

    public void makebrowserexpanded() throws IOException {
        int n;
        Object object;
        ArrayList arrayList;
        Object object2;
        int n2;
        Object object3;
        String[] stringArray;
        String string;
        if (this.bgzip) {
            System.out.println("Writing to file " + this.szoutputfileprefix + ChromHMM.SZBROWSEREXPANDEDEXTENSION + ".bed.gz");
        } else {
            System.out.println("Writing to file " + this.szoutputfileprefix + ChromHMM.SZBROWSEREXPANDEDEXTENSION + ".bed");
        }
        BufferedReader bufferedReader = Util.getBufferedReader(this.szsegmentfile);
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        HashMap hashMap2 = new HashMap();
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        String string2 = null;
        while ((string = bufferedReader.readLine()) != null) {
            stringArray = new StringTokenizer(string, "\t");
            object3 = stringArray.nextToken();
            n2 = Integer.parseInt(stringArray.nextToken());
            int n3 = Integer.parseInt(stringArray.nextToken());
            string2 = stringArray.nextToken();
            object2 = string2.substring(1);
            hashMap3.put((String)object2, string2);
            hashSet.add(object3);
            hashSet2.add(object2);
            arrayList = (ArrayList)hashMap2.get((String)object3 + "\t" + (String)object2);
            if (arrayList == null) {
                arrayList = new ArrayList();
                hashMap2.put((String)object3 + "\t" + (String)object2, arrayList);
            }
            arrayList.add(new BeginEndRec(n2, n3));
            object = (Integer)hashMap.get(object3);
            if (object != null) {
                n = (Integer)object;
                if (n3 <= n) continue;
                hashMap.put(object3, n3);
                continue;
            }
            hashMap.put(object3, n3);
        }
        bufferedReader.close();
        stringArray = new String[hashSet2.size()];
        object3 = hashSet2.iterator();
        n2 = 0;
        while (object3.hasNext()) {
            stringArray[n2] = (String)object3.next();
            ++n2;
        }
        Arrays.sort(stringArray, new LabelCompare());
        Object[] objectArray = new String[hashSet.size()];
        object2 = hashSet.iterator();
        n2 = 0;
        while (object2.hasNext()) {
            objectArray[n2] = (String)object2.next();
            ++n2;
        }
        Arrays.sort(objectArray);
        if (this.bgzip) {
            arrayList = new GZIPOutputStream(new FileOutputStream(this.szoutputfileprefix + ChromHMM.SZBROWSEREXPANDEDEXTENSION + ".bed.gz"));
            object = "track name=\"Expanded_" + this.szsegmentationname + "\" description=\"" + this.szsegmentationname + " (" + ChromHMM.convertCharOrderToStringOrder(string2.charAt(0)) + " ordered)" + "\" visibility=2 itemRgb=\"On\"" + "\n";
            byte[] byArray = ((String)object).getBytes();
            ((GZIPOutputStream)((Object)arrayList)).write(byArray, 0, byArray.length);
            int n4 = (int)((double)((Integer)hashMap.get(objectArray[0])).intValue() * 0.001) + 1;
            object = "browser position " + (String)objectArray[0] + ":1-" + n4 + "\n";
            byArray = ((String)object).getBytes();
            ((GZIPOutputStream)((Object)arrayList)).write(byArray, 0, byArray.length);
            for (int i = stringArray.length - 1; i >= 0; --i) {
                String string3 = (String)this.hmcolor.get("" + stringArray[i]);
                for (int j = 0; j < objectArray.length; ++j) {
                    int n5;
                    ArrayList arrayList2 = (ArrayList)hashMap2.get((String)objectArray[j] + "\t" + stringArray[i]);
                    if (arrayList2 == null) continue;
                    int n6 = (Integer)hashMap.get(objectArray[j]);
                    arrayList2.add(new BeginEndRec(n6 - 1, n6));
                    int n7 = arrayList2.size();
                    int n8 = ((BeginEndRec)arrayList2.get((int)0)).nbegin;
                    int n9 = n6;
                    String string4 = (String)this.hmlabelExtend.get((String)hashMap3.get(stringArray[i]));
                    String string5 = string4 != null ? stringArray[i] + "_" + string4 : stringArray[i];
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append((String)objectArray[j] + "\t" + 0 + "\t" + n9 + "\t" + string5 + "\t0\t.\t" + n8 + "\t" + n9 + "\t" + string3 + "\t" + (n7 + 1) + "\t");
                    stringBuffer.append(0);
                    for (n5 = 0; n5 < n7; ++n5) {
                        BeginEndRec beginEndRec = (BeginEndRec)arrayList2.get(n5);
                        int n10 = beginEndRec.nend - beginEndRec.nbegin;
                        stringBuffer.append(",");
                        stringBuffer.append(n10);
                    }
                    stringBuffer.append("\t");
                    stringBuffer.append(0);
                    for (n5 = 0; n5 < n7; ++n5) {
                        int n11 = ((BeginEndRec)arrayList2.get((int)n5)).nbegin;
                        stringBuffer.append(",");
                        stringBuffer.append(n11);
                    }
                    stringBuffer.append("\n");
                    byArray = stringBuffer.toString().getBytes();
                    ((GZIPOutputStream)((Object)arrayList)).write(byArray, 0, byArray.length);
                }
            }
            ((GZIPOutputStream)((Object)arrayList)).finish();
            ((DeflaterOutputStream)((Object)arrayList)).close();
        } else {
            arrayList = new PrintWriter(new FileWriter(this.szoutputfileprefix + ChromHMM.SZBROWSEREXPANDEDEXTENSION + ".bed"));
            ((PrintWriter)((Object)arrayList)).println("track name=\"Expanded_" + this.szsegmentationname + "\" description=\"" + this.szsegmentationname + " (" + ChromHMM.convertCharOrderToStringOrder(string2.charAt(0)) + " ordered)" + "\" visibility=2 itemRgb=\"On\"");
            int n12 = (int)((double)((Integer)hashMap.get(objectArray[0])).intValue() * 0.001) + 1;
            ((PrintWriter)((Object)arrayList)).println("browser position " + (String)objectArray[0] + ":1-" + n12);
            for (n = stringArray.length - 1; n >= 0; --n) {
                String string6 = (String)this.hmcolor.get("" + stringArray[n]);
                for (int i = 0; i < objectArray.length; ++i) {
                    int n13;
                    ArrayList arrayList3 = (ArrayList)hashMap2.get((String)objectArray[i] + "\t" + stringArray[n]);
                    if (arrayList3 == null) continue;
                    int n14 = (Integer)hashMap.get(objectArray[i]);
                    arrayList3.add(new BeginEndRec(n14 - 1, n14));
                    int n15 = arrayList3.size();
                    int n16 = ((BeginEndRec)arrayList3.get((int)0)).nbegin;
                    int n17 = n14;
                    String string7 = (String)this.hmlabelExtend.get((String)hashMap3.get(stringArray[n]));
                    String string8 = string7 != null ? stringArray[n] + "_" + string7 : stringArray[n];
                    ((PrintWriter)((Object)arrayList)).print((String)objectArray[i] + "\t" + 0 + "\t" + n17 + "\t" + string8 + "\t0\t.\t" + n16 + "\t" + n17 + "\t" + string6 + "\t" + (n15 + 1) + "\t");
                    ((PrintWriter)((Object)arrayList)).print(0);
                    for (n13 = 0; n13 < n15; ++n13) {
                        BeginEndRec beginEndRec = (BeginEndRec)arrayList3.get(n13);
                        int n18 = beginEndRec.nend - beginEndRec.nbegin;
                        ((PrintWriter)((Object)arrayList)).print(",");
                        ((PrintWriter)((Object)arrayList)).print(n18);
                    }
                    ((PrintWriter)((Object)arrayList)).print("\t");
                    ((PrintWriter)((Object)arrayList)).print(0);
                    for (n13 = 0; n13 < n15; ++n13) {
                        int n19 = ((BeginEndRec)arrayList3.get((int)n13)).nbegin;
                        ((PrintWriter)((Object)arrayList)).print(",");
                        ((PrintWriter)((Object)arrayList)).print(n19);
                    }
                    ((PrintWriter)((Object)arrayList)).println();
                }
            }
            ((PrintWriter)((Object)arrayList)).close();
        }
    }

    public void makebrowserexpandedLowMem() throws IOException {
        int n;
        Object object;
        Object object2;
        int n2;
        Object object3;
        String[] stringArray;
        String string;
        if (this.bgzip) {
            System.out.println("Writing to file " + this.szoutputfileprefix + ChromHMM.SZBROWSEREXPANDEDEXTENSION + ".bed.gz");
        } else {
            System.out.println("Writing to file " + this.szoutputfileprefix + ChromHMM.SZBROWSEREXPANDEDEXTENSION + ".bed");
        }
        BufferedReader bufferedReader = Util.getBufferedReader(this.szsegmentfile);
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        String string2 = null;
        while ((string = bufferedReader.readLine()) != null) {
            stringArray = new StringTokenizer(string, "\t");
            object3 = stringArray.nextToken();
            n2 = Integer.parseInt(stringArray.nextToken());
            int n3 = Integer.parseInt(stringArray.nextToken());
            string2 = stringArray.nextToken();
            object2 = string2.substring(1);
            hashMap2.put((String)object2, string2);
            hashSet.add(object3);
            hashSet2.add(object2);
            object = (Integer)hashMap.get(object3);
            if (object != null) {
                n = (Integer)object;
                if (n3 <= n) continue;
                hashMap.put(object3, n3);
                continue;
            }
            hashMap.put(object3, n3);
        }
        bufferedReader.close();
        stringArray = new String[hashSet2.size()];
        object3 = hashSet2.iterator();
        n2 = 0;
        while (object3.hasNext()) {
            stringArray[n2] = (String)object3.next();
            ++n2;
        }
        Arrays.sort(stringArray, new LabelCompare());
        Object[] objectArray = new String[hashSet.size()];
        object2 = hashSet.iterator();
        n2 = 0;
        while (object2.hasNext()) {
            objectArray[n2] = (String)object2.next();
            ++n2;
        }
        Arrays.sort(objectArray);
        if (this.bgzip) {
            object = new GZIPOutputStream(new FileOutputStream(this.szoutputfileprefix + ChromHMM.SZBROWSEREXPANDEDEXTENSION + ".bed.gz"));
            String string3 = "track name=\"Expanded_" + this.szsegmentationname + "\" description=\"" + this.szsegmentationname + " (" + ChromHMM.convertCharOrderToStringOrder(string2.charAt(0)) + " ordered)" + "\" visibility=2 itemRgb=\"On\"" + "\n";
            byte[] byArray = string3.getBytes();
            ((GZIPOutputStream)object).write(byArray, 0, byArray.length);
            int n4 = (int)((double)((Integer)hashMap.get(objectArray[0])).intValue() * 0.001) + 1;
            string3 = "browser position " + (String)objectArray[0] + ":1-" + n4 + "\n";
            byArray = string3.getBytes();
            ((GZIPOutputStream)object).write(byArray, 0, byArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                int n5;
                String string4;
                HashMap<String, ArrayList<BeginEndRec>> hashMap3 = new HashMap<String, ArrayList<BeginEndRec>>();
                Object object4 = objectArray[i];
                bufferedReader = Util.getBufferedReader(this.szsegmentfile);
                while ((string = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                    string4 = stringTokenizer.nextToken();
                    if (!string4.equals(object4)) continue;
                    int n6 = Integer.parseInt(stringTokenizer.nextToken());
                    n5 = Integer.parseInt(stringTokenizer.nextToken());
                    string2 = stringTokenizer.nextToken();
                    String string5 = string2.substring(1);
                    ArrayList<BeginEndRec> arrayList = (ArrayList<BeginEndRec>)hashMap3.get(string5);
                    if (arrayList == null) {
                        arrayList = new ArrayList<BeginEndRec>();
                        hashMap3.put(string5, arrayList);
                    }
                    arrayList.add(new BeginEndRec(n6, n5));
                }
                bufferedReader.close();
                for (int j = stringArray.length - 1; j >= 0; --j) {
                    int n7;
                    string4 = (String)this.hmcolor.get("" + stringArray[j]);
                    ArrayList arrayList = (ArrayList)hashMap3.get(stringArray[j]);
                    if (arrayList == null) continue;
                    n5 = (Integer)hashMap.get(objectArray[i]);
                    arrayList.add(new BeginEndRec(n5 - 1, n5));
                    int n8 = arrayList.size();
                    int n9 = ((BeginEndRec)arrayList.get((int)0)).nbegin;
                    int n10 = n5;
                    String string6 = (String)this.hmlabelExtend.get((String)hashMap2.get(stringArray[j]));
                    String string7 = string6 != null ? stringArray[j] + "_" + string6 : stringArray[j];
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append((String)object4 + "\t" + 0 + "\t" + n10 + "\t" + string7 + "\t0\t.\t" + n9 + "\t" + n10 + "\t" + string4 + "\t" + (n8 + 1) + "\t");
                    stringBuffer.append(0);
                    for (n7 = 0; n7 < n8; ++n7) {
                        BeginEndRec beginEndRec = (BeginEndRec)arrayList.get(n7);
                        int n11 = beginEndRec.nend - beginEndRec.nbegin;
                        stringBuffer.append(",");
                        stringBuffer.append(n11);
                    }
                    stringBuffer.append("\t");
                    stringBuffer.append(0);
                    for (n7 = 0; n7 < n8; ++n7) {
                        int n12 = ((BeginEndRec)arrayList.get((int)n7)).nbegin;
                        stringBuffer.append(",");
                        stringBuffer.append(n12);
                    }
                    stringBuffer.append("\n");
                    byArray = stringBuffer.toString().getBytes();
                    ((GZIPOutputStream)object).write(byArray, 0, byArray.length);
                }
            }
            ((GZIPOutputStream)object).finish();
            ((DeflaterOutputStream)object).close();
        } else {
            object = new PrintWriter(new FileWriter(this.szoutputfileprefix + ChromHMM.SZBROWSEREXPANDEDEXTENSION + ".bed"));
            ((PrintWriter)object).println("track name=\"Expanded_" + this.szsegmentationname + "\" description=\"" + this.szsegmentationname + " (" + ChromHMM.convertCharOrderToStringOrder(string2.charAt(0)) + " ordered)" + "\" visibility=2 itemRgb=\"On\"");
            n = (int)((double)((Integer)hashMap.get(objectArray[0])).intValue() * 0.001) + 1;
            ((PrintWriter)object).println("browser position " + (String)objectArray[0] + ":1-" + n);
            for (int i = 0; i < objectArray.length; ++i) {
                int n13;
                String string8;
                Object object5 = objectArray[i];
                HashMap<String, ArrayList<BeginEndRec>> hashMap4 = new HashMap<String, ArrayList<BeginEndRec>>();
                bufferedReader = Util.getBufferedReader(this.szsegmentfile);
                while ((string = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                    string8 = stringTokenizer.nextToken();
                    if (!string8.equals(object5)) continue;
                    int n14 = Integer.parseInt(stringTokenizer.nextToken());
                    n13 = Integer.parseInt(stringTokenizer.nextToken());
                    string2 = stringTokenizer.nextToken();
                    String string9 = string2.substring(1);
                    ArrayList<BeginEndRec> arrayList = (ArrayList<BeginEndRec>)hashMap4.get(string9);
                    if (arrayList == null) {
                        arrayList = new ArrayList<BeginEndRec>();
                        hashMap4.put(string9, arrayList);
                    }
                    arrayList.add(new BeginEndRec(n14, n13));
                }
                bufferedReader.close();
                for (int j = stringArray.length - 1; j >= 0; --j) {
                    int n15;
                    string8 = (String)this.hmcolor.get("" + stringArray[j]);
                    ArrayList arrayList = (ArrayList)hashMap4.get(stringArray[j]);
                    if (arrayList == null) continue;
                    n13 = (Integer)hashMap.get(objectArray[i]);
                    arrayList.add(new BeginEndRec(n13 - 1, n13));
                    int n16 = arrayList.size();
                    int n17 = ((BeginEndRec)arrayList.get((int)0)).nbegin;
                    int n18 = n13;
                    String string10 = (String)this.hmlabelExtend.get((String)hashMap2.get(stringArray[j]));
                    String string11 = string10 != null ? stringArray[j] + "_" + string10 : stringArray[j];
                    ((PrintWriter)object).print((String)object5 + "\t" + 0 + "\t" + n18 + "\t" + string11 + "\t0\t.\t" + n17 + "\t" + n18 + "\t" + string8 + "\t" + (n16 + 1) + "\t");
                    ((PrintWriter)object).print(0);
                    for (n15 = 0; n15 < n16; ++n15) {
                        BeginEndRec beginEndRec = (BeginEndRec)arrayList.get(n15);
                        int n19 = beginEndRec.nend - beginEndRec.nbegin;
                        ((PrintWriter)object).print(",");
                        ((PrintWriter)object).print(n19);
                    }
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).print(0);
                    for (n15 = 0; n15 < n16; ++n15) {
                        int n20 = ((BeginEndRec)arrayList.get((int)n15)).nbegin;
                        ((PrintWriter)object).print(",");
                        ((PrintWriter)object).print(n20);
                    }
                    ((PrintWriter)object).println();
                }
            }
            ((PrintWriter)object).close();
        }
    }

    static class LabelCompare
    implements Comparator,
    Serializable {
        LabelCompare() {
        }

        public int compare(Object object, Object object2) {
            String string = (String)object;
            String string2 = (String)object2;
            try {
                int n = Integer.parseInt(string);
                int n2 = Integer.parseInt(string2);
                if (n < n2) {
                    return -1;
                }
                if (n > n2) {
                    return 1;
                }
                return 0;
            }
            catch (NumberFormatException numberFormatException) {
                return string.compareTo(string2);
            }
        }
    }

    static class BeginEndRec {
        int nbegin;
        int nend;

        BeginEndRec(int n, int n2) {
            this.nbegin = n;
            this.nend = n2;
        }
    }
}

