## ----eval=FALSE---------------------------------------------------------------
# if (!requireNamespace("BiocManager", quietly=TRUE))
#     install.packages("BiocManager")
# BiocManager::install('biodbHmdb')

## ----results='hide'-----------------------------------------------------------
mybiodb <- biodb::newInst()

## -----------------------------------------------------------------------------
conn <- mybiodb$getFactory()$createConn('hmdb.metabolites')

## -----------------------------------------------------------------------------
dbExtract <- system.file("extdata", 'generated', "hmdb_extract.zip",
    package="biodbHmdb")
conn$setPropValSlot('urls', 'db.zip.url', dbExtract)

## -----------------------------------------------------------------------------
conn$getNbEntries()

## -----------------------------------------------------------------------------
ids <- conn$getEntryIds(2)
ids

## -----------------------------------------------------------------------------
entries <- conn$getEntry(ids)
entries

## -----------------------------------------------------------------------------
x <- mybiodb$entriesToDataframe(entries, compute=FALSE)
x

## -----------------------------------------------------------------------------
id <- conn$searchForEntries(list(name='1-Methylhistidine'), max.results=1)
id

## -----------------------------------------------------------------------------
conn$searchForEntries(list(name=c('propanoic', 'acid')), max.results=1)

## -----------------------------------------------------------------------------
entryDf <- conn$getEntry(id)$getFieldsAsDataframe(fields=c('accession', 'name'))

## ----entryByNameTable, echo=FALSE, results='asis'-----------------------------
knitr::kable(entryDf, "pipe", caption="The entry returned when searching by name.")

## -----------------------------------------------------------------------------
id <- conn$searchForEntries(list(description=c('Parkinson', 'sclerosis')), max.results=1)
id

## -----------------------------------------------------------------------------
entryDf <- conn$getEntry(id)$getFieldsAsDataframe(fields=c('accession', 'name', 'description'))

## ----entryByDescTable, echo=FALSE, results='asis'-----------------------------
knitr::kable(entryDf, "pipe", caption="The entry returned when searching by description.")

## -----------------------------------------------------------------------------
mybiodb$terminate()

## -----------------------------------------------------------------------------
sessionInfo()

