## ----setup, include=FALSE,echo=FALSE------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    cache = TRUE,
    out.width = "100%"
)
BHSimagePath <- function(name, branch = "devel") {
    if (curl::has_internet())
        glue::glue(
            "https://github.com/Bioconductor/BiocHubsShiny/blob/{branch}",
            "/vignettes/figures/{name}?raw=true"
        )
    else
        glue::glue("figures/{name}")
}

## ----eval=FALSE---------------------------------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# 
# BiocManager::install("BiocHubsShiny")

## ----include=TRUE,results="hide",message=FALSE,warning=FALSE------------------
library(BiocHubsShiny)

## ----eval=FALSE---------------------------------------------------------------
# BiocHubsShiny()

## ----echo=FALSE---------------------------------------------------------------
knitr::include_graphics(
    BHSimagePath("BiocHubsShiny.png")
)

## ----echo=FALSE---------------------------------------------------------------
knitr::include_graphics(
    BHSimagePath("MusMusculus.png")
)

## ----echo=FALSE---------------------------------------------------------------
knitr::include_graphics(
    BHSimagePath("MusMusculusSelection.png")
)

## ----echo=FALSE---------------------------------------------------------------
knitr::include_graphics(
    BHSimagePath("MusMusculusCode.png")
)

## -----------------------------------------------------------------------------
sessionInfo()

