/*
 *
 * Asteroids Player
 *
 * for the c't Competition 2008 (Creativ '08) 
 *
 * Copyright 2008, Volker Raum, Erlangen, Germany
 *
 */

package de.volkerraum.asteroids;

import de.volkerraum.asteroids.connection.MameConnection;
import de.volkerraum.asteroids.model.AsteroidsModel;
import de.volkerraum.asteroids.player.Player;
import de.volkerraum.asteroids.ui.RecordingControlFrame;
import de.volkerraum.asteroids.ui.ReplayControlFrame;
import de.volkerraum.asteroids.ui.VisualizationFrame;

public class HotShot
{
   private static final String OPTION_RECORD = "-record";
   private static final String OPTION_CONTINUOUS_RECORD = "-cont_record";
   private static final String OPTION_REPLAY = "-replay";
   private static final String OPTION_VISUALIZE = "-visual";

   public static boolean singleGameWanted = false;

   public static void main(String[] args)
   {
      if (args.length == 0)
      {
         System.err.println("SYNTAX : java -cp Asteroids.jar de.volkerraum.asteroids.HotShot <option> <Server-IP/MAMEMASTER.EXE>");
         System.err.println(" Options (" + OPTION_RECORD + " " + OPTION_REPLAY + " cannot be given together)");
         System.err.println(" " + OPTION_RECORD + " : record frames of the Server to the Harddisk (File : frames.aff)");
         System.err.println(" " + OPTION_REPLAY + " : replay recorded frames for analysis (File : frames.aff)");
         System.err.println(" " + OPTION_VISUALIZE + " : Display a Visualization Window");
         System.err.println(" " + OPTION_CONTINUOUS_RECORD
                            + " continously start the mameserver, play a game, kill the server and start again. Log results. Parameter is the path to the mameaster.exe.");
         System.err.println(" Giving no option means simple Operation. You have to give the host for remote play then.");
         return;
      }

      boolean recordWanted = false;
      boolean continuousRecordWanted = false;
      boolean replayWanted = false;
      boolean visualizationWanted = false;

      String serverName = args[args.length - 1];

      for (int i = 0; i < args.length - 1; ++i)
      {
         if (args[i].equals(OPTION_RECORD))
         {
            recordWanted = true;
         }
         else if (args[i].equals(OPTION_REPLAY))
         {
            replayWanted = true;
         }
         else if (args[i].equals(OPTION_VISUALIZE))
         {
            visualizationWanted = true; // 
         }
         else if (args[i].equals(OPTION_CONTINUOUS_RECORD))
         {
            continuousRecordWanted = true;
         }

      }
      if (!recordWanted && !replayWanted && !continuousRecordWanted && !visualizationWanted)
         singleGameWanted = true;

      AsteroidsModel model = new AsteroidsModel();
      Player player = null;
      if (replayWanted)
      {
         ReplayControlFrame frame = new ReplayControlFrame(model);
         frame.setSize(1024, 200);
         frame.setVisible(true);
         player = new Player(model);
      }
      else if (!continuousRecordWanted)
      {
         MameConnection conn = new MameConnection(serverName, 1979, model, recordWanted);
         if (recordWanted)
         {
            RecordingControlFrame frame = new RecordingControlFrame(conn);
            frame.pack();
            frame.setLocation(200, 200);
            frame.setVisible(true);
         }
         player = new Player(model);
      }
      else
      {
         MameRunner runner = new MameRunner(serverName);
         runner.start();
      }

      if (visualizationWanted)
      {
         VisualizationFrame frame = new VisualizationFrame(model, player);
         frame.setSize(1024, 768);
         frame.setLocation(0, 200);
         frame.setVisible(true);

      }

   }
}
