/*
 * Decompiled with CFR 0.152.
 */
package coursier.paths;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class Jep {
    private static final String locationLinePrefix = "Location: ";
    private static final String prefix = "jep-";
    private static final String suffix = ".jar";

    private static boolean existsInPath(String string2) {
        return Stream.of(System.getenv("PATH").split(Pattern.quote(File.pathSeparator))).map(string -> Paths.get(string, new String[0])).anyMatch(path -> Files.exists(path.resolve(string2), new LinkOption[0]));
    }

    private static String readFully(InputStream inputStream, Charset charset, int n) throws IOException {
        char[] cArray = new char[n];
        StringBuilder stringBuilder = new StringBuilder();
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);){
            int n2;
            while ((n2 = ((Reader)inputStreamReader).read(cArray, 0, cArray.length)) >= 0) {
                stringBuilder.append(cArray, 0, n2);
            }
        }
        return stringBuilder.toString();
    }

    public static File location() throws Exception {
        String string2 = System.getenv("JEP_LOCATION");
        if (string2 != null && !string2.isEmpty()) {
            return new File(string2);
        }
        String string3 = System.getProperty("jep.location");
        if (string3 != null && !string3.isEmpty()) {
            return new File(string3);
        }
        String string4 = "pip";
        if (Jep.existsInPath("pip3")) {
            string4 = "pip3";
        }
        ProcessBuilder processBuilder = new ProcessBuilder(string4, "show", "jep").redirectInput(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.INHERIT);
        Process process = processBuilder.start();
        process.getOutputStream().close();
        String string5 = Jep.readFully(process.getInputStream(), Charset.defaultCharset(), 1024);
        int n = process.waitFor();
        if (n != 0) {
            if (!string5.isEmpty()) {
                string5 = System.lineSeparator() + string5;
            }
            throw new JepException("Error running " + string4 + " show jep (return code: " + n + ")" + string5);
        }
        Optional<String> optional = Stream.of(string5.split(System.getProperty("line.separator"))).filter(string -> string.startsWith(locationLinePrefix)).findFirst();
        if (!optional.isPresent()) {
            throw new JepException("No location found in " + string4 + " show jep output:" + string5);
        }
        File file = new File(optional.get().substring(locationLinePrefix.length()));
        return new File(file, "jep");
    }

    public static File jar(File file2) throws JepException {
        File[] fileArray = file2.listFiles(file -> file.isFile() && file.getName().startsWith(prefix) && file.getName().endsWith(suffix));
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        if (fileArray.length == 1) {
            return fileArray[0];
        }
        StringBuilder stringBuilder = new StringBuilder("Found too many jars in " + file2 + ": ");
        boolean bl = true;
        for (File file3 : fileArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(file3.getName());
        }
        throw new JepException(stringBuilder.toString());
    }

    public static String version(File file) throws JepException {
        String string = file.getName();
        if (!string.startsWith(prefix)) {
            throw new JepException("Invalid jep jar name: " + file);
        }
        if (!string.endsWith(suffix)) {
            throw new JepException("Invalid jep jar name: " + file);
        }
        String string2 = string.substring(prefix.length(), string.length() - suffix.length());
        return string2;
    }

    public static String pythonHome() throws Exception {
        String string = System.getenv("PYTHONHOME");
        if (string != null && !string.isEmpty()) {
            return string;
        }
        String string2 = System.getProperty("python.home");
        if (string2 != null && !string2.isEmpty()) {
            return string2;
        }
        String string3 = "python";
        if (Jep.existsInPath("python3")) {
            string3 = "python3";
        }
        ProcessBuilder processBuilder = new ProcessBuilder(string3, "-c", "import sys;print(sys.prefix)").redirectInput(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.INHERIT);
        Process process = processBuilder.start();
        process.getOutputStream().close();
        String string4 = Jep.readFully(process.getInputStream(), Charset.defaultCharset(), 1024);
        int n = process.waitFor();
        if (n != 0) {
            if (!string4.isEmpty()) {
                string4 = System.lineSeparator() + string4;
            }
            throw new JepException("Error running " + string3 + " -c 'import sys; print(sys.prefix)' (return code: " + n + ")" + string4);
        }
        return string4.trim();
    }

    public static List<Map.Entry<String, String>> pythonProperties() throws Exception {
        String string = new File(new File(Jep.pythonHome()), "lib").getAbsolutePath();
        ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>();
        arrayList.add(new AbstractMap.SimpleEntry<String, String>("jna.library.path", string));
        arrayList.add(new AbstractMap.SimpleEntry<String, String>("jna.nosys", "false"));
        return arrayList;
    }

    public static class JepException
    extends Exception {
        public JepException(String string) {
            super(string);
        }
    }
}

