/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.ReverseCustomizer;
import org.apache.openjpa.jdbc.meta.ReverseMappingTool;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.lib.util.ClassUtil;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringUtil;

public class PropertiesReverseCustomizer
implements ReverseCustomizer {
    private static final Localizer _loc = Localizer.forPackage(PropertiesReverseCustomizer.class);
    protected ReverseMappingTool tool = null;
    private Properties _props = null;
    private Set _unaccessed = null;

    @Override
    public void setConfiguration(Properties props) {
        this._props = props;
        this._unaccessed = new TreeSet<Object>(props.keySet());
    }

    @Override
    public void setTool(ReverseMappingTool tool) {
        this.tool = tool;
    }

    @Override
    public int getTableType(Table table, int defaultType) {
        String type = this.getProperty(table.getName() + ".table-type");
        if (type == null && table.getSchemaName() != null) {
            type = this.getProperty(table.getFullName() + ".table-type");
        }
        if (type == null) {
            return defaultType;
        }
        if ("none".equals(type)) {
            return 0;
        }
        if ("base".equals(type)) {
            return 1;
        }
        if ("secondary".equals(type)) {
            return 2;
        }
        if ("secondary-outer".equals(type)) {
            return 3;
        }
        if ("association".equals(type)) {
            return 4;
        }
        if ("subclass".equals(type)) {
            return 5;
        }
        throw new IllegalArgumentException(table.getName() + ".table-type: " + type);
    }

    @Override
    public String getClassName(Table table, String defaultName) {
        String name = this.getProperty(defaultName + ".rename");
        if (name == null && (name = this.getProperty(table.getName() + ".class-name")) == null && table.getSchemaName() != null) {
            name = this.getProperty(table.getFullName() + ".class-name");
        }
        if (name == null) {
            if (this.tool.getLog().isTraceEnabled()) {
                this.tool.getLog().trace(_loc.get("custom-no-class", defaultName, table));
            }
            return defaultName;
        }
        if ("none".equals(name)) {
            if (this.tool.getLog().isInfoEnabled()) {
                this.tool.getLog().info(_loc.get("custom-rm-class", defaultName, table));
            }
            return null;
        }
        if (this.tool.getLog().isInfoEnabled()) {
            this.tool.getLog().info(_loc.get("custom-class", defaultName, name));
        }
        return name;
    }

    @Override
    public void customize(ClassMapping cls) {
        String id = this.getProperty(cls.getDescribedType().getName() + ".identity");
        if ("datastore".equals(id)) {
            cls.setObjectIdType(null, false);
            cls.setIdentityType(1);
        } else if ("builtin".equals(id)) {
            cls.setObjectIdType(null, false);
            cls.setIdentityType(2);
        } else if (id != null) {
            cls.setObjectIdType(this.tool.generateClass(id, null), false);
        }
    }

    @Override
    public String getClassCode(ClassMapping mapping) {
        return null;
    }

    @Override
    public void customize(FieldMapping field) {
        String type = this.getProperty(field.getFullName(false) + ".type");
        if (type != null) {
            field.setDeclaredType(ClassUtil.toClass(type, null));
        }
    }

    @Override
    public String getFieldName(ClassMapping dec, Column[] cols, ForeignKey fk, String defaultName) {
        String name = this.getProperty(dec.getDescribedType().getName() + "." + defaultName + ".rename");
        for (int i = 0; name == null && i < cols.length; ++i) {
            name = this.getProperty(cols[i].getTableName() + "." + cols[i].getName() + ".field-name");
            if (name != null || cols[i].getTable().getSchemaName() == null) continue;
            name = this.getProperty(cols[i].getTable().getFullName() + "." + cols[i].getName() + ".field-name");
        }
        if (name == null) {
            if (this.tool.getLog().isTraceEnabled()) {
                this.tool.getLog().trace(_loc.get("custom-no-field", defaultName, dec));
            }
            return defaultName;
        }
        if ("none".equals(name)) {
            if (this.tool.getLog().isInfoEnabled()) {
                this.tool.getLog().info(_loc.get("custom-rm-field", defaultName, dec));
            }
            return null;
        }
        if (this.tool.getLog().isInfoEnabled()) {
            this.tool.getLog().info(_loc.get("custom-field", defaultName, dec, name));
        }
        return name;
    }

    @Override
    public String getInitialValue(FieldMapping field) {
        return this.getProperty(field.getFullName(false) + ".value");
    }

    @Override
    public String getDeclaration(FieldMapping field) {
        return null;
    }

    @Override
    public String getFieldCode(FieldMapping field) {
        return null;
    }

    @Override
    public boolean unmappedTable(Table table) {
        return false;
    }

    @Override
    public void close() {
        if (!this._unaccessed.isEmpty() && this.tool.getLog().isTraceEnabled()) {
            this.tool.getLog().trace(_loc.get("custom-unused-props", this._unaccessed));
        }
    }

    protected String getProperty(String key) {
        String val = StringUtil.trimToNull(this._props.getProperty(key));
        this._unaccessed.remove(key);
        return val;
    }
}

