/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.cdi;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.security.enterprise.AuthenticationException;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.AutoApplySession;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.authentication.mechanism.http.LoginToContinue;
import jakarta.security.enterprise.identitystore.IdentityStoreHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.function.Supplier;
import org.apache.tomee.security.http.LoginToContinueMechanism;

@ApplicationScoped
@AutoApplySession
@LoginToContinue
public class CustomFormAuthenticationMechanism
implements HttpAuthenticationMechanism,
LoginToContinueMechanism {
    @Inject
    private Supplier<LoginToContinue> loginToContinue;
    @Inject
    private IdentityStoreHandler identityStoreHandler;

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        if (this.validateCredentials(httpMessageContext)) {
            return httpMessageContext.notifyContainerAboutLogin(this.identityStoreHandler.validate(httpMessageContext.getAuthParameters().getCredential()));
        }
        return httpMessageContext.doNothing();
    }

    @Override
    public LoginToContinue getLoginToContinue() {
        return this.loginToContinue.get();
    }

    private boolean validateCredentials(HttpMessageContext httpMessageContext) {
        return httpMessageContext.getAuthParameters().getCredential() != null;
    }
}

