/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow;

import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.faces.application.NavigationCase;
import jakarta.faces.context.FacesContext;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.flow.Freezable;

public class NavigationCaseImpl
extends NavigationCase
implements Freezable {
    private String _condition;
    private String _fromAction;
    private String _fromOutcome;
    private String _fromViewId;
    private String _toViewId;
    private String _toFlowDocumentId;
    private boolean _includeViewParams;
    private boolean _redirect;
    private Map<String, List<String>> _parameters;
    private ValueExpression _conditionExpression;
    private ValueExpression _toViewIdExpression;
    private boolean _initialized;

    public NavigationCaseImpl() {
        super(null, null, null, null, null, null, false, false);
    }

    public NavigationCaseImpl(String fromViewId, String fromAction, String fromOutcome, String condition, String toViewId, Map<String, List<String>> parameters, boolean redirect, boolean includeViewParams) {
        super(fromViewId, fromAction, fromOutcome, condition, toViewId, parameters, redirect, includeViewParams);
        this._condition = condition;
        this._fromViewId = fromViewId;
        this._fromAction = fromAction;
        this._fromOutcome = fromOutcome;
        this._toViewId = toViewId;
        this._toFlowDocumentId = null;
        this._redirect = redirect;
        this._includeViewParams = includeViewParams;
        this._parameters = parameters;
    }

    public NavigationCaseImpl(String fromViewId, String fromAction, String fromOutcome, String condition, String toViewId, String toFlowDocumentId, Map<String, List<String>> parameters, boolean redirect, boolean includeViewParams) {
        super(fromViewId, fromAction, fromOutcome, condition, toViewId, toFlowDocumentId, parameters, redirect, includeViewParams);
        this._condition = condition;
        this._fromViewId = fromViewId;
        this._fromAction = fromAction;
        this._fromOutcome = fromOutcome;
        this._toViewId = toViewId;
        this._toFlowDocumentId = toFlowDocumentId;
        this._redirect = redirect;
        this._includeViewParams = includeViewParams;
        this._parameters = parameters;
    }

    public String getCondition() {
        return this._condition;
    }

    public void setCondition(String condition) {
        this.checkInitialized();
        this._condition = condition;
    }

    public String getFromAction() {
        return this._fromAction;
    }

    public void setFromAction(String fromAction) {
        this.checkInitialized();
        this._fromAction = fromAction;
    }

    public String getFromOutcome() {
        return this._fromOutcome;
    }

    public void setFromOutcome(String fromOutcome) {
        this.checkInitialized();
        this._fromOutcome = fromOutcome;
    }

    public String getFromViewId() {
        return this._fromViewId;
    }

    public void setFromViewId(String fromViewId) {
        this.checkInitialized();
        this._fromViewId = fromViewId;
    }

    public String getToViewId() {
        return this._toViewId;
    }

    public void setToViewId(String toViewId) {
        this.checkInitialized();
        this._toViewId = toViewId;
    }

    public String getToFlowDocumentId() {
        return this._toFlowDocumentId;
    }

    public void setToFlowDocumentId(String toFlowDocumentId) {
        this.checkInitialized();
        this._toFlowDocumentId = toFlowDocumentId;
    }

    public boolean isIncludeViewParams() {
        return this._includeViewParams;
    }

    public void setIncludeViewParams(boolean includeViewParams) {
        this.checkInitialized();
        this._includeViewParams = includeViewParams;
    }

    public boolean isRedirect() {
        return this._redirect;
    }

    public void setRedirect(boolean redirect) {
        this.checkInitialized();
        this._redirect = redirect;
    }

    public Map<String, List<String>> getParameters() {
        return this._parameters;
    }

    public void setParameters(Map<String, List<String>> parameters) {
        this.checkInitialized();
        this._parameters = parameters;
    }

    public ValueExpression getConditionExpression() {
        return this._conditionExpression;
    }

    public void setConditionExpression(ValueExpression conditionExpression) {
        this.checkInitialized();
        this._conditionExpression = conditionExpression;
    }

    public ValueExpression getToViewIdExpression() {
        return this._toViewIdExpression;
    }

    public void setToViewIdExpression(ValueExpression toViewIdExpression) {
        this.checkInitialized();
        this._toViewIdExpression = toViewIdExpression;
    }

    public Boolean getCondition(FacesContext context) {
        if (this._condition == null) {
            return null;
        }
        ValueExpression expression = this._getConditionExpression(context);
        return Boolean.TRUE.equals(expression.getValue(context.getELContext()));
    }

    private ValueExpression _getConditionExpression(FacesContext context) {
        assert (this._condition != null);
        if (this._conditionExpression == null) {
            ExpressionFactory factory = context.getApplication().getExpressionFactory();
            this._conditionExpression = factory.createValueExpression(context.getELContext(), this._condition, Boolean.class);
        }
        return this._conditionExpression;
    }

    public String getToViewId(FacesContext context) {
        if (this._toViewId == null) {
            return null;
        }
        ValueExpression expression = this._getToViewIdExpression(context);
        return expression.isLiteralText() ? expression.getExpressionString() : (String)expression.getValue(context.getELContext());
    }

    private ValueExpression _getToViewIdExpression(FacesContext context) {
        assert (this._toViewId != null);
        if (this._toViewIdExpression == null) {
            ExpressionFactory factory = context.getApplication().getExpressionFactory();
            this._toViewIdExpression = factory.createValueExpression(context.getELContext(), this._toViewId, String.class);
        }
        return this._toViewIdExpression;
    }

    public boolean hasCondition() {
        return this._condition != null && this._condition.length() > 0;
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + (this._condition != null ? this._condition.hashCode() : 0);
        hash = 47 * hash + (this._fromAction != null ? this._fromAction.hashCode() : 0);
        hash = 47 * hash + (this._fromOutcome != null ? this._fromOutcome.hashCode() : 0);
        hash = 47 * hash + (this._fromViewId != null ? this._fromViewId.hashCode() : 0);
        hash = 47 * hash + (this._toViewId != null ? this._toViewId.hashCode() : 0);
        hash = 47 * hash + (this._toFlowDocumentId != null ? this._toFlowDocumentId.hashCode() : 0);
        hash = 47 * hash + (this._includeViewParams ? 1 : 0);
        hash = 47 * hash + (this._redirect ? 1 : 0);
        hash = 47 * hash + (this._parameters != null ? this._parameters.hashCode() : 0);
        hash = 47 * hash + (this._conditionExpression != null ? this._conditionExpression.hashCode() : 0);
        hash = 47 * hash + (this._toViewIdExpression != null ? this._toViewIdExpression.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NavigationCaseImpl other = (NavigationCaseImpl)obj;
        if (this._condition == null ? other._condition != null : !this._condition.equals(other._condition)) {
            return false;
        }
        if (this._fromAction == null ? other._fromAction != null : !this._fromAction.equals(other._fromAction)) {
            return false;
        }
        if (this._fromOutcome == null ? other._fromOutcome != null : !this._fromOutcome.equals(other._fromOutcome)) {
            return false;
        }
        if (this._fromViewId == null ? other._fromViewId != null : !this._fromViewId.equals(other._fromViewId)) {
            return false;
        }
        if (this._toViewId == null ? other._toViewId != null : !this._toViewId.equals(other._toViewId)) {
            return false;
        }
        if (this._toFlowDocumentId == null ? other._toFlowDocumentId != null : !this._toFlowDocumentId.equals(other._toFlowDocumentId)) {
            return false;
        }
        if (this._includeViewParams != other._includeViewParams) {
            return false;
        }
        if (this._redirect != other._redirect) {
            return false;
        }
        if (!(this._parameters == other._parameters || this._parameters != null && this._parameters.equals(other._parameters))) {
            return false;
        }
        if (!(this._conditionExpression == other._conditionExpression || this._conditionExpression != null && this._conditionExpression.equals((Object)other._conditionExpression))) {
            return false;
        }
        return this._toViewIdExpression == other._toViewIdExpression || this._toViewIdExpression != null && this._toViewIdExpression.equals((Object)other._toViewIdExpression);
    }

    @Override
    public void freeze() {
        this._initialized = true;
    }

    private void checkInitialized() throws IllegalStateException {
        if (this._initialized) {
            throw new IllegalStateException("Flow is inmutable once initialized");
        }
    }
}

