/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.assembler.classic.event.AssemblerBeforeApplicationDestroyed;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.config.event.EnhanceScannableUrlsEvent;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.observer.event.BeforeEvent;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.catalina.event.AfterApplicationCreated;
import org.apache.tomee.microprofile.health.MicroProfileHealthChecksEndpoint;
import org.apache.tomee.microprofile.openapi.MicroProfileOpenApiRegistration;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

public class TomEEMicroProfileListener {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB.createChild("tomcat"), TomEEMicroProfileListener.class);
    private final Map<AppInfo, Index> indexCache = new ConcurrentHashMap<AppInfo, Index>();

    public void enhanceScannableUrls(@Observes EnhanceScannableUrlsEvent enhanceScannableUrlsEvent) {
        String[] mpExtensions = SystemInstance.get().getOptions().get("tomee.mp.cdi.extensions", "").split(",");
        String mpScan = SystemInstance.get().getOptions().get("tomee.mp.scan", "none");
        if (mpScan.equals("none")) {
            Stream.of(mpExtensions).forEach(extension -> SystemInstance.get().setProperty(extension + ".active", "false"));
            return;
        }
        List containerUrls = enhanceScannableUrlsEvent.getScannableUrls();
        for (String extension2 : mpExtensions) {
            try {
                CodeSource src = Class.forName(extension2).getProtectionDomain().getCodeSource();
                if (src == null) continue;
                containerUrls.add(src.getLocation());
            }
            catch (ClassNotFoundException | IncompatibleClassChangeError | NoClassDefFoundError e) {
                LOGGER.error("Can't load MicroProfile extension " + extension2, e);
            }
        }
        containerUrls.add(this.getClass().getProtectionDomain().getCodeSource().getLocation());
        SystemInstance.get().setProperty("openejb.cxf-rs.cache-application", "false");
    }

    public void afterApplicationDeployed(@Observes BeforeEvent<AssemblerBeforeApplicationDestroyed> event) {
        this.indexCache.remove(((AssemblerBeforeApplicationDestroyed)event.getEvent()).getApp());
    }

    public void processApplication(@Observes BeforeEvent<AfterApplicationCreated> afterApplicationCreated) {
        if ("none".equals(SystemInstance.get().getOptions().get("tomee.mp.scan", "none"))) {
            return;
        }
        ServletContext context = ((AfterApplicationCreated)afterApplicationCreated.getEvent()).getContext();
        WebAppInfo webApp = ((AfterApplicationCreated)afterApplicationCreated.getEvent()).getWeb();
        context.getServletRegistrations().values().stream().map(ServletRegistration::getMappings).flatMap(Collection::stream).filter(mapping -> mapping.equals("/*")).findFirst().ifPresent(mapping -> webApp.restClass.removeIf(className -> className.equals(MicroProfileHealthChecksEndpoint.class.getName())));
        try {
            AppInfo app = ((AfterApplicationCreated)afterApplicationCreated.getEvent()).getApp();
            Index index = this.indexCache.computeIfAbsent(app, k -> {
                try {
                    return TomEEMicroProfileListener.of(app.libs);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            MicroProfileOpenApiRegistration.registerOpenApiServlet(context, (IndexView)index);
            int lastIndex = app.webApps.size() - 1;
            if (app.webApps.indexOf(((AfterApplicationCreated)afterApplicationCreated.getEvent()).getWeb()) == lastIndex) {
                this.indexCache.remove(app);
            }
        }
        catch (UncheckedIOException e) {
            throw new IllegalStateException("Can't build Jandex index for application " + webApp.contextRoot, e);
        }
    }

    public static Index of(List<String> files) throws IOException {
        Indexer indexer = new Indexer();
        if (files == null) {
            return indexer.complete();
        }
        Set fileSet = files.stream().map(File::new).filter(File::exists).collect(Collectors.toSet());
        for (File file : fileSet) {
            InputStream in;
            if (file == null) {
                throw new IllegalArgumentException("File must not be null");
            }
            if (file.isDirectory()) {
                List classFiles = Files.collect((File)file, (FileFilter)new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".class");
                    }
                });
                for (File classFile : classFiles) {
                    in = new FileInputStream(classFile);
                    try {
                        indexer.index(in);
                    }
                    finally {
                        in.close();
                    }
                }
                continue;
            }
            if (file.isFile() && file.getName().endsWith(".class")) {
                FileInputStream in2 = new FileInputStream(file);
                try {
                    indexer.index((InputStream)in2);
                    continue;
                }
                finally {
                    ((InputStream)in2).close();
                    continue;
                }
            }
            if (file.isFile() && file.getName().endsWith(".jar")) {
                if (NewLoaderLogic.skip((URL)file.toURI().toURL())) continue;
                JarFile jarFile = new JarFile(file);
                try {
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().endsWith(".class")) continue;
                        in = jarFile.getInputStream(entry);
                        try {
                            indexer.index(in);
                        }
                        finally {
                            if (in == null) continue;
                            in.close();
                        }
                    }
                    continue;
                }
                finally {
                    jarFile.close();
                    continue;
                }
            }
            LOGGER.warning("Can't add to Jandex index. Not a class file, JAR file or directory: " + String.valueOf(file));
        }
        return indexer.complete();
    }
}

