/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui;

import java.util.Collection;
import java.util.Collections;
import javax.swing.ImageIcon;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.Modifier;
import org.openide.util.ImageUtilities;

public final class Icons {
    private static final String ICON_BASE = "org/netbeans/modules/java/source/resources/icons/";
    private static final String GIF_EXTENSION = ".gif";
    private static final String PNG_EXTENSION = ".png";
    private static final String WAIT = "org/netbeans/modules/java/source/resources/icons/wait.png";

    private Icons() {
    }

    public static ImageIcon getBusyIcon() {
        ImageIcon icon = ImageUtilities.loadImageIcon(WAIT, false);
        return icon;
    }

    public static ImageIcon getElementIcon(ElementKind elementKind, Collection<Modifier> modifiers) {
        if (modifiers == null) {
            modifiers = Collections.emptyList();
        }
        ImageIcon icon = null;
        switch (elementKind) {
            case MODULE: {
                icon = ImageUtilities.loadImageIcon("org/netbeans/modules/java/source/resources/icons/module.png", false);
                break;
            }
            case PACKAGE: {
                icon = ImageUtilities.loadImageIcon("org/netbeans/modules/java/source/resources/icons/package.gif", false);
                break;
            }
            case ENUM: {
                icon = ImageUtilities.loadImageIcon("org/netbeans/modules/java/source/resources/icons/enum.png", false);
                break;
            }
            case ANNOTATION_TYPE: {
                icon = ImageUtilities.loadImageIcon("org/netbeans/modules/java/source/resources/icons/annotation.png", false);
                break;
            }
            case CLASS: {
                icon = ImageUtilities.loadImageIcon("org/netbeans/modules/java/source/resources/icons/class.png", false);
                break;
            }
            case INTERFACE: {
                icon = ImageUtilities.loadImageIcon("org/netbeans/modules/java/source/resources/icons/interface.png", false);
                break;
            }
            case FIELD: {
                icon = ImageUtilities.loadImageIcon(Icons.getIconName(elementKind, "org/netbeans/modules/java/source/resources/icons/field", PNG_EXTENSION, modifiers), false);
                break;
            }
            case ENUM_CONSTANT: {
                icon = ImageUtilities.loadImageIcon("org/netbeans/modules/java/source/resources/icons/constant.png", false);
                break;
            }
            case CONSTRUCTOR: {
                icon = ImageUtilities.loadImageIcon(Icons.getIconName(elementKind, "org/netbeans/modules/java/source/resources/icons/constructor", PNG_EXTENSION, modifiers), false);
                break;
            }
            case INSTANCE_INIT: 
            case STATIC_INIT: {
                icon = ImageUtilities.loadImageIcon(Icons.getIconName(elementKind, "org/netbeans/modules/java/source/resources/icons/initializer", PNG_EXTENSION, modifiers), false);
                break;
            }
            case METHOD: {
                icon = ImageUtilities.loadImageIcon(Icons.getIconName(elementKind, "org/netbeans/modules/java/source/resources/icons/method", PNG_EXTENSION, modifiers), false);
                break;
            }
            case RECORD: {
                icon = ImageUtilities.loadImageIcon("org/netbeans/modules/java/source/resources/icons/record.png", false);
                break;
            }
            case RECORD_COMPONENT: {
                icon = ImageUtilities.loadImageIcon("org/netbeans/modules/java/source/resources/icons/recordComponent.png", false);
                break;
            }
            default: {
                icon = null;
            }
        }
        return icon;
    }

    private static String getIconName(ElementKind kind, String typeName, String extension, Collection<Modifier> modifiers) {
        StringBuffer fileName = new StringBuffer(typeName);
        if (modifiers.contains((Object)Modifier.STATIC)) {
            fileName.append("Static");
        }
        if (modifiers.contains((Object)Modifier.ABSTRACT)) {
            fileName.append("Abstract");
        }
        if (modifiers.contains((Object)Modifier.DEFAULT)) {
            fileName.append("Default");
        }
        if (kind == ElementKind.STATIC_INIT || kind == ElementKind.INSTANCE_INIT) {
            return fileName.append(extension).toString();
        }
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            return fileName.append("Public").append(extension).toString();
        }
        if (modifiers.contains((Object)Modifier.PROTECTED)) {
            return fileName.append("Protected").append(extension).toString();
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            return fileName.append("Private").append(extension).toString();
        }
        return fileName.append("Package").append(extension).toString();
    }
}

