/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.response;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.ReasonPhraseCatalog;
import org.apache.http.StatusLine;
import org.apache.http.params.HttpParams;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.BasicStatusLine;
import org.apache.juneau.http.HttpEntities;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.header.HeaderList;

@BeanIgnore
public class BasicHttpException
extends BasicRuntimeException
implements HttpResponse {
    private static final long serialVersionUID = 1L;
    HeaderList headers = HeaderList.create();
    BasicStatusLine statusLine = new BasicStatusLine();
    HttpEntity content;

    public BasicHttpException() {
        super((Throwable)null);
    }

    public BasicHttpException(HttpResponse response) {
        super((Throwable)null);
        Header h = response.getLastHeader("Thrown");
        if (Utils.nn((Object)h)) {
            this.setMessage(HttpHeaders.thrown(h.getValue()).asParts().get().get(0).getMessage(), new Object[0]);
        }
        this.setHeaders(response.getAllHeaders());
        this.setContent(response.getEntity());
        this.setStatusCode(response.getStatusLine().getStatusCode());
    }

    public BasicHttpException(int statusCode) {
        super((Throwable)null);
        this.setStatusCode(statusCode);
    }

    public BasicHttpException(int statusCode, String msg, Object ... args) {
        super(msg, args);
        this.setStatusCode(statusCode);
    }

    public BasicHttpException(int statusCode, Throwable causedBy) {
        super(causedBy);
        this.setStatusCode(statusCode);
    }

    public BasicHttpException(int statusCode, Throwable cause, String msg, Object ... args) {
        super(cause, msg, args);
        this.setStatusCode(statusCode);
        this.setContent(Utils.f((String)msg, (Object[])args));
    }

    protected BasicHttpException(BasicHttpException copyFrom) {
        this(0, copyFrom.getCause(), copyFrom.getMessage(), new Object[0]);
        this.setStatusLine(copyFrom.statusLine.copy());
    }

    public void addHeader(Header value) {
        this.headers.append(value);
    }

    public void addHeader(String name, String value) {
        this.headers.append(name, value);
    }

    public boolean containsHeader(String name) {
        return this.headers.contains(name);
    }

    public Header[] getAllHeaders() {
        return this.headers.getAll();
    }

    public HttpEntity getEntity() {
        if (this.content == null) {
            this.content = HttpEntities.stringEntity(this.getMessage());
        }
        return this.content;
    }

    public Header getFirstHeader(String name) {
        return this.headers.getFirst(name).orElse(null);
    }

    public String getFullStackMessage(boolean scrubForXssVulnerabilities) {
        String msg = this.getMessage();
        StringBuilder sb = new StringBuilder();
        if (Utils.nn((Object)msg)) {
            if (scrubForXssVulnerabilities) {
                msg = msg.replace('<', ' ').replace('>', ' ').replace('&', ' ');
            }
            sb.append(msg);
        }
        Throwable e = this.getCause();
        while (Utils.nn((Object)e)) {
            msg = e.getMessage();
            if (Utils.nn((Object)msg) && scrubForXssVulnerabilities) {
                msg = msg.replace('<', ' ').replace('>', ' ').replace('&', ' ');
            }
            String cls = Utils.cns((Object)e);
            if (msg == null) {
                sb.append(Utils.f((String)"\nCaused by ({0})", (Object[])new Object[]{cls}));
            } else {
                sb.append(Utils.f((String)"\nCaused by ({0}): {1}", (Object[])new Object[]{cls, msg}));
            }
            e = e.getCause();
        }
        return sb.toString();
    }

    public HeaderList getHeaders() {
        return this.headers;
    }

    public Header[] getHeaders(String name) {
        return this.headers.getAll(name);
    }

    public Header getLastHeader(String name) {
        return this.headers.getLast(name).orElse(null);
    }

    public Locale getLocale() {
        return this.statusLine.getLocale();
    }

    public String getMessage() {
        String m = super.getMessage();
        if (m == null && Utils.nn((Object)this.getCause())) {
            m = this.getCause().getMessage();
        }
        if (m == null) {
            m = this.statusLine.getReasonPhrase();
        }
        return m;
    }

    public HttpParams getParams() {
        return null;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.statusLine.getProtocolVersion();
    }

    public Throwable getRootCause() {
        Object t = this;
        while (Utils.nn((Object)t)) {
            if (!(t instanceof BasicHttpException) && !(t instanceof InvocationTargetException)) {
                return t;
            }
            t = ((Throwable)t).getCause();
        }
        return null;
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public int hashCode() {
        int i = 0;
        Object t = this;
        while (Utils.nn((Object)t)) {
            for (StackTraceElement e : ((Throwable)t).getStackTrace()) {
                i ^= e.hashCode();
            }
            t = ((Throwable)t).getCause();
        }
        return i;
    }

    public HeaderIterator headerIterator() {
        return this.headers.headerIterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.headers.headerIterator(name);
    }

    public void removeHeader(Header value) {
        this.headers.remove(value);
    }

    public void removeHeaders(String name) {
        this.headers.remove(name);
    }

    public BasicHttpException setContent(HttpEntity value) {
        this.content = value;
        return this;
    }

    public BasicHttpException setContent(String value) {
        this.setContent(HttpEntities.stringEntity(value));
        return this;
    }

    public void setEntity(HttpEntity entity) {
        this.content = entity;
    }

    public void setHeader(Header value) {
        this.headers.set(value);
    }

    public void setHeader(String name, String value) {
        this.headers.set(name, value);
    }

    public BasicHttpException setHeader2(String name, Object value) {
        this.headers.set(name, value);
        return this;
    }

    public void setHeaders(Header[] values) {
        this.headers.removeAll().append(values);
    }

    public BasicHttpException setHeaders(HeaderList value) {
        this.headers = value.copy();
        return this;
    }

    public BasicHttpException setHeaders(List<Header> values) {
        this.headers.set(values);
        return this;
    }

    public BasicHttpException setHeaders2(Header ... values) {
        this.headers.set(values);
        return this;
    }

    public void setLocale(Locale loc) {
        this.statusLine.setLocale(loc);
    }

    public BasicHttpException setLocale2(Locale value) {
        this.statusLine.setLocale(value);
        return this;
    }

    public BasicHttpException setMessage(String message, Object ... args) {
        super.setMessage(message, args);
        return this;
    }

    public void setParams(HttpParams params) {
    }

    public BasicHttpException setProtocolVersion(ProtocolVersion value) {
        this.statusLine.setProtocolVersion(value);
        return this;
    }

    public void setReasonPhrase(String reason) throws IllegalStateException {
        this.statusLine.setReasonPhrase(reason);
    }

    public BasicHttpException setReasonPhrase2(String value) {
        this.statusLine.setReasonPhrase(value);
        return this;
    }

    public BasicHttpException setReasonPhraseCatalog(ReasonPhraseCatalog value) {
        this.statusLine.setReasonPhraseCatalog(value);
        return this;
    }

    public void setStatusCode(int code) throws IllegalStateException {
        this.statusLine.setStatusCode(code);
    }

    public BasicHttpException setStatusCode2(int code) throws IllegalStateException {
        this.setStatusCode(code);
        return this;
    }

    public BasicHttpException setStatusLine(BasicStatusLine value) {
        this.statusLine = value.copy();
        return this;
    }

    public void setStatusLine(ProtocolVersion ver, int code) {
        this.statusLine.setProtocolVersion(ver).setStatusCode(code);
    }

    public void setStatusLine(ProtocolVersion ver, int code, String reason) {
        this.statusLine.setProtocolVersion(ver).setReasonPhrase(reason).setStatusCode(code);
    }

    public void setStatusLine(StatusLine value) {
        this.setStatusLine(value.getProtocolVersion(), value.getStatusCode(), value.getReasonPhrase());
    }

    public BasicHttpException setUnmodifiable() {
        this.statusLine.setUnmodifiable();
        return this;
    }

    public String toString() {
        return Utils.emptyIfNull((Object)this.getLocalizedMessage());
    }

    protected void assertStatusCode(HttpResponse response) throws AssertionError {
        AssertionUtils.assertArgNotNull((String)"response", (Object)response);
        int expected = this.getStatusLine().getStatusCode();
        int actual = response.getStatusLine().getStatusCode();
        Assertions.assertInteger((Integer)actual).setMsg("Unexpected status code.  Expected:[{0}], Actual:[{1}]", new Object[]{expected, actual}).is((Object)expected);
    }
}

