/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.net;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.NameValuePairListMatcher;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.Host;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.PercentCodec;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.net.URIBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestURIBuilder {
    private static final String CH_HELLO = "Gr\u00fcezi_z\u00e4m\u00e4";
    private static final String RU_HELLO = "\u0412\u0441\u0435\u043c_\u043f\u0440\u0438\u0432\u0435\u0442";

    TestURIBuilder() {
    }

    static List<String> parsePath(CharSequence s) {
        return URIBuilder.parsePath((CharSequence)s, null);
    }

    @Test
    void testParseSegments() {
        MatcherAssert.assertThat(TestURIBuilder.parsePath("/this/that"), (Matcher)CoreMatchers.equalTo(Arrays.asList("this", "that")));
        MatcherAssert.assertThat(TestURIBuilder.parsePath("this/that"), (Matcher)CoreMatchers.equalTo(Arrays.asList("this", "that")));
        MatcherAssert.assertThat(TestURIBuilder.parsePath("this//that"), (Matcher)CoreMatchers.equalTo(Arrays.asList("this", "", "that")));
        MatcherAssert.assertThat(TestURIBuilder.parsePath("this//that/"), (Matcher)CoreMatchers.equalTo(Arrays.asList("this", "", "that", "")));
        MatcherAssert.assertThat(TestURIBuilder.parsePath("this//that/%2fthis%20and%20that"), (Matcher)CoreMatchers.equalTo(Arrays.asList("this", "", "that", "/this and that")));
        MatcherAssert.assertThat(TestURIBuilder.parsePath("this///that//"), (Matcher)CoreMatchers.equalTo(Arrays.asList("this", "", "", "that", "", "")));
        MatcherAssert.assertThat(TestURIBuilder.parsePath("/"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("")));
        MatcherAssert.assertThat(TestURIBuilder.parsePath(""), (Matcher)CoreMatchers.equalTo(Collections.emptyList()));
    }

    static String formatPath(String ... pathSegments) {
        StringBuilder buf = new StringBuilder();
        URIBuilder.formatPath((StringBuilder)buf, Arrays.asList(pathSegments), (boolean)false, null);
        return buf.toString();
    }

    @Test
    void testFormatSegments() {
        MatcherAssert.assertThat((Object)TestURIBuilder.formatPath("this", "that"), (Matcher)CoreMatchers.equalTo((Object)"/this/that"));
        MatcherAssert.assertThat((Object)TestURIBuilder.formatPath("this", "", "that"), (Matcher)CoreMatchers.equalTo((Object)"/this//that"));
        MatcherAssert.assertThat((Object)TestURIBuilder.formatPath("this", "", "that", "/this and that"), (Matcher)CoreMatchers.equalTo((Object)"/this//that/%2Fthis%20and%20that"));
        MatcherAssert.assertThat((Object)TestURIBuilder.formatPath("this", "", "", "that", "", ""), (Matcher)CoreMatchers.equalTo((Object)"/this///that//"));
        MatcherAssert.assertThat((Object)TestURIBuilder.formatPath(""), (Matcher)CoreMatchers.equalTo((Object)"/"));
        MatcherAssert.assertThat((Object)TestURIBuilder.formatPath(new String[0]), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    static List<NameValuePair> parseQuery(CharSequence s) {
        return URIBuilder.parseQuery((CharSequence)s, null, (boolean)false);
    }

    @Test
    void testParseQuery() {
        MatcherAssert.assertThat(TestURIBuilder.parseQuery(""), NameValuePairListMatcher.isEmpty());
        MatcherAssert.assertThat(TestURIBuilder.parseQuery("Name0"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name0", null)}));
        MatcherAssert.assertThat(TestURIBuilder.parseQuery("Name1=Value1"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name1", "Value1")}));
        MatcherAssert.assertThat(TestURIBuilder.parseQuery("Name2="), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name2", "")}));
        MatcherAssert.assertThat(TestURIBuilder.parseQuery(" Name3  "), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name3", null)}));
        MatcherAssert.assertThat(TestURIBuilder.parseQuery("Name4=Value%204%21"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name4", "Value 4!")}));
        MatcherAssert.assertThat(TestURIBuilder.parseQuery("Name4=Value%2B4%21"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name4", "Value+4!")}));
        MatcherAssert.assertThat(TestURIBuilder.parseQuery("Name4=Value%204%21%20%214"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name4", "Value 4! !4")}));
        MatcherAssert.assertThat(TestURIBuilder.parseQuery("Name5=aaa&Name6=bbb"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name5", "aaa"), new BasicNameValuePair("Name6", "bbb")}));
        MatcherAssert.assertThat(TestURIBuilder.parseQuery("Name7=aaa&Name7=b%2Cb&Name7=ccc"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name7", "aaa"), new BasicNameValuePair("Name7", "b,b"), new BasicNameValuePair("Name7", "ccc")}));
        MatcherAssert.assertThat(TestURIBuilder.parseQuery("Name8=xx%2C%20%20yy%20%20%2Czz"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name8", "xx,  yy  ,zz")}));
        MatcherAssert.assertThat(TestURIBuilder.parseQuery("price=10%20%E2%82%AC"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("price", "10 \u20ac")}));
        MatcherAssert.assertThat(TestURIBuilder.parseQuery("a=b\"c&d=e"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("a", "b\"c"), new BasicNameValuePair("d", "e")}));
        MatcherAssert.assertThat(TestURIBuilder.parseQuery("russian=" + PercentCodec.encode((CharSequence)RU_HELLO, (Charset)StandardCharsets.UTF_8) + "&swiss=" + PercentCodec.encode((CharSequence)CH_HELLO, (Charset)StandardCharsets.UTF_8)), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("russian", RU_HELLO), new BasicNameValuePair("swiss", CH_HELLO)}));
    }

    static String formatQuery(NameValuePair ... params) {
        StringBuilder buf = new StringBuilder();
        URIBuilder.formatQuery((StringBuilder)buf, Arrays.asList(params), null, (boolean)false);
        return buf.toString();
    }

    @Test
    void testFormatQuery() {
        MatcherAssert.assertThat((Object)TestURIBuilder.formatQuery(new NameValuePair[]{new BasicNameValuePair("Name0", null)}), (Matcher)CoreMatchers.equalTo((Object)"Name0"));
        MatcherAssert.assertThat((Object)TestURIBuilder.formatQuery(new NameValuePair[]{new BasicNameValuePair("Name1", "Value1")}), (Matcher)CoreMatchers.equalTo((Object)"Name1=Value1"));
        MatcherAssert.assertThat((Object)TestURIBuilder.formatQuery(new NameValuePair[]{new BasicNameValuePair("Name2", "")}), (Matcher)CoreMatchers.equalTo((Object)"Name2="));
        MatcherAssert.assertThat((Object)TestURIBuilder.formatQuery(new NameValuePair[]{new BasicNameValuePair("Name4", "Value 4&")}), (Matcher)CoreMatchers.equalTo((Object)"Name4=Value%204%26"));
        MatcherAssert.assertThat((Object)TestURIBuilder.formatQuery(new NameValuePair[]{new BasicNameValuePair("Name4", "Value+4&")}), (Matcher)CoreMatchers.equalTo((Object)"Name4=Value%2B4%26"));
        MatcherAssert.assertThat((Object)TestURIBuilder.formatQuery(new NameValuePair[]{new BasicNameValuePair("Name4", "Value 4& =4")}), (Matcher)CoreMatchers.equalTo((Object)"Name4=Value%204%26%20%3D4"));
        MatcherAssert.assertThat((Object)TestURIBuilder.formatQuery(new NameValuePair[]{new BasicNameValuePair("Name5", "aaa"), new BasicNameValuePair("Name6", "bbb")}), (Matcher)CoreMatchers.equalTo((Object)"Name5=aaa&Name6=bbb"));
        MatcherAssert.assertThat((Object)TestURIBuilder.formatQuery(new NameValuePair[]{new BasicNameValuePair("Name7", "aaa"), new BasicNameValuePair("Name7", "b,b"), new BasicNameValuePair("Name7", "ccc")}), (Matcher)CoreMatchers.equalTo((Object)"Name7=aaa&Name7=b%2Cb&Name7=ccc"));
        MatcherAssert.assertThat((Object)TestURIBuilder.formatQuery(new NameValuePair[]{new BasicNameValuePair("Name8", "xx,  yy  ,zz")}), (Matcher)CoreMatchers.equalTo((Object)"Name8=xx%2C%20%20yy%20%20%2Czz"));
        MatcherAssert.assertThat((Object)TestURIBuilder.formatQuery(new NameValuePair[]{new BasicNameValuePair("russian", RU_HELLO), new BasicNameValuePair("swiss", CH_HELLO)}), (Matcher)CoreMatchers.equalTo((Object)("russian=" + PercentCodec.encode((CharSequence)RU_HELLO, (Charset)StandardCharsets.UTF_8) + "&swiss=" + PercentCodec.encode((CharSequence)CH_HELLO, (Charset)StandardCharsets.UTF_8))));
    }

    @Test
    void testHierarchicalUri() throws Exception {
        URI uri = new URI("http", "stuff", "localhost", 80, "/some stuff", "param=stuff", "fragment");
        URIBuilder uribuilder = new URIBuilder(uri);
        URI result = uribuilder.build();
        Assertions.assertEquals((Object)new URI("http://stuff@localhost:80/some%20stuff?param=stuff#fragment"), (Object)result);
    }

    @Test
    void testMutationRemoveFragment() throws Exception {
        URI uri = new URI("http://stuff@localhost:80/stuff?param=stuff#fragment");
        URI result = new URIBuilder(uri).setFragment(null).build();
        Assertions.assertEquals((Object)new URI("http://stuff@localhost:80/stuff?param=stuff"), (Object)result);
    }

    @Test
    void testMutationRemoveUserInfo() throws Exception {
        URI uri = new URI("http://stuff@localhost:80/stuff?param=stuff#fragment");
        URI result = new URIBuilder(uri).setUserInfo(null).build();
        Assertions.assertEquals((Object)new URI("http://localhost:80/stuff?param=stuff#fragment"), (Object)result);
    }

    @Test
    void testMutationRemovePort() throws Exception {
        URI uri = new URI("http://stuff@localhost:80/stuff?param=stuff#fragment");
        URI result = new URIBuilder(uri).setPort(-1).build();
        Assertions.assertEquals((Object)new URI("http://stuff@localhost/stuff?param=stuff#fragment"), (Object)result);
    }

    @Test
    void testOpaqueUri() throws Exception {
        URI uri = new URI("stuff", "some-stuff", "fragment");
        URIBuilder uribuilder = new URIBuilder(uri);
        URI result = uribuilder.build();
        Assertions.assertEquals((Object)uri, (Object)result);
    }

    @Test
    void testOpaqueUriMutation() throws Exception {
        URI uri = new URI("stuff", "some-stuff", "fragment");
        URIBuilder uribuilder = new URIBuilder(uri).setCustomQuery("param1&param2=stuff").setFragment(null);
        Assertions.assertEquals((Object)new URI("stuff:?param1&param2=stuff"), (Object)uribuilder.build());
    }

    @Test
    void testHierarchicalUriMutation() throws Exception {
        URIBuilder uribuilder = new URIBuilder("/").setScheme("http").setHost("localhost").setPort(80).setPath("/stuff");
        Assertions.assertEquals((Object)new URI("http://localhost:80/stuff"), (Object)uribuilder.build());
    }

    @Test
    void testLocalhost() throws Exception {
        String scheme = "https";
        InetAddress host = InetAddress.getLocalHost();
        String specials = "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz";
        URI uri = new URI("https", "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz", host.getHostAddress(), 80, "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz", "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz", "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz");
        URI bld = URIBuilder.localhost().setScheme("https").setUserInfo("/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz").setPath("/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz").setCustomQuery("/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz").setFragment("/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz").build();
        Assertions.assertEquals((Object)uri.getHost(), (Object)bld.getHost());
        Assertions.assertEquals((Object)uri.getUserInfo(), (Object)bld.getUserInfo());
        Assertions.assertEquals((Object)uri.getPath(), (Object)bld.getPath());
        Assertions.assertEquals((Object)uri.getQuery(), (Object)bld.getQuery());
        Assertions.assertEquals((Object)uri.getFragment(), (Object)bld.getFragment());
    }

    @Test
    void testLoopbackAddress() throws Exception {
        String scheme = "https";
        InetAddress host = InetAddress.getLoopbackAddress();
        String specials = "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz";
        URI uri = new URI("https", "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz", host.getHostAddress(), 80, "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz", "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz", "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz");
        URI bld = URIBuilder.loopbackAddress().setScheme("https").setUserInfo("/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz").setPath("/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz").setCustomQuery("/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz").setFragment("/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz").build();
        Assertions.assertEquals((Object)uri.getHost(), (Object)bld.getHost());
        Assertions.assertEquals((Object)uri.getUserInfo(), (Object)bld.getUserInfo());
        Assertions.assertEquals((Object)uri.getPath(), (Object)bld.getPath());
        Assertions.assertEquals((Object)uri.getQuery(), (Object)bld.getQuery());
        Assertions.assertEquals((Object)uri.getFragment(), (Object)bld.getFragment());
    }

    @Test
    void testEmpty() throws Exception {
        URIBuilder uribuilder = new URIBuilder();
        URI result = uribuilder.build();
        Assertions.assertEquals((Object)new URI(""), (Object)result);
    }

    @Test
    void testEmptyPath() throws Exception {
        URIBuilder uribuilder = new URIBuilder("http://thathost");
        Assertions.assertTrue((boolean)uribuilder.isPathEmpty());
    }

    @Test
    void testRemoveParameter() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/", "param=stuff&blah&blah", null);
        URIBuilder uribuilder = new URIBuilder(uri);
        Assertions.assertFalse((boolean)uribuilder.isQueryEmpty());
        Assertions.assertThrows(NullPointerException.class, () -> uribuilder.removeParameter(null));
        uribuilder.removeParameter("DoesNotExist");
        Assertions.assertEquals((Object)"stuff", (Object)uribuilder.getFirstQueryParam("param").getValue());
        Assertions.assertNull((Object)uribuilder.getFirstQueryParam("blah").getValue());
        uribuilder.removeParameter("blah");
        Assertions.assertEquals((Object)"stuff", (Object)uribuilder.getFirstQueryParam("param").getValue());
        Assertions.assertNull((Object)uribuilder.getFirstQueryParam("blah"));
        uribuilder.removeParameter("param");
        Assertions.assertNull((Object)uribuilder.getFirstQueryParam("param"));
        Assertions.assertTrue((boolean)uribuilder.isQueryEmpty());
        uribuilder.removeParameter("AlreadyEmpty");
        Assertions.assertTrue((boolean)uribuilder.isQueryEmpty());
        Assertions.assertEquals((Object)new URI("http://localhost:80/"), (Object)uribuilder.build());
    }

    @Test
    void testRemoveQuery() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/", "param=stuff", null);
        URIBuilder uribuilder = new URIBuilder(uri).removeQuery();
        URI result = uribuilder.build();
        Assertions.assertEquals((Object)new URI("http://localhost:80/"), (Object)result);
    }

    @Test
    void testSetAuthorityFromNamedEndpointHost() throws Exception {
        Host host = Host.create((String)"localhost:88");
        URIBuilder uribuilder = new URIBuilder().setScheme(URIScheme.HTTP.id).setAuthority((NamedEndpoint)host);
        Assertions.assertNull((Object)uribuilder.getUserInfo());
        Assertions.assertEquals((Object)host.getHostName(), (Object)uribuilder.getAuthority().getHostName());
        Assertions.assertEquals((Object)host.getHostName(), (Object)uribuilder.getHost());
        URI result = uribuilder.build();
        Assertions.assertEquals((Object)host.getHostName(), (Object)result.getHost());
        Assertions.assertEquals((int)host.getPort(), (int)result.getPort());
        Assertions.assertEquals((Object)new URI("http://localhost:88"), (Object)result);
    }

    @Test
    void testSetAuthorityFromNamedEndpointHttpHost() throws Exception {
        HttpHost httpHost = HttpHost.create((String)"localhost:88");
        URIBuilder uribuilder = new URIBuilder().setScheme(URIScheme.HTTP.id).setAuthority((NamedEndpoint)httpHost);
        Assertions.assertNull((Object)uribuilder.getUserInfo());
        Assertions.assertEquals((Object)httpHost.getHostName(), (Object)uribuilder.getAuthority().getHostName());
        Assertions.assertEquals((Object)httpHost.getHostName(), (Object)uribuilder.getHost());
        URI result = uribuilder.build();
        Assertions.assertEquals((Object)httpHost.getHostName(), (Object)result.getHost());
        Assertions.assertEquals((int)httpHost.getPort(), (int)result.getPort());
        Assertions.assertEquals((Object)new URI("http://localhost:88"), (Object)result);
    }

    @Test
    void testSetAuthorityFromURIAuthority() throws Exception {
        URIAuthority authority = URIAuthority.create((String)"u:p@localhost:88");
        URIBuilder uribuilder = new URIBuilder().setScheme(URIScheme.HTTP.id).setAuthority(authority);
        Assertions.assertEquals((Object)authority.getUserInfo(), (Object)uribuilder.getAuthority().getUserInfo());
        Assertions.assertEquals((Object)authority.getHostName(), (Object)uribuilder.getAuthority().getHostName());
        Assertions.assertEquals((Object)authority.getHostName(), (Object)uribuilder.getHost());
        URI result = uribuilder.build();
        Assertions.assertEquals((Object)authority.getUserInfo(), (Object)result.getUserInfo());
        Assertions.assertEquals((Object)authority.getHostName(), (Object)result.getHost());
        Assertions.assertEquals((int)authority.getPort(), (int)result.getPort());
        Assertions.assertEquals((Object)authority.toString(), (Object)result.getAuthority());
        Assertions.assertEquals((Object)new URI("http://u:p@localhost:88"), (Object)result);
    }

    @Test
    void testSetParameter() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/", "param=stuff&blah&blah", null);
        URIBuilder uribuilder = new URIBuilder(uri).setParameter("param", "some other stuff").setParameter("blah", "blah").setParameter("blah", "blah2");
        URI result = uribuilder.build();
        Assertions.assertEquals((Object)new URI("http://localhost:80/?param=some%20other%20stuff&blah=blah2"), (Object)result);
    }

    @Test
    void testGetFirstNamedParameter() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/", "param=stuff&blah&blah", null);
        URIBuilder uribuilder = new URIBuilder(uri).setParameter("param", "some other stuff").setParameter("blah", "blah");
        Assertions.assertEquals((Object)"some other stuff", (Object)uribuilder.getFirstQueryParam("param").getValue());
        Assertions.assertEquals((Object)"blah", (Object)uribuilder.getFirstQueryParam("blah").getValue());
        Assertions.assertNull((Object)uribuilder.getFirstQueryParam("DoesNotExist"));
        uribuilder = new URIBuilder("http://localhost:80/?param=some%20other%20stuff&blah=blah&blah=blah2");
        Assertions.assertEquals((Object)"blah", (Object)uribuilder.getFirstQueryParam("blah").getValue());
        uribuilder.removeQuery();
        Assertions.assertNull((Object)uribuilder.getFirstQueryParam("param"));
    }

    @Test
    void testSetParametersWithEmptyArrayArg() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/test", "param=test", null);
        URIBuilder uribuilder = new URIBuilder(uri).setParameters(new NameValuePair[0]);
        URI result = uribuilder.build();
        Assertions.assertEquals((Object)new URI("http://localhost:80/test"), (Object)result);
    }

    @Test
    void testSetParametersWithNullArrayArg() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/test", "param=test", null);
        URIBuilder uribuilder = new URIBuilder(uri).setParameters((NameValuePair[])null);
        URI result = uribuilder.build();
        Assertions.assertEquals((Object)new URI("http://localhost:80/test"), (Object)result);
    }

    @Test
    void testSetParametersWithEmptyList() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/test", "param=test", null);
        URIBuilder uribuilder = new URIBuilder(uri).setParameters(Collections.emptyList());
        URI result = uribuilder.build();
        Assertions.assertEquals((Object)new URI("http://localhost:80/test"), (Object)result);
    }

    @Test
    void testSetParametersWithNullList() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/test", "param=test", null);
        URIBuilder uribuilder = new URIBuilder(uri).setParameters((List)null);
        URI result = uribuilder.build();
        Assertions.assertEquals((Object)new URI("http://localhost:80/test"), (Object)result);
    }

    @Test
    void testParameterWithSpecialChar() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/", "param=stuff", null);
        URIBuilder uribuilder = new URIBuilder(uri).addParameter("param", "1 + 1 = 2").addParameter("param", "blah&blah");
        URI result = uribuilder.build();
        Assertions.assertEquals((Object)new URI("http://localhost:80/?param=stuff&param=1%20%2B%201%20%3D%202&param=blah%26blah"), (Object)result);
    }

    @Test
    void testAddParameter() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/", "param=stuff&blah&blah", null);
        URIBuilder uribuilder = new URIBuilder(uri).addParameter("param", "some other stuff").addParameter("blah", "blah");
        URI result = uribuilder.build();
        Assertions.assertEquals((Object)new URI("http://localhost:80/?param=stuff&blah&blah&param=some%20other%20stuff&blah=blah"), (Object)result);
    }

    @Test
    void testQueryEncoding() throws Exception {
        URI uri1 = new URI("https://somehost.com/stuff?client_id=1234567890&redirect_uri=https%3A%2F%2Fsomehost.com%2Fblah%20blah%2F");
        URI uri2 = new URIBuilder("https://somehost.com/stuff").addParameter("client_id", "1234567890").addParameter("redirect_uri", "https://somehost.com/blah blah/").build();
        Assertions.assertEquals((Object)uri1, (Object)uri2);
    }

    @Test
    void testQueryAndParameterEncoding() throws Exception {
        URI uri1 = new URI("https://somehost.com/stuff?param1=12345&param2=67890");
        URI uri2 = new URIBuilder("https://somehost.com/stuff").setCustomQuery("this&that").addParameter("param1", "12345").addParameter("param2", "67890").build();
        Assertions.assertEquals((Object)uri1, (Object)uri2);
    }

    @Test
    void testPathEncoding() throws Exception {
        URI uri1 = new URI("https://somehost.com/some%20path%20with%20blanks/");
        URI uri2 = new URIBuilder().setScheme("https").setHost("somehost.com").setPath("/some path with blanks/").build();
        Assertions.assertEquals((Object)uri1, (Object)uri2);
    }

    @Test
    void testAgainstURI() throws Exception {
        String scheme = "https";
        String host = "localhost";
        String specials = "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz";
        URI uri = new URI("https", "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz", "localhost", 80, "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz", "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz", "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz");
        URI bld = new URIBuilder().setScheme("https").setHost("localhost").setUserInfo("/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz").setPath("/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz").setCustomQuery("/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz").setFragment("/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz").build();
        Assertions.assertEquals((Object)uri.getHost(), (Object)bld.getHost());
        Assertions.assertEquals((Object)uri.getUserInfo(), (Object)bld.getUserInfo());
        Assertions.assertEquals((Object)uri.getPath(), (Object)bld.getPath());
        Assertions.assertEquals((Object)uri.getQuery(), (Object)bld.getQuery());
        Assertions.assertEquals((Object)uri.getFragment(), (Object)bld.getFragment());
    }

    @Test
    void testBuildAddParametersUTF8() throws Exception {
        this.assertAddParameters(StandardCharsets.UTF_8);
    }

    @Test
    void testBuildAddParametersISO88591() throws Exception {
        this.assertAddParameters(StandardCharsets.ISO_8859_1);
    }

    void assertAddParameters(Charset charset) throws Exception {
        URI uri = new URIBuilder("https://somehost.com/stuff").setCharset(charset).addParameters(this.createParameterList()).build();
        this.assertBuild(charset, uri);
        URI uri2 = new URIBuilder("https://somehost.com/stuff").setCharset(charset).addParameters(null).build();
        Assertions.assertEquals((Object)"https://somehost.com/stuff", (Object)uri2.toString());
    }

    @Test
    void testBuildSetParametersUTF8() throws Exception {
        this.assertSetParameters(StandardCharsets.UTF_8);
    }

    @Test
    void testBuildSetParametersISO88591() throws Exception {
        this.assertSetParameters(StandardCharsets.ISO_8859_1);
    }

    void assertSetParameters(Charset charset) throws Exception {
        URI uri = new URIBuilder("https://somehost.com/stuff").setCharset(charset).setParameters(this.createParameterList()).build();
        this.assertBuild(charset, uri);
    }

    void assertBuild(Charset charset, URI uri) {
        String encodedData1 = PercentCodec.encode((CharSequence)"\"1\u00aa position\"", (Charset)charset);
        String encodedData2 = PercentCodec.encode((CharSequence)"Jos\u00e9 Abra\u00e3o", (Charset)charset);
        String uriExpected = String.format("https://somehost.com/stuff?parameter1=value1&parameter2=%s&parameter3=%s", encodedData1, encodedData2);
        Assertions.assertEquals((Object)uriExpected, (Object)uri.toString());
    }

    private List<NameValuePair> createParameterList() {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("parameter1", "value1"));
        parameters.add((NameValuePair)new BasicNameValuePair("parameter2", "\"1\u00aa position\""));
        parameters.add((NameValuePair)new BasicNameValuePair("parameter3", "Jos\u00e9 Abra\u00e3o"));
        return parameters;
    }

    @Test
    void testMalformedPath() throws Exception {
        String path = "@notexample.com/mypath";
        URI uri = new URIBuilder("@notexample.com/mypath").setHost("example.com").build();
        Assertions.assertEquals((Object)"example.com", (Object)uri.getHost());
    }

    @Test
    void testRelativePath() throws Exception {
        URI uri = new URIBuilder("./mypath").build();
        Assertions.assertEquals((Object)new URI("./mypath"), (Object)uri);
    }

    @Test
    void testRelativePathWithAuthority() throws Exception {
        URI uri = new URIBuilder("./mypath").setHost("somehost").setScheme("http").build();
        Assertions.assertEquals((Object)new URI("http://somehost/./mypath"), (Object)uri);
    }

    @Test
    void testTolerateNullInput() throws Exception {
        MatcherAssert.assertThat((Object)new URIBuilder().setScheme(null).setHost("localhost").setUserInfo(null).setPort(8443).setPath(null).setCustomQuery(null).setFragment(null).build(), (Matcher)CoreMatchers.equalTo((Object)URI.create("//localhost:8443")));
    }

    @Test
    void testTolerateBlankInput() throws Exception {
        MatcherAssert.assertThat((Object)new URIBuilder().setScheme("").setHost("localhost").setUserInfo("").setPort(8443).setPath("").setPath("").setCustomQuery("").setFragment("").build(), (Matcher)CoreMatchers.equalTo((Object)URI.create("//localhost:8443")));
    }

    @Test
    void testHttpHost() throws Exception {
        HttpHost httpHost = new HttpHost("http", "example.com", 1234);
        URIBuilder uribuilder = new URIBuilder();
        uribuilder.setHttpHost(httpHost);
        Assertions.assertEquals((Object)URI.create("http://example.com:1234"), (Object)uribuilder.build());
    }

    @Test
    void testSetHostWithReservedChars() throws Exception {
        URIBuilder uribuilder = new URIBuilder();
        uribuilder.setScheme("http").setHost("!example!.com");
        Assertions.assertEquals((Object)URI.create("http://%21example%21.com"), (Object)uribuilder.build());
    }

    @Test
    void testGetHostWithReservedChars() throws Exception {
        URIBuilder uribuilder = new URIBuilder("http://someuser%21@%21example%21.com/");
        Assertions.assertEquals((Object)"!example!.com", (Object)uribuilder.getHost());
        Assertions.assertEquals((Object)"someuser!", (Object)uribuilder.getUserInfo());
    }

    @Test
    void testMultipleLeadingPathSlashes() throws Exception {
        URI uri = new URIBuilder().setScheme("ftp").setHost("somehost").setPath("//blah//blah").build();
        MatcherAssert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)URI.create("ftp://somehost//blah//blah")));
    }

    @Test
    void testNoAuthorityAndPath() throws Exception {
        URI uri = new URIBuilder().setScheme("file").setPath("/blah").build();
        MatcherAssert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)URI.create("file:/blah")));
    }

    @Test
    void testSetPathSegmentList() throws Exception {
        URI uri = new URIBuilder().setScheme("https").setHost("somehost").setPathSegments(Arrays.asList("api", "products")).build();
        MatcherAssert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)URI.create("https://somehost/api/products")));
    }

    @Test
    void testSetPathSegmentsVarargs() throws Exception {
        URI uri = new URIBuilder().setScheme("https").setHost("somehost").setPathSegments(new String[]{"api", "products"}).build();
        MatcherAssert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)URI.create("https://somehost/api/products")));
    }

    @Test
    void testSetPathSegmentsRootlessList() throws Exception {
        URI uri = new URIBuilder().setScheme("file").setPathSegmentsRootless(Arrays.asList("dir", "foo")).build();
        MatcherAssert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)URI.create("file:dir/foo")));
    }

    @Test
    void testSetPathSegmentsRootlessVarargs() throws Exception {
        URI uri = new URIBuilder().setScheme("file").setPathSegmentsRootless(new String[]{"dir", "foo"}).build();
        MatcherAssert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)URI.create("file:dir/foo")));
    }

    @Test
    void testAppendToExistingPath() throws Exception {
        URI uri = new URIBuilder().setScheme("https").setHost("somehost").setPath("api").appendPath("v1/resources").appendPath("idA").build();
        MatcherAssert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)URI.create("https://somehost/api/v1/resources/idA")));
    }

    @Test
    void testAppendToNonExistingPath() throws Exception {
        URI uri = new URIBuilder().setScheme("https").setHost("somehost").appendPath("api/v2/customers").appendPath("idA").build();
        MatcherAssert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)URI.create("https://somehost/api/v2/customers/idA")));
    }

    @Test
    void testAppendNullToExistingPath() throws Exception {
        URI uri = new URIBuilder().setScheme("https").setHost("somehost").setPath("api").appendPath(null).build();
        MatcherAssert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)URI.create("https://somehost/api")));
    }

    @Test
    void testAppendNullToNonExistingPath() throws Exception {
        URI uri = new URIBuilder().setScheme("https").setHost("somehost").appendPath(null).build();
        MatcherAssert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)URI.create("https://somehost")));
    }

    @Test
    void testAppendSegmentsVarargsToExistingPath() throws Exception {
        URI uri = new URIBuilder().setScheme("https").setHost("myhost").setPath("api").appendPathSegments(new String[]{"v3", "products"}).appendPathSegments(new String[]{"idA"}).build();
        MatcherAssert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)URI.create("https://myhost/api/v3/products/idA")));
    }

    @Test
    void testAppendSegmentsVarargsToNonExistingPath() throws Exception {
        URI uri = new URIBuilder().setScheme("https").setHost("somehost").appendPathSegments(new String[]{"api", "v2", "customers"}).appendPathSegments(new String[]{"idA"}).build();
        MatcherAssert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)URI.create("https://somehost/api/v2/customers/idA")));
    }

    @Test
    void testAppendNullSegmentsVarargs() throws Exception {
        Object pathSegment = null;
        URI uri = new URIBuilder().setScheme("https").setHost("somehost").appendPathSegments(new String[]{pathSegment}).build();
        MatcherAssert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)URI.create("https://somehost/")));
    }

    @Test
    void testAppendSegmentsListToExistingPath() throws Exception {
        URI uri = new URIBuilder().setScheme("http").setHost("myhost").setPath("api").appendPathSegments(Arrays.asList("v3", "products")).build();
        MatcherAssert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)URI.create("http://myhost/api/v3/products")));
    }

    @Test
    void testAppendSegmentsListToNonExistingPath() throws Exception {
        URI uri = new URIBuilder().setScheme("http").setHost("myhost").appendPathSegments(Arrays.asList("api", "v3", "customers")).build();
        MatcherAssert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)URI.create("http://myhost/api/v3/customers")));
    }

    @Test
    void testAppendNullSegmentsList() throws Exception {
        List pathSegments = null;
        URI uri = new URIBuilder().setScheme("http").setHost("myhost").appendPathSegments(pathSegments).build();
        MatcherAssert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)URI.create("http://myhost")));
    }

    @Test
    void testNoAuthorityAndPathSegments() throws Exception {
        URI uri = new URIBuilder().setScheme("file").setPathSegments(new String[]{"this", "that"}).build();
        MatcherAssert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)URI.create("file:/this/that")));
    }

    @Test
    void testNoAuthorityAndRootlessPath() throws Exception {
        URI uri = new URIBuilder().setScheme("file").setPath("blah").build();
        MatcherAssert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)URI.create("file:blah")));
    }

    @Test
    void testNoAuthorityAndRootlessPathSegments() throws Exception {
        URI uri = new URIBuilder().setScheme("file").setPathSegmentsRootless(new String[]{"this", "that"}).build();
        MatcherAssert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)URI.create("file:this/that")));
    }

    @Test
    void testOpaque() throws Exception {
        URIBuilder uriBuilder = new URIBuilder("http://host.com");
        URI uri = uriBuilder.build();
        MatcherAssert.assertThat((Object)uriBuilder.isOpaque(), (Matcher)CoreMatchers.equalTo((Object)uri.isOpaque()));
    }

    @Test
    void testAddParameterEncodingEquivalence() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/", "param=stuff with spaces", null);
        URIBuilder uribuilder = new URIBuilder().setScheme("http").setHost("localhost").setPort(80).setPath("/").addParameter("param", "stuff with spaces");
        URI result = uribuilder.build();
        Assertions.assertEquals((Object)uri, (Object)result);
    }

    @Test
    void testSchemeSpecificPartParametersNull() throws Exception {
        URIBuilder uribuilder = new URIBuilder("http://host.com").setParameter("par", "parvalue").setSchemeSpecificPart("", new NameValuePair[]{null});
        Assertions.assertEquals((Object)new URI("http://host.com?par=parvalue"), (Object)uribuilder.build());
    }

    @Test
    void testSchemeSpecificPartSetGet() {
        URIBuilder uribuilder = new URIBuilder().setSchemeSpecificPart("specificpart");
        Assertions.assertEquals((Object)"specificpart", (Object)uribuilder.getSchemeSpecificPart());
    }

    @Test
    void testSchemeSpecificPartNameValuePairByRFC6068Sample() throws Exception {
        URIBuilder uribuilder = new URIBuilder().setScheme("mailto").setSchemeSpecificPart("my@email.server", new NameValuePair[]{new BasicNameValuePair("subject", "mail subject")});
        String result = uribuilder.build().toString();
        Assertions.assertTrue((boolean)result.contains("my@email.server"), (String)"mail address as scheme specific part expected");
        Assertions.assertTrue((boolean)result.contains("mail%20subject"), (String)"correct parameter encoding expected for that scheme");
    }

    @Test
    void testSchemeSpecificPartNameValuePairListByRFC6068Sample() throws Exception {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("subject", "mail subject"));
        URIBuilder uribuilder = new URIBuilder().setScheme("mailto").setSchemeSpecificPart("my@email.server", parameters);
        String result = uribuilder.build().toString();
        Assertions.assertTrue((boolean)result.contains("my@email.server"), (String)"mail address as scheme specific part expected");
        Assertions.assertTrue((boolean)result.contains("mail%20subject"), (String)"correct parameter encoding expected for that scheme");
    }

    @Test
    void testOptimize() throws Exception {
        Assertions.assertEquals((Object)"example://a/b/c/%7Bfoo%7D", (Object)new URIBuilder("eXAMPLE://a/./b/../b/%63/%7bfoo%7d").optimize().build().toASCIIString());
        Assertions.assertEquals((Object)"http://www.example.com/%3C", (Object)new URIBuilder("http://www.example.com/%3c").optimize().build().toASCIIString());
        Assertions.assertEquals((Object)"http://www.example.com/", (Object)new URIBuilder("HTTP://www.EXAMPLE.com/").optimize().build().toASCIIString());
        Assertions.assertEquals((Object)"http://www.example.com/a%2F", (Object)new URIBuilder("http://www.example.com/a%2f").optimize().build().toASCIIString());
        Assertions.assertEquals((Object)"http://www.example.com/?a%2F", (Object)new URIBuilder("http://www.example.com/?a%2f").optimize().build().toASCIIString());
        Assertions.assertEquals((Object)"http://www.example.com/?q=%26", (Object)new URIBuilder("http://www.example.com/?q=%26").optimize().build().toASCIIString());
        Assertions.assertEquals((Object)"http://www.example.com/%23?q=%26", (Object)new URIBuilder("http://www.example.com/%23?q=%26").optimize().build().toASCIIString());
        Assertions.assertEquals((Object)"http://www.example.com/blah-%28%20-blah-%20%26%20-blah-%20%29-blah/", (Object)new URIBuilder("http://www.example.com/blah-%28%20-blah-%20&%20-blah-%20)-blah/").optimize().build().toASCIIString());
        Assertions.assertEquals((Object)"../../.././", (Object)new URIBuilder("../../.././").optimize().build().toASCIIString());
        Assertions.assertEquals((Object)"file:../../.././", (Object)new URIBuilder("file:../../.././").optimize().build().toASCIIString());
        Assertions.assertEquals((Object)"http://host/", (Object)new URIBuilder("http://host/../../.././").optimize().build().toASCIIString());
        Assertions.assertThrows(URISyntaxException.class, () -> new URIBuilder("http:///../../.././").optimize().build().toASCIIString());
    }

    @Test
    void testIpv6Host() throws Exception {
        URIBuilder builder = new URIBuilder("https://[::1]:432/path");
        URI uri = builder.build();
        Assertions.assertEquals((int)432, (int)builder.getPort());
        Assertions.assertEquals((int)432, (int)uri.getPort());
        Assertions.assertEquals((Object)"https", (Object)builder.getScheme());
        Assertions.assertEquals((Object)"https", (Object)uri.getScheme());
        Assertions.assertEquals((Object)"::1", (Object)builder.getHost());
        Assertions.assertEquals((Object)"[::1]", (Object)uri.getHost());
        Assertions.assertEquals((Object)"/path", (Object)builder.getPath());
        Assertions.assertEquals((Object)"/path", (Object)uri.getPath());
    }

    @Test
    void testIpv6HostWithPortUpdate() throws Exception {
        URIBuilder builder = new URIBuilder("https://[::1]:432/path").setPort(123);
        URI uri = builder.build();
        Assertions.assertEquals((int)123, (int)builder.getPort());
        Assertions.assertEquals((int)123, (int)uri.getPort());
        Assertions.assertEquals((Object)"https", (Object)builder.getScheme());
        Assertions.assertEquals((Object)"https", (Object)uri.getScheme());
        Assertions.assertEquals((Object)"::1", (Object)builder.getHost());
        Assertions.assertEquals((Object)"[::1]", (Object)uri.getHost());
        Assertions.assertEquals((Object)"/path", (Object)builder.getPath());
        Assertions.assertEquals((Object)"/path", (Object)uri.getPath());
    }

    @Test
    void testBuilderWithUnbracketedIpv6Host() throws Exception {
        URIBuilder builder = new URIBuilder().setScheme("https").setHost("::1").setPort(443).setPath("/path");
        URI uri = builder.build();
        Assertions.assertEquals((Object)"https", (Object)builder.getScheme());
        Assertions.assertEquals((Object)"https", (Object)uri.getScheme());
        Assertions.assertEquals((int)443, (int)builder.getPort());
        Assertions.assertEquals((int)443, (int)uri.getPort());
        Assertions.assertEquals((Object)"::1", (Object)builder.getHost());
        Assertions.assertEquals((Object)"[::1]", (Object)uri.getHost());
        Assertions.assertEquals((Object)"/path", (Object)builder.getPath());
        Assertions.assertEquals((Object)"/path", (Object)uri.getPath());
    }

    @Test
    void testHttpsUriWithEmptyHost() {
        URIBuilder uribuilder = new URIBuilder().setScheme("https").setUserInfo("stuff").setHost("").setPort(80).setPath("/some stuff").setParameter("param", "stuff").setFragment("fragment");
        Assertions.assertThrows(URISyntaxException.class, () -> ((URIBuilder)uribuilder).build());
    }

    @Test
    void testHttpUriWithEmptyHost() {
        URIBuilder uribuilder = new URIBuilder().setScheme("http").setUserInfo("stuff").setHost("").setPort(80).setPath("/some stuff").setParameter("param", "stuff").setFragment("fragment");
        Assertions.assertThrows(URISyntaxException.class, () -> ((URIBuilder)uribuilder).build());
    }
}

