/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.groovy.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Map utilities.
 * @since 2.5.0
 */
public class Maps {

    public static <K, V> Map<K, V> of(K k1, V v1) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81, K k82, V v82) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);
        map.put(k82, v82);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81, K k82, V v82, K k83, V v83) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);
        map.put(k82, v82);
        map.put(k83, v83);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81, K k82, V v82, K k83, V v83, K k84, V v84) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);
        map.put(k82, v82);
        map.put(k83, v83);
        map.put(k84, v84);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81, K k82, V v82, K k83, V v83, K k84, V v84, K k85, V v85) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);
        map.put(k82, v82);
        map.put(k83, v83);
        map.put(k84, v84);
        map.put(k85, v85);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81, K k82, V v82, K k83, V v83, K k84, V v84, K k85, V v85, K k86, V v86) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);
        map.put(k82, v82);
        map.put(k83, v83);
        map.put(k84, v84);
        map.put(k85, v85);
        map.put(k86, v86);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81, K k82, V v82, K k83, V v83, K k84, V v84, K k85, V v85, K k86, V v86, K k87, V v87) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);
        map.put(k82, v82);
        map.put(k83, v83);
        map.put(k84, v84);
        map.put(k85, v85);
        map.put(k86, v86);
        map.put(k87, v87);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81, K k82, V v82, K k83, V v83, K k84, V v84, K k85, V v85, K k86, V v86, K k87, V v87, K k88, V v88) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);
        map.put(k82, v82);
        map.put(k83, v83);
        map.put(k84, v84);
        map.put(k85, v85);
        map.put(k86, v86);
        map.put(k87, v87);
        map.put(k88, v88);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81, K k82, V v82, K k83, V v83, K k84, V v84, K k85, V v85, K k86, V v86, K k87, V v87, K k88, V v88, K k89, V v89) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);
        map.put(k82, v82);
        map.put(k83, v83);
        map.put(k84, v84);
        map.put(k85, v85);
        map.put(k86, v86);
        map.put(k87, v87);
        map.put(k88, v88);
        map.put(k89, v89);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81, K k82, V v82, K k83, V v83, K k84, V v84, K k85, V v85, K k86, V v86, K k87, V v87, K k88, V v88, K k89, V v89, K k90, V v90) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);
        map.put(k82, v82);
        map.put(k83, v83);
        map.put(k84, v84);
        map.put(k85, v85);
        map.put(k86, v86);
        map.put(k87, v87);
        map.put(k88, v88);
        map.put(k89, v89);
        map.put(k90, v90);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81, K k82, V v82, K k83, V v83, K k84, V v84, K k85, V v85, K k86, V v86, K k87, V v87, K k88, V v88, K k89, V v89, K k90, V v90, K k91, V v91) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);
        map.put(k82, v82);
        map.put(k83, v83);
        map.put(k84, v84);
        map.put(k85, v85);
        map.put(k86, v86);
        map.put(k87, v87);
        map.put(k88, v88);
        map.put(k89, v89);
        map.put(k90, v90);
        map.put(k91, v91);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81, K k82, V v82, K k83, V v83, K k84, V v84, K k85, V v85, K k86, V v86, K k87, V v87, K k88, V v88, K k89, V v89, K k90, V v90, K k91, V v91, K k92, V v92) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);
        map.put(k82, v82);
        map.put(k83, v83);
        map.put(k84, v84);
        map.put(k85, v85);
        map.put(k86, v86);
        map.put(k87, v87);
        map.put(k88, v88);
        map.put(k89, v89);
        map.put(k90, v90);
        map.put(k91, v91);
        map.put(k92, v92);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81, K k82, V v82, K k83, V v83, K k84, V v84, K k85, V v85, K k86, V v86, K k87, V v87, K k88, V v88, K k89, V v89, K k90, V v90, K k91, V v91, K k92, V v92, K k93, V v93) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);
        map.put(k82, v82);
        map.put(k83, v83);
        map.put(k84, v84);
        map.put(k85, v85);
        map.put(k86, v86);
        map.put(k87, v87);
        map.put(k88, v88);
        map.put(k89, v89);
        map.put(k90, v90);
        map.put(k91, v91);
        map.put(k92, v92);
        map.put(k93, v93);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81, K k82, V v82, K k83, V v83, K k84, V v84, K k85, V v85, K k86, V v86, K k87, V v87, K k88, V v88, K k89, V v89, K k90, V v90, K k91, V v91, K k92, V v92, K k93, V v93, K k94, V v94) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);
        map.put(k82, v82);
        map.put(k83, v83);
        map.put(k84, v84);
        map.put(k85, v85);
        map.put(k86, v86);
        map.put(k87, v87);
        map.put(k88, v88);
        map.put(k89, v89);
        map.put(k90, v90);
        map.put(k91, v91);
        map.put(k92, v92);
        map.put(k93, v93);
        map.put(k94, v94);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81, K k82, V v82, K k83, V v83, K k84, V v84, K k85, V v85, K k86, V v86, K k87, V v87, K k88, V v88, K k89, V v89, K k90, V v90, K k91, V v91, K k92, V v92, K k93, V v93, K k94, V v94, K k95, V v95) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);
        map.put(k82, v82);
        map.put(k83, v83);
        map.put(k84, v84);
        map.put(k85, v85);
        map.put(k86, v86);
        map.put(k87, v87);
        map.put(k88, v88);
        map.put(k89, v89);
        map.put(k90, v90);
        map.put(k91, v91);
        map.put(k92, v92);
        map.put(k93, v93);
        map.put(k94, v94);
        map.put(k95, v95);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81, K k82, V v82, K k83, V v83, K k84, V v84, K k85, V v85, K k86, V v86, K k87, V v87, K k88, V v88, K k89, V v89, K k90, V v90, K k91, V v91, K k92, V v92, K k93, V v93, K k94, V v94, K k95, V v95, K k96, V v96) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);
        map.put(k82, v82);
        map.put(k83, v83);
        map.put(k84, v84);
        map.put(k85, v85);
        map.put(k86, v86);
        map.put(k87, v87);
        map.put(k88, v88);
        map.put(k89, v89);
        map.put(k90, v90);
        map.put(k91, v91);
        map.put(k92, v92);
        map.put(k93, v93);
        map.put(k94, v94);
        map.put(k95, v95);
        map.put(k96, v96);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81, K k82, V v82, K k83, V v83, K k84, V v84, K k85, V v85, K k86, V v86, K k87, V v87, K k88, V v88, K k89, V v89, K k90, V v90, K k91, V v91, K k92, V v92, K k93, V v93, K k94, V v94, K k95, V v95, K k96, V v96, K k97, V v97) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);
        map.put(k82, v82);
        map.put(k83, v83);
        map.put(k84, v84);
        map.put(k85, v85);
        map.put(k86, v86);
        map.put(k87, v87);
        map.put(k88, v88);
        map.put(k89, v89);
        map.put(k90, v90);
        map.put(k91, v91);
        map.put(k92, v92);
        map.put(k93, v93);
        map.put(k94, v94);
        map.put(k95, v95);
        map.put(k96, v96);
        map.put(k97, v97);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81, K k82, V v82, K k83, V v83, K k84, V v84, K k85, V v85, K k86, V v86, K k87, V v87, K k88, V v88, K k89, V v89, K k90, V v90, K k91, V v91, K k92, V v92, K k93, V v93, K k94, V v94, K k95, V v95, K k96, V v96, K k97, V v97, K k98, V v98) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);
        map.put(k82, v82);
        map.put(k83, v83);
        map.put(k84, v84);
        map.put(k85, v85);
        map.put(k86, v86);
        map.put(k87, v87);
        map.put(k88, v88);
        map.put(k89, v89);
        map.put(k90, v90);
        map.put(k91, v91);
        map.put(k92, v92);
        map.put(k93, v93);
        map.put(k94, v94);
        map.put(k95, v95);
        map.put(k96, v96);
        map.put(k97, v97);
        map.put(k98, v98);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81, K k82, V v82, K k83, V v83, K k84, V v84, K k85, V v85, K k86, V v86, K k87, V v87, K k88, V v88, K k89, V v89, K k90, V v90, K k91, V v91, K k92, V v92, K k93, V v93, K k94, V v94, K k95, V v95, K k96, V v96, K k97, V v97, K k98, V v98, K k99, V v99) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);
        map.put(k82, v82);
        map.put(k83, v83);
        map.put(k84, v84);
        map.put(k85, v85);
        map.put(k86, v86);
        map.put(k87, v87);
        map.put(k88, v88);
        map.put(k89, v89);
        map.put(k90, v90);
        map.put(k91, v91);
        map.put(k92, v92);
        map.put(k93, v93);
        map.put(k94, v94);
        map.put(k95, v95);
        map.put(k96, v96);
        map.put(k97, v97);
        map.put(k98, v98);
        map.put(k99, v99);

        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24, K k25, V v25, K k26, V v26, K k27, V v27, K k28, V v28, K k29, V v29, K k30, V v30, K k31, V v31, K k32, V v32, K k33, V v33, K k34, V v34, K k35, V v35, K k36, V v36, K k37, V v37, K k38, V v38, K k39, V v39, K k40, V v40, K k41, V v41, K k42, V v42, K k43, V v43, K k44, V v44, K k45, V v45, K k46, V v46, K k47, V v47, K k48, V v48, K k49, V v49, K k50, V v50, K k51, V v51, K k52, V v52, K k53, V v53, K k54, V v54, K k55, V v55, K k56, V v56, K k57, V v57, K k58, V v58, K k59, V v59, K k60, V v60, K k61, V v61, K k62, V v62, K k63, V v63, K k64, V v64, K k65, V v65, K k66, V v66, K k67, V v67, K k68, V v68, K k69, V v69, K k70, V v70, K k71, V v71, K k72, V v72, K k73, V v73, K k74, V v74, K k75, V v75, K k76, V v76, K k77, V v77, K k78, V v78, K k79, V v79, K k80, V v80, K k81, V v81, K k82, V v82, K k83, V v83, K k84, V v84, K k85, V v85, K k86, V v86, K k87, V v87, K k88, V v88, K k89, V v89, K k90, V v90, K k91, V v91, K k92, V v92, K k93, V v93, K k94, V v94, K k95, V v95, K k96, V v96, K k97, V v97, K k98, V v98, K k99, V v99, K k100, V v100) {
        Map<K, V> map = new LinkedHashMap<K, V>();

        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        map.put(k25, v25);
        map.put(k26, v26);
        map.put(k27, v27);
        map.put(k28, v28);
        map.put(k29, v29);
        map.put(k30, v30);
        map.put(k31, v31);
        map.put(k32, v32);
        map.put(k33, v33);
        map.put(k34, v34);
        map.put(k35, v35);
        map.put(k36, v36);
        map.put(k37, v37);
        map.put(k38, v38);
        map.put(k39, v39);
        map.put(k40, v40);
        map.put(k41, v41);
        map.put(k42, v42);
        map.put(k43, v43);
        map.put(k44, v44);
        map.put(k45, v45);
        map.put(k46, v46);
        map.put(k47, v47);
        map.put(k48, v48);
        map.put(k49, v49);
        map.put(k50, v50);
        map.put(k51, v51);
        map.put(k52, v52);
        map.put(k53, v53);
        map.put(k54, v54);
        map.put(k55, v55);
        map.put(k56, v56);
        map.put(k57, v57);
        map.put(k58, v58);
        map.put(k59, v59);
        map.put(k60, v60);
        map.put(k61, v61);
        map.put(k62, v62);
        map.put(k63, v63);
        map.put(k64, v64);
        map.put(k65, v65);
        map.put(k66, v66);
        map.put(k67, v67);
        map.put(k68, v68);
        map.put(k69, v69);
        map.put(k70, v70);
        map.put(k71, v71);
        map.put(k72, v72);
        map.put(k73, v73);
        map.put(k74, v74);
        map.put(k75, v75);
        map.put(k76, v76);
        map.put(k77, v77);
        map.put(k78, v78);
        map.put(k79, v79);
        map.put(k80, v80);
        map.put(k81, v81);
        map.put(k82, v82);
        map.put(k83, v83);
        map.put(k84, v84);
        map.put(k85, v85);
        map.put(k86, v86);
        map.put(k87, v87);
        map.put(k88, v88);
        map.put(k89, v89);
        map.put(k90, v90);
        map.put(k91, v91);
        map.put(k92, v92);
        map.put(k93, v93);
        map.put(k94, v94);
        map.put(k95, v95);
        map.put(k96, v96);
        map.put(k97, v97);
        map.put(k98, v98);
        map.put(k99, v99);
        map.put(k100, v100);

        return Collections.unmodifiableMap(map);
    }

    /**
     * Returns the inverse view of this map, and duplicated key is not allowed
     *
     * @param map the map to inverse
     * @param <K> key type
     * @param <V> value type
     * @return the inverse view of this map
     */
    public static <K, V> Map<V, K> inverse(Map<K, V> map) {
        return inverse(map, false);
    }

    /**
     * Returns the inverse view of this map
     *
     * @param map the map to inverse
     * @param force whether to put anyway even if duplicated key exists
     * @param <K> key type
     * @param <V> value type
     * @return the inverse view of this map
     */
    public static <K, V> Map<V, K> inverse(Map<K, V> map, boolean force) {
        // Because we can not rely on 3rd party library(excluding antlr, asm), we have to implement our own utils such as the `inverse` method...
        // Actually `BiMap` of Guava and `BidiMap` of commons-collections are both suitable for this scenario.

        Map<V, K> resultMap = new LinkedHashMap<>();

        for (Map.Entry<K, V> entry : map.entrySet()) {
            V value = entry.getValue();

            if (!force && resultMap.containsKey(value)) {
                throw new IllegalArgumentException("duplicated key found: " + value);
            }

            resultMap.put(value, entry.getKey());
        }

        return Collections.unmodifiableMap(resultMap);
    }

    private Maps() {}
}
