/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.inference;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.stat.inference.ChiSquareTest;
import org.junit.Assert;
import org.junit.Test;

public class ChiSquareTestTest {
    protected ChiSquareTest testStatistic = new ChiSquareTest();

    @Test
    public void testChiSquare() {
        long[] observed = new long[]{10L, 9L, 11L};
        double[] expected = new double[]{10.0, 10.0, 10.0};
        Assert.assertEquals((String)"chi-square statistic", (double)0.2, (double)this.testStatistic.chiSquare(expected, observed), (double)1.0E-11);
        Assert.assertEquals((String)"chi-square p-value", (double)0.904837418036, (double)this.testStatistic.chiSquareTest(expected, observed), (double)1.0E-10);
        long[] observed1 = new long[]{500L, 623L, 72L, 70L, 31L};
        double[] expected1 = new double[]{485.0, 541.0, 82.0, 61.0, 37.0};
        Assert.assertEquals((String)"chi-square test statistic", (double)9.023307936427388, (double)this.testStatistic.chiSquare(expected1, observed1), (double)1.0E-10);
        Assert.assertEquals((String)"chi-square p-value", (double)0.06051952647453607, (double)this.testStatistic.chiSquareTest(expected1, observed1), (double)1.0E-9);
        Assert.assertTrue((String)"chi-square test reject", (boolean)this.testStatistic.chiSquareTest(expected1, observed1, 0.08));
        Assert.assertTrue((String)"chi-square test accept", (!this.testStatistic.chiSquareTest(expected1, observed1, 0.05) ? 1 : 0) != 0);
        try {
            this.testStatistic.chiSquareTest(expected1, observed1, 95.0);
            Assert.fail((String)"alpha out of range, OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        long[] tooShortObs = new long[]{0L};
        double[] tooShortEx = new double[]{1.0};
        try {
            this.testStatistic.chiSquare(tooShortEx, tooShortObs);
            Assert.fail((String)"arguments too short, DimensionMismatchException expected");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        long[] unMatchedObs = new long[]{0L, 1L, 2L, 3L};
        double[] unMatchedEx = new double[]{1.0, 1.0, 2.0};
        try {
            this.testStatistic.chiSquare(unMatchedEx, unMatchedObs);
            Assert.fail((String)"arrays have different lengths, DimensionMismatchException expected");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        expected[0] = 0.0;
        try {
            this.testStatistic.chiSquareTest(expected, observed, 0.01);
            Assert.fail((String)"bad expected count, NotStrictlyPositiveException expected");
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            // empty catch block
        }
        expected[0] = 1.0;
        observed[0] = -1L;
        try {
            this.testStatistic.chiSquareTest(expected, observed, 0.01);
            Assert.fail((String)"bad expected count, NotPositiveException expected");
        }
        catch (NotPositiveException notPositiveException) {
            // empty catch block
        }
    }

    @Test
    public void testChiSquareIndependence() {
        long[][] counts = new long[][]{{40L, 22L, 43L}, {91L, 21L, 28L}, {60L, 10L, 22L}};
        Assert.assertEquals((String)"chi-square test statistic", (double)22.709027688, (double)this.testStatistic.chiSquare((long[][])counts), (double)1.0E-9);
        Assert.assertEquals((String)"chi-square p-value", (double)1.44751460134E-4, (double)this.testStatistic.chiSquareTest((long[][])counts), (double)1.0E-9);
        Assert.assertTrue((String)"chi-square test reject", (boolean)this.testStatistic.chiSquareTest((long[][])counts, 2.0E-4));
        Assert.assertTrue((String)"chi-square test accept", (!this.testStatistic.chiSquareTest((long[][])counts, 1.0E-4) ? 1 : 0) != 0);
        long[][] counts2 = new long[][]{{10L, 15L}, {30L, 40L}, {60L, 90L}};
        Assert.assertEquals((String)"chi-square test statistic", (double)0.168965517241, (double)this.testStatistic.chiSquare((long[][])counts2), (double)1.0E-9);
        Assert.assertEquals((String)"chi-square p-value", (double)0.918987499852, (double)this.testStatistic.chiSquareTest((long[][])counts2), (double)1.0E-9);
        Assert.assertTrue((String)"chi-square test accept", (!this.testStatistic.chiSquareTest((long[][])counts2, 0.1) ? 1 : 0) != 0);
        long[][] counts3 = new long[][]{{40L, 22L, 43L}, {91L, 21L, 28L}, {60L, 10L}};
        try {
            this.testStatistic.chiSquare((long[][])counts3);
            Assert.fail((String)"Expecting DimensionMismatchException");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        long[][] counts4 = new long[][]{{40L, 22L, 43L}};
        try {
            this.testStatistic.chiSquare((long[][])counts4);
            Assert.fail((String)"Expecting DimensionMismatchException");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        long[][] counts5 = new long[][]{{40L}, {40L}, {30L}, {10L}};
        try {
            this.testStatistic.chiSquare((long[][])counts5);
            Assert.fail((String)"Expecting DimensionMismatchException");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        long[][] counts6 = new long[][]{{10L, -2L}, {30L, 40L}, {60L, 90L}};
        try {
            this.testStatistic.chiSquare((long[][])counts6);
            Assert.fail((String)"Expecting NotPositiveException");
        }
        catch (NotPositiveException notPositiveException) {
            // empty catch block
        }
        try {
            this.testStatistic.chiSquareTest((long[][])counts, 0.0);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testChiSquareLargeTestStatistic() {
        double[] exp = new double[]{3389119.5, 649136.6, 285745.4, 2.535736476E7, 1.129118978E7, 543628.0, 232921.0, 437665.75};
        long[] obs = new long[]{2372383L, 584222L, 257170L, 17750155L, 7903832L, 489265L, 209628L, 393899L};
        ChiSquareTest csti = new ChiSquareTest();
        double cst = csti.chiSquareTest(exp, obs);
        Assert.assertEquals((String)"chi-square p-value", (double)0.0, (double)cst, (double)0.001);
        Assert.assertEquals((String)"chi-square test statistic", (double)114875.90421929007, (double)this.testStatistic.chiSquare(exp, obs), (double)1.0E-9);
    }

    @Test
    public void testChiSquareZeroCount() {
        long[][] counts = new long[][]{{40L, 0L, 4L}, {91L, 1L, 2L}, {60L, 2L, 0L}};
        Assert.assertEquals((String)"chi-square test statistic", (double)9.67444662263, (double)this.testStatistic.chiSquare((long[][])counts), (double)1.0E-9);
        Assert.assertEquals((String)"chi-square p-value", (double)0.0462835770603, (double)this.testStatistic.chiSquareTest((long[][])counts), (double)1.0E-9);
    }

    @Test
    public void testChiSquareDataSetsComparisonEqualCounts() {
        long[] observed1 = new long[]{10L, 12L, 12L, 10L};
        long[] observed2 = new long[]{5L, 15L, 14L, 10L};
        Assert.assertEquals((String)"chi-square p value", (double)0.541096, (double)this.testStatistic.chiSquareTestDataSetsComparison(observed1, observed2), (double)1.0E-6);
        Assert.assertEquals((String)"chi-square test statistic", (double)2.153846, (double)this.testStatistic.chiSquareDataSetsComparison(observed1, observed2), (double)1.0E-6);
        Assert.assertFalse((String)"chi-square test result", (boolean)this.testStatistic.chiSquareTestDataSetsComparison(observed1, observed2, 0.4));
    }

    @Test
    public void testChiSquareDataSetsComparisonUnEqualCounts() {
        long[] observed1 = new long[]{10L, 12L, 12L, 10L, 15L};
        long[] observed2 = new long[]{15L, 10L, 10L, 15L, 5L};
        Assert.assertEquals((String)"chi-square p value", (double)0.124115, (double)this.testStatistic.chiSquareTestDataSetsComparison(observed1, observed2), (double)1.0E-6);
        Assert.assertEquals((String)"chi-square test statistic", (double)7.232189, (double)this.testStatistic.chiSquareDataSetsComparison(observed1, observed2), (double)1.0E-6);
        Assert.assertTrue((String)"chi-square test result", (boolean)this.testStatistic.chiSquareTestDataSetsComparison(observed1, observed2, 0.13));
        Assert.assertFalse((String)"chi-square test result", (boolean)this.testStatistic.chiSquareTestDataSetsComparison(observed1, observed2, 0.12));
    }

    @Test
    public void testChiSquareDataSetsComparisonBadCounts() {
        long[] observed1 = new long[]{10L, -1L, 12L, 10L, 15L};
        long[] observed2 = new long[]{15L, 10L, 10L, 15L, 5L};
        try {
            this.testStatistic.chiSquareTestDataSetsComparison(observed1, observed2);
            Assert.fail((String)"Expecting NotPositiveException - negative count");
        }
        catch (NotPositiveException notPositiveException) {
            // empty catch block
        }
        long[] observed3 = new long[]{10L, 0L, 12L, 10L, 15L};
        long[] observed4 = new long[]{15L, 0L, 10L, 15L, 5L};
        try {
            this.testStatistic.chiSquareTestDataSetsComparison(observed3, observed4);
            Assert.fail((String)"Expecting ZeroException - double 0's");
        }
        catch (ZeroException zeroException) {
            // empty catch block
        }
        long[] observed5 = new long[]{10L, 10L, 12L, 10L, 15L};
        long[] observed6 = new long[]{0L, 0L, 0L, 0L, 0L};
        try {
            this.testStatistic.chiSquareTestDataSetsComparison(observed5, observed6);
            Assert.fail((String)"Expecting ZeroException - vanishing counts");
        }
        catch (ZeroException zeroException) {
            // empty catch block
        }
    }
}

