/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.model;

import org.apache.cayenne.dbsync.merge.context.MergerContext;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.model.AbstractToModelToken;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;

public class DropTableToModel
extends AbstractToModelToken.Entity {
    public DropTableToModel(DbEntity entity) {
        super("Drop Table", 35, entity);
    }

    @Override
    public MergerToken createReverse(MergerTokenFactory factory) {
        return factory.createCreateTableToDb(this.getEntity());
    }

    @Override
    public void execute(MergerContext mergerContext) {
        for (ObjEntity objEntity : this.getEntity().mappedObjEntities()) {
            objEntity.getDataMap().removeObjEntity(objEntity.getName(), true);
            mergerContext.getDelegate().objEntityRemoved(objEntity);
        }
        this.getEntity().getDataMap().removeDbEntity(this.getEntity().getName(), true);
        mergerContext.getDelegate().dbEntityRemoved(this.getEntity());
    }
}

