/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.FunctionExpressionFactory;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.ComparableProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.PropertyFactory;

public class DateProperty<E>
extends BaseProperty<E>
implements ComparableProperty<E> {
    protected DateProperty(String name, Expression expression, Class<E> type) {
        super(name, expression, type);
    }

    public NumericProperty<Integer> year() {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.yearExp(this.getExpression()), Integer.class);
    }

    public NumericProperty<Integer> month() {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.monthExp(this.getExpression()), Integer.class);
    }

    public NumericProperty<Integer> dayOfMonth() {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.dayOfMonthExp(this.getExpression()), Integer.class);
    }

    public NumericProperty<Integer> dayOfYear() {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.dayOfYearExp(this.getExpression()), Integer.class);
    }

    public NumericProperty<Integer> hour() {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.hourExp(this.getExpression()), Integer.class);
    }

    public NumericProperty<Integer> minute() {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.minuteExp(this.getExpression()), Integer.class);
    }

    public NumericProperty<Integer> second() {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.secondExp(this.getExpression()), Integer.class);
    }

    @Override
    public DateProperty<E> alias(String alias) {
        return PropertyFactory.createDate(alias, this.getExpression(), this.getType());
    }

    @Override
    public DateProperty<E> max() {
        return PropertyFactory.createDate(FunctionExpressionFactory.maxExp(this.getExpression()), this.getType());
    }

    @Override
    public DateProperty<E> min() {
        return PropertyFactory.createDate(FunctionExpressionFactory.minExp(this.getExpression()), this.getType());
    }

    @Override
    public DateProperty<E> enclosing() {
        return PropertyFactory.createDate(ExpressionFactory.enclosingObjectExp(this.getExpression()), this.getType());
    }
}

