/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.map.DefaultEntityResultSegment;
import org.apache.cayenne.map.DefaultScalarResultSegment;
import org.apache.cayenne.map.EmbeddedResult;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.EntityResult;
import org.apache.cayenne.query.DefaultEmbeddableResultSegment;
import org.apache.cayenne.reflect.ClassDescriptor;

public class SQLResult {
    protected String name;
    protected List<Object> resultDescriptors;

    public SQLResult() {
    }

    public List<Object> getResolvedComponents(EntityResolver resolver) {
        if (this.resultDescriptors == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> resolvedComponents = new ArrayList<Object>(this.resultDescriptors.size());
        int offset = 0;
        for (Object component : this.getComponents()) {
            Map<String, String> fields;
            if (component instanceof String) {
                resolvedComponents.add(new DefaultScalarResultSegment((String)component, offset));
                ++offset;
                continue;
            }
            if (component instanceof EntityResult) {
                EntityResult entityResult = (EntityResult)component;
                fields = entityResult.getDbFields(resolver);
                String entityName = entityResult.getEntityName();
                if (entityName == null) {
                    entityName = resolver.getObjEntity(entityResult.getEntityClass()).getName();
                }
                ClassDescriptor classDescriptor = resolver.getClassDescriptor(entityName);
                resolvedComponents.add(new DefaultEntityResultSegment(classDescriptor, fields, offset));
                offset += fields.size();
                continue;
            }
            if (component instanceof EmbeddedResult) {
                EmbeddedResult embeddedResult = (EmbeddedResult)component;
                fields = embeddedResult.getFields();
                resolvedComponents.add(new DefaultEmbeddableResultSegment(embeddedResult.getEmbeddable(), fields, offset));
                offset += fields.size();
                continue;
            }
            throw new IllegalArgumentException("Unsupported result descriptor component: " + component);
        }
        return resolvedComponents;
    }

    public SQLResult(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Object> getComponents() {
        return this.resultDescriptors != null ? this.resultDescriptors : Collections.emptyList();
    }

    public void addEntityResult(EntityResult entityResult) {
        this.checkAndAdd(entityResult);
    }

    public void addEmbeddedResult(EmbeddedResult embeddedResult) {
        this.checkAndAdd(embeddedResult);
    }

    public void addColumnResult(String column) {
        this.checkAndAdd(column);
    }

    private void checkAndAdd(Object result) {
        if (this.resultDescriptors == null) {
            this.resultDescriptors = new ArrayList<Object>(3);
        }
        this.resultDescriptors.add(result);
    }
}

