/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.cayenne.dbsync.merge.AbstractMerger;
import org.apache.cayenne.dbsync.merge.DbAttributeDictionary;
import org.apache.cayenne.dbsync.merge.MergerDictionaryDiff;
import org.apache.cayenne.dbsync.merge.MergerDiffPair;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.ValueForNullProvider;
import org.apache.cayenne.dbsync.model.DetectedDbEntity;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;

class DbAttributeMerger
extends AbstractMerger<DbEntity, DbAttribute> {
    static int[] typesWithMaxLength = new int[]{-15, -9, 1, 12, -2, -3, 92, 93};
    private final ValueForNullProvider valueForNull;

    DbAttributeMerger(MergerTokenFactory tokenFactory, ValueForNullProvider valueForNull) {
        super(tokenFactory);
        this.valueForNull = valueForNull;
    }

    @Override
    MergerDictionaryDiff<DbAttribute> createDiff(DbEntity original, DbEntity imported) {
        return new MergerDictionaryDiff.Builder<DbAttribute>().originalDictionary(new DbAttributeDictionary(original)).importedDictionary(new DbAttributeDictionary(imported)).build();
    }

    @Override
    Collection<MergerToken> createTokensForMissingImported(DbAttribute original) {
        DbEntity originalDbEntity = original.getEntity();
        LinkedList<MergerToken> tokens = new LinkedList<MergerToken>();
        tokens.add(this.getTokenFactory().createAddColumnToDb(originalDbEntity, original));
        if (original.isMandatory()) {
            if (this.valueForNull.hasValueFor(originalDbEntity, original)) {
                tokens.add(this.getTokenFactory().createSetValueForNullToDb(originalDbEntity, original, this.valueForNull));
            }
            tokens.add(this.getTokenFactory().createSetNotNullToDb(originalDbEntity, original));
        }
        if (original.isPrimaryKey() && originalDbEntity instanceof DetectedDbEntity && "VIEW".equals(((DetectedDbEntity)originalDbEntity).getType())) {
            return null;
        }
        return tokens;
    }

    @Override
    Collection<MergerToken> createTokensForMissingOriginal(DbAttribute imported) {
        DbEntity originalDbEntity = (DbEntity)this.getOriginalDictionary().getByName(imported.getEntity().getName().toUpperCase());
        return Collections.singleton(this.getTokenFactory().createDropColumnToDb(originalDbEntity, imported));
    }

    @Override
    Collection<MergerToken> createTokensForSame(MergerDiffPair<DbAttribute> same) {
        LinkedList<MergerToken> tokens = new LinkedList<MergerToken>();
        this.checkMandatory(same.getOriginal(), same.getImported(), tokens);
        this.checkType(same.getOriginal(), same.getImported(), tokens);
        this.checkIsGenerated(same.getOriginal(), same.getImported(), tokens);
        return tokens;
    }

    private void checkMandatory(DbAttribute original, DbAttribute imported, List<MergerToken> tokens) {
        if (original.isMandatory() == imported.isMandatory()) {
            return;
        }
        DbEntity originalDbEntity = original.getEntity();
        if (original.isMandatory()) {
            if (this.valueForNull.hasValueFor(originalDbEntity, original)) {
                tokens.add(this.getTokenFactory().createSetValueForNullToDb(originalDbEntity, original, this.valueForNull));
            }
            tokens.add(this.getTokenFactory().createSetNotNullToDb(originalDbEntity, original));
        } else {
            tokens.add(this.getTokenFactory().createSetAllowNullToDb(originalDbEntity, original));
        }
    }

    private boolean needUpdateType(DbAttribute original, DbAttribute imported) {
        if (original.getType() != imported.getType()) {
            if (!(original.getType() != 3 && original.getType() != 2 || imported.getType() != 3 && imported.getType() != 2)) {
                return false;
            }
            return this.getTokenFactory().needUpdateSpecificType(original, imported);
        }
        if (original.getMaxLength() != imported.getMaxLength()) {
            for (int type : typesWithMaxLength) {
                if (original.getType() != type) continue;
                return true;
            }
        }
        if (this.needUpdateScale(original, imported)) {
            return true;
        }
        return original.getAttributePrecision() != imported.getAttributePrecision();
    }

    private boolean needUpdateScale(DbAttribute original, DbAttribute imported) {
        if (original.getScale() == imported.getScale()) {
            return false;
        }
        return original.getScale() != -1 && original.getScale() != 0 || imported.getScale() != -1 && imported.getScale() != 0;
    }

    private void checkType(DbAttribute original, DbAttribute imported, List<MergerToken> tokens) {
        if (!this.needUpdateType(original, imported)) {
            return;
        }
        DbEntity originalDbEntity = original.getEntity();
        tokens.add(this.getTokenFactory().createSetColumnTypeToDb(originalDbEntity, imported, original));
    }

    private void checkIsGenerated(DbAttribute original, DbAttribute imported, List<MergerToken> tokens) {
        if (original.isGenerated() == imported.isGenerated()) {
            return;
        }
        tokens.add(this.getTokenFactory().createSetGeneratedFlagToDb(original.getEntity(), original, original.isGenerated()));
    }

    @Override
    public List<MergerToken> createMergeTokens() {
        throw new UnsupportedOperationException();
    }
}

