/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureQueryDescriptor;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.project.validation.BaseQueryValidator;
import org.apache.cayenne.validation.ValidationResult;

class ProcedureQueryValidator
extends BaseQueryValidator {
    ProcedureQueryValidator() {
    }

    void validate(ProcedureQueryDescriptor query, ValidationResult validationResult) {
        this.validateName((QueryDescriptor)query, validationResult);
        this.validateRoot(query, validationResult);
        this.validateCacheGroup((QueryDescriptor)query, validationResult);
    }

    void validateRoot(ProcedureQueryDescriptor query, ValidationResult validationResult) {
        DataMap map = query.getDataMap();
        Object root = query.getRoot();
        if (root == null && map != null) {
            this.addFailure(validationResult, query, "ProcedureQuery '%s' has no root", query.getName());
        }
        if (root instanceof Procedure) {
            Procedure procedure = (Procedure)root;
            if (map != null && map.getProcedure(procedure.getName()) != procedure) {
                this.addFailure(validationResult, query, "ProcedureQuery '%s' has invalid Procedure root: %s", query.getName(), procedure.getName());
            }
            return;
        }
        if (root instanceof String && map != null && map.getProcedure(root.toString()) == null) {
            this.addFailure(validationResult, query, "ProcedureQuery '%s' has invalid Procedure root: %s", query.getName(), root);
        }
    }
}

