/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.openai.OpenAIComponent;

/**
 * OpenAI endpoint for chat completion and embeddings.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface OpenaiComponentBuilderFactory {

    /**
     * OpenAI (camel-openai)
     * OpenAI endpoint for chat completion and embeddings.
     * 
     * Category: ai
     * Since: 4.17
     * Maven coordinates: org.apache.camel:camel-openai
     * 
     * @return the dsl builder
     */
    static OpenaiComponentBuilder openai() {
        return new OpenaiComponentBuilderImpl();
    }

    /**
     * Builder for the OpenAI component.
     */
    interface OpenaiComponentBuilder extends ComponentBuilder<OpenAIComponent> {
    
        /**
         * Default API key for all endpoints.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default OpenaiComponentBuilder apiKey(java.lang.String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
    
        
        /**
         * Default base URL for all endpoints.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://api.openai.com/v1
         * Group: producer
         * 
         * @param baseUrl the value to set
         * @return the dsl builder
         */
        default OpenaiComponentBuilder baseUrl(java.lang.String baseUrl) {
            doSetProperty("baseUrl", baseUrl);
            return this;
        }
    
        /**
         * Default model for embeddings endpoints.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param embeddingModel the value to set
         * @return the dsl builder
         */
        default OpenaiComponentBuilder embeddingModel(java.lang.String embeddingModel) {
            doSetProperty("embeddingModel", embeddingModel);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default OpenaiComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        /**
         * Default model for chat completion endpoints.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param model the value to set
         * @return the dsl builder
         */
        default OpenaiComponentBuilder model(java.lang.String model) {
            doSetProperty("model", model);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default OpenaiComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    }

    class OpenaiComponentBuilderImpl
            extends AbstractComponentBuilder<OpenAIComponent>
            implements OpenaiComponentBuilder {
        @Override
        protected OpenAIComponent buildConcreteComponent() {
            return new OpenAIComponent();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "apiKey": ((OpenAIComponent) component).setApiKey((java.lang.String) value); return true;
            case "baseUrl": ((OpenAIComponent) component).setBaseUrl((java.lang.String) value); return true;
            case "embeddingModel": ((OpenAIComponent) component).setEmbeddingModel((java.lang.String) value); return true;
            case "lazyStartProducer": ((OpenAIComponent) component).setLazyStartProducer((boolean) value); return true;
            case "model": ((OpenAIComponent) component).setModel((java.lang.String) value); return true;
            case "autowiredEnabled": ((OpenAIComponent) component).setAutowiredEnabled((boolean) value); return true;
            default: return false;
            }
        }
    }
}