/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.ibm.watsonx.ai.WatsonxAiComponent;

/**
 * Interact with IBM watsonx.ai foundation models for text generation, chat,
 * embeddings, and more.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface IbmWatsonxAiComponentBuilderFactory {

    /**
     * IBM watsonx.ai (camel-ibm-watsonx-ai)
     * Interact with IBM watsonx.ai foundation models for text generation, chat,
     * embeddings, and more.
     * 
     * Category: ai,cloud
     * Since: 4.18
     * Maven coordinates: org.apache.camel:camel-ibm-watsonx-ai
     * 
     * @return the dsl builder
     */
    static IbmWatsonxAiComponentBuilder ibmWatsonxAi() {
        return new IbmWatsonxAiComponentBuilderImpl();
    }

    /**
     * Builder for the IBM watsonx.ai component.
     */
    interface IbmWatsonxAiComponentBuilder extends ComponentBuilder<WatsonxAiComponent> {
    
        /**
         * The watsonx.ai base URL (e.g., https://us-south.ml.cloud.ibm.com).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param baseUrl the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder baseUrl(java.lang.String baseUrl) {
            doSetProperty("baseUrl", baseUrl);
            return this;
        }
    
        /**
         * The component configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.ibm.watsonx.ai.WatsonxAiConfiguration&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder configuration(org.apache.camel.component.ibm.watsonx.ai.WatsonxAiConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        /**
         * IBM Cloud project ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param projectId the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder projectId(java.lang.String projectId) {
            doSetProperty("projectId", projectId);
            return this;
        }
    
        /**
         * IBM Cloud deployment space ID (alternative to projectId).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param spaceId the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder spaceId(java.lang.String spaceId) {
            doSetProperty("spaceId", spaceId);
            return this;
        }
    
        /**
         * The watsonx.ai WX platform URL for tool operations (e.g.,
         * https://api.dataplatform.cloud.ibm.com/wx).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param wxUrl the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder wxUrl(java.lang.String wxUrl) {
            doSetProperty("wxUrl", wxUrl);
            return this;
        }
    
        /**
         * Cloud Object Storage URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param cosUrl the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder cosUrl(java.lang.String cosUrl) {
            doSetProperty("cosUrl", cosUrl);
            return this;
        }
    
        /**
         * Deployed model ID (for deployment operations).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param deploymentId the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder deploymentId(java.lang.String deploymentId) {
            doSetProperty("deploymentId", deploymentId);
            return this;
        }
    
        
        /**
         * Whether to detect HAP (Harmful, Abusive, Profane content).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param detectHap the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder detectHap(java.lang.Boolean detectHap) {
            doSetProperty("detectHap", detectHap);
            return this;
        }
    
        /**
         * Detection threshold (0.0 to 1.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param detectionThreshold the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder detectionThreshold(java.lang.Double detectionThreshold) {
            doSetProperty("detectionThreshold", detectionThreshold);
            return this;
        }
    
        
        /**
         * Whether to detect PII (Personal Identifiable Information).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param detectPii the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder detectPii(java.lang.Boolean detectPii) {
            doSetProperty("detectPii", detectPii);
            return this;
        }
    
        /**
         * COS bucket for document storage.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param documentBucket the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder documentBucket(java.lang.String documentBucket) {
            doSetProperty("documentBucket", documentBucket);
            return this;
        }
    
        /**
         * COS connection ID for document storage.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param documentConnectionId the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder documentConnectionId(java.lang.String documentConnectionId) {
            doSetProperty("documentConnectionId", documentConnectionId);
            return this;
        }
    
        /**
         * Frequency penalty for chat.
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param frequencyPenalty the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder frequencyPenalty(java.lang.Double frequencyPenalty) {
            doSetProperty("frequencyPenalty", frequencyPenalty);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        /**
         * Maximum completion tokens for chat.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param maxCompletionTokens the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder maxCompletionTokens(java.lang.Integer maxCompletionTokens) {
            doSetProperty("maxCompletionTokens", maxCompletionTokens);
            return this;
        }
    
        /**
         * Maximum new tokens to generate.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param maxNewTokens the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder maxNewTokens(java.lang.Integer maxNewTokens) {
            doSetProperty("maxNewTokens", maxNewTokens);
            return this;
        }
    
        /**
         * Foundation model ID (e.g., ibm/granite-13b-instruct-v2).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param modelId the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder modelId(java.lang.String modelId) {
            doSetProperty("modelId", modelId);
            return this;
        }
    
        /**
         * The operation to perform.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.ibm.watsonx.ai.WatsonxAiOperations&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder operation(org.apache.camel.component.ibm.watsonx.ai.WatsonxAiOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
    
        /**
         * Presence penalty for chat.
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param presencePenalty the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder presencePenalty(java.lang.Double presencePenalty) {
            doSetProperty("presencePenalty", presencePenalty);
            return this;
        }
    
        /**
         * Repetition penalty.
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param repetitionPenalty the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder repetitionPenalty(java.lang.Double repetitionPenalty) {
            doSetProperty("repetitionPenalty", repetitionPenalty);
            return this;
        }
    
        /**
         * Number of top results to return for reranking.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param rerankTopN the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder rerankTopN(java.lang.Integer rerankTopN) {
            doSetProperty("rerankTopN", rerankTopN);
            return this;
        }
    
        /**
         * COS bucket for result storage.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param resultBucket the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder resultBucket(java.lang.String resultBucket) {
            doSetProperty("resultBucket", resultBucket);
            return this;
        }
    
        /**
         * COS connection ID for result storage.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param resultConnectionId the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder resultConnectionId(java.lang.String resultConnectionId) {
            doSetProperty("resultConnectionId", resultConnectionId);
            return this;
        }
    
        
        /**
         * Whether to return documents in rerank response.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param returnDocuments the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder returnDocuments(java.lang.Boolean returnDocuments) {
            doSetProperty("returnDocuments", returnDocuments);
            return this;
        }
    
        /**
         * Temperature for randomness (0.0 to 2.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param temperature the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder temperature(java.lang.Double temperature) {
            doSetProperty("temperature", temperature);
            return this;
        }
    
        /**
         * Top K (top-k sampling).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param topK the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder topK(java.lang.Integer topK) {
            doSetProperty("topK", topK);
            return this;
        }
    
        /**
         * Top P (nucleus sampling).
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param topP the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder topP(java.lang.Double topP) {
            doSetProperty("topP", topP);
            return this;
        }
    
        /**
         * Maximum number of tokens accepted per input for embeddings. Truncates
         * from the end if exceeded.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param truncateInputTokens the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder truncateInputTokens(java.lang.Integer truncateInputTokens) {
            doSetProperty("truncateInputTokens", truncateInputTokens);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        
        /**
         * Whether to log HTTP requests to the watsonx.ai API.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param logRequests the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder logRequests(java.lang.Boolean logRequests) {
            doSetProperty("logRequests", logRequests);
            return this;
        }
    
        
        /**
         * Whether to log HTTP responses from the watsonx.ai API.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param logResponses the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder logResponses(java.lang.Boolean logResponses) {
            doSetProperty("logResponses", logResponses);
            return this;
        }
    
        /**
         * Request timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder timeout(java.lang.Long timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
    
        
        /**
         * Whether to verify SSL certificates.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param verifySsl the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder verifySsl(java.lang.Boolean verifySsl) {
            doSetProperty("verifySsl", verifySsl);
            return this;
        }
    
        /**
         * IBM Cloud API key for authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default IbmWatsonxAiComponentBuilder apiKey(java.lang.String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
    }

    class IbmWatsonxAiComponentBuilderImpl
            extends AbstractComponentBuilder<WatsonxAiComponent>
            implements IbmWatsonxAiComponentBuilder {
        @Override
        protected WatsonxAiComponent buildConcreteComponent() {
            return new WatsonxAiComponent();
        }
        private org.apache.camel.component.ibm.watsonx.ai.WatsonxAiConfiguration getOrCreateConfiguration(WatsonxAiComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.ibm.watsonx.ai.WatsonxAiConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "baseUrl": getOrCreateConfiguration((WatsonxAiComponent) component).setBaseUrl((java.lang.String) value); return true;
            case "configuration": ((WatsonxAiComponent) component).setConfiguration((org.apache.camel.component.ibm.watsonx.ai.WatsonxAiConfiguration) value); return true;
            case "projectId": getOrCreateConfiguration((WatsonxAiComponent) component).setProjectId((java.lang.String) value); return true;
            case "spaceId": getOrCreateConfiguration((WatsonxAiComponent) component).setSpaceId((java.lang.String) value); return true;
            case "wxUrl": getOrCreateConfiguration((WatsonxAiComponent) component).setWxUrl((java.lang.String) value); return true;
            case "cosUrl": getOrCreateConfiguration((WatsonxAiComponent) component).setCosUrl((java.lang.String) value); return true;
            case "deploymentId": getOrCreateConfiguration((WatsonxAiComponent) component).setDeploymentId((java.lang.String) value); return true;
            case "detectHap": getOrCreateConfiguration((WatsonxAiComponent) component).setDetectHap((java.lang.Boolean) value); return true;
            case "detectionThreshold": getOrCreateConfiguration((WatsonxAiComponent) component).setDetectionThreshold((java.lang.Double) value); return true;
            case "detectPii": getOrCreateConfiguration((WatsonxAiComponent) component).setDetectPii((java.lang.Boolean) value); return true;
            case "documentBucket": getOrCreateConfiguration((WatsonxAiComponent) component).setDocumentBucket((java.lang.String) value); return true;
            case "documentConnectionId": getOrCreateConfiguration((WatsonxAiComponent) component).setDocumentConnectionId((java.lang.String) value); return true;
            case "frequencyPenalty": getOrCreateConfiguration((WatsonxAiComponent) component).setFrequencyPenalty((java.lang.Double) value); return true;
            case "lazyStartProducer": ((WatsonxAiComponent) component).setLazyStartProducer((boolean) value); return true;
            case "maxCompletionTokens": getOrCreateConfiguration((WatsonxAiComponent) component).setMaxCompletionTokens((java.lang.Integer) value); return true;
            case "maxNewTokens": getOrCreateConfiguration((WatsonxAiComponent) component).setMaxNewTokens((java.lang.Integer) value); return true;
            case "modelId": getOrCreateConfiguration((WatsonxAiComponent) component).setModelId((java.lang.String) value); return true;
            case "operation": getOrCreateConfiguration((WatsonxAiComponent) component).setOperation((org.apache.camel.component.ibm.watsonx.ai.WatsonxAiOperations) value); return true;
            case "presencePenalty": getOrCreateConfiguration((WatsonxAiComponent) component).setPresencePenalty((java.lang.Double) value); return true;
            case "repetitionPenalty": getOrCreateConfiguration((WatsonxAiComponent) component).setRepetitionPenalty((java.lang.Double) value); return true;
            case "rerankTopN": getOrCreateConfiguration((WatsonxAiComponent) component).setRerankTopN((java.lang.Integer) value); return true;
            case "resultBucket": getOrCreateConfiguration((WatsonxAiComponent) component).setResultBucket((java.lang.String) value); return true;
            case "resultConnectionId": getOrCreateConfiguration((WatsonxAiComponent) component).setResultConnectionId((java.lang.String) value); return true;
            case "returnDocuments": getOrCreateConfiguration((WatsonxAiComponent) component).setReturnDocuments((java.lang.Boolean) value); return true;
            case "temperature": getOrCreateConfiguration((WatsonxAiComponent) component).setTemperature((java.lang.Double) value); return true;
            case "topK": getOrCreateConfiguration((WatsonxAiComponent) component).setTopK((java.lang.Integer) value); return true;
            case "topP": getOrCreateConfiguration((WatsonxAiComponent) component).setTopP((java.lang.Double) value); return true;
            case "truncateInputTokens": getOrCreateConfiguration((WatsonxAiComponent) component).setTruncateInputTokens((java.lang.Integer) value); return true;
            case "autowiredEnabled": ((WatsonxAiComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "logRequests": getOrCreateConfiguration((WatsonxAiComponent) component).setLogRequests((java.lang.Boolean) value); return true;
            case "logResponses": getOrCreateConfiguration((WatsonxAiComponent) component).setLogResponses((java.lang.Boolean) value); return true;
            case "timeout": getOrCreateConfiguration((WatsonxAiComponent) component).setTimeout((java.lang.Long) value); return true;
            case "verifySsl": getOrCreateConfiguration((WatsonxAiComponent) component).setVerifySsl((java.lang.Boolean) value); return true;
            case "apiKey": getOrCreateConfiguration((WatsonxAiComponent) component).setApiKey((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}