/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientRequestor;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;

public class ActiveMQManagementProxy
implements AutoCloseable {
    private final ServerLocator serverLocator;
    private final ClientSessionFactory sessionFactory;
    private final ClientSession clientSession;

    public ActiveMQManagementProxy(ClientSession session) {
        this.serverLocator = null;
        this.sessionFactory = null;
        this.clientSession = session;
    }

    public ActiveMQManagementProxy(ServerLocator locator, String username, String password) throws Exception {
        this.serverLocator = locator;
        this.sessionFactory = locator.createSessionFactory();
        this.clientSession = this.sessionFactory.createSession(username, password, false, true, true, false, 0x100000).start();
    }

    public <T> T getAttribute(String resourceName, String attributeName, Class<T> attributeClass, int timeout) throws Exception {
        try (ClientRequestor requestor = new ClientRequestor(this.clientSession, ActiveMQDefaultConfiguration.getDefaultManagementAddress());){
            ClientMessage request = this.clientSession.createMessage(false);
            ManagementHelper.putAttribute(request, resourceName, attributeName);
            ClientMessage reply = requestor.request(request, timeout);
            if (ManagementHelper.hasOperationSucceeded(reply)) {
                Object object = ManagementHelper.getResult(reply, attributeClass);
                return (T)object;
            }
            throw new Exception("Failed to get " + resourceName + "." + attributeName + ". Reason: " + String.valueOf(ManagementHelper.getResult(reply, String.class)));
        }
    }

    public <T> T invokeOperation(String resourceName, String operationName, Object[] operationParams, Class<T> operationClass, int timeout) throws Exception {
        try (ClientRequestor requestor = new ClientRequestor(this.clientSession, ActiveMQDefaultConfiguration.getDefaultManagementAddress());){
            ClientMessage request = this.clientSession.createMessage(false);
            ManagementHelper.putOperationInvocation(request, resourceName, operationName, operationParams);
            ClientMessage reply = requestor.request(request, timeout);
            if (ManagementHelper.hasOperationSucceeded(reply)) {
                Object object = ManagementHelper.getResult(reply, operationClass);
                return (T)object;
            }
            throw new Exception("Failed to invoke " + resourceName + "." + operationName + ". Reason: " + String.valueOf(ManagementHelper.getResult(reply, String.class)));
        }
    }

    @Override
    public void close() throws Exception {
        this.clientSession.close();
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
        }
        if (this.serverLocator != null) {
            this.serverLocator.close();
        }
    }
}

