/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.attributeclassobservers;

import com.github.javacliparser.IntOption;
import java.util.Iterator;
import java.util.TreeSet;
import moa.classifiers.core.AttributeSplitSuggestion;
import moa.classifiers.core.attributeclassobservers.NumericAttributeClassObserver;
import moa.classifiers.core.conditionaltests.NumericAttributeBinaryTest;
import moa.classifiers.core.splitcriteria.SplitCriterion;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.GaussianEstimator;
import moa.core.ObjectRepository;
import moa.core.Utils;
import moa.options.AbstractOptionHandler;
import moa.tasks.TaskMonitor;

public class GaussianNumericAttributeClassObserver
extends AbstractOptionHandler
implements NumericAttributeClassObserver {
    private static final long serialVersionUID = 1L;
    protected DoubleVector minValueObservedPerClass = new DoubleVector();
    protected DoubleVector maxValueObservedPerClass = new DoubleVector();
    protected AutoExpandVector<GaussianEstimator> attValDistPerClass = new AutoExpandVector();
    public IntOption numBinsOption = new IntOption("numBins", 'n', "The number of bins.", 10, 1, Integer.MAX_VALUE);

    @Override
    public void observeAttributeClass(double attVal, int classVal, double weight) {
        if (!Utils.isMissingValue(attVal)) {
            GaussianEstimator valDist = this.attValDistPerClass.get(classVal);
            if (valDist == null) {
                valDist = new GaussianEstimator();
                this.attValDistPerClass.set(classVal, valDist);
                this.minValueObservedPerClass.setValue(classVal, attVal);
                this.maxValueObservedPerClass.setValue(classVal, attVal);
            } else {
                if (attVal < this.minValueObservedPerClass.getValue(classVal)) {
                    this.minValueObservedPerClass.setValue(classVal, attVal);
                }
                if (attVal > this.maxValueObservedPerClass.getValue(classVal)) {
                    this.maxValueObservedPerClass.setValue(classVal, attVal);
                }
            }
            valDist.addObservation(attVal, weight);
        }
    }

    @Override
    public double probabilityOfAttributeValueGivenClass(double attVal, int classVal) {
        GaussianEstimator obs = this.attValDistPerClass.get(classVal);
        return obs != null ? obs.probabilityDensity(attVal) : 0.0;
    }

    @Override
    public AttributeSplitSuggestion getBestEvaluatedSplitSuggestion(SplitCriterion criterion, double[] preSplitDist, int attIndex, boolean binaryOnly) {
        double[] suggestedSplitValues;
        AttributeSplitSuggestion bestSuggestion = null;
        for (double splitValue : suggestedSplitValues = this.getSplitPointSuggestions()) {
            double[][] postSplitDists = this.getClassDistsResultingFromBinarySplit(splitValue);
            double merit = criterion.getMeritOfSplit(preSplitDist, postSplitDists);
            if (bestSuggestion != null && !(merit > bestSuggestion.merit)) continue;
            bestSuggestion = new AttributeSplitSuggestion(new NumericAttributeBinaryTest(attIndex, splitValue, true), postSplitDists, merit);
        }
        return bestSuggestion;
    }

    public double[] getSplitPointSuggestions() {
        TreeSet<Double> suggestedSplitValues = new TreeSet<Double>();
        double minValue = Double.POSITIVE_INFINITY;
        double maxValue = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.attValDistPerClass.size(); ++i) {
            GaussianEstimator estimator = this.attValDistPerClass.get(i);
            if (estimator == null) continue;
            if (this.minValueObservedPerClass.getValue(i) < minValue) {
                minValue = this.minValueObservedPerClass.getValue(i);
            }
            if (!(this.maxValueObservedPerClass.getValue(i) > maxValue)) continue;
            maxValue = this.maxValueObservedPerClass.getValue(i);
        }
        if (minValue < Double.POSITIVE_INFINITY) {
            double range = maxValue - minValue;
            for (int i = 0; i < this.numBinsOption.getValue(); ++i) {
                double splitValue = range / ((double)this.numBinsOption.getValue() + 1.0) * (double)(i + 1) + minValue;
                if (!(splitValue > minValue) || !(splitValue < maxValue)) continue;
                suggestedSplitValues.add(splitValue);
            }
        }
        double[] suggestions = new double[suggestedSplitValues.size()];
        int i = 0;
        Iterator iterator = suggestedSplitValues.iterator();
        while (iterator.hasNext()) {
            double suggestion = (Double)iterator.next();
            suggestions[i++] = suggestion;
        }
        return suggestions;
    }

    public double[][] getClassDistsResultingFromBinarySplit(double splitValue) {
        DoubleVector lhsDist = new DoubleVector();
        DoubleVector rhsDist = new DoubleVector();
        for (int i = 0; i < this.attValDistPerClass.size(); ++i) {
            GaussianEstimator estimator = this.attValDistPerClass.get(i);
            if (estimator == null) continue;
            if (splitValue < this.minValueObservedPerClass.getValue(i)) {
                rhsDist.addToValue(i, estimator.getTotalWeightObserved());
                continue;
            }
            if (splitValue >= this.maxValueObservedPerClass.getValue(i)) {
                lhsDist.addToValue(i, estimator.getTotalWeightObserved());
                continue;
            }
            double[] weightDist = estimator.estimatedWeight_LessThan_EqualTo_GreaterThan_Value(splitValue);
            lhsDist.addToValue(i, weightDist[0] + weightDist[1]);
            rhsDist.addToValue(i, weightDist[2]);
        }
        return new double[][]{lhsDist.getArrayRef(), rhsDist.getArrayRef()};
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }

    @Override
    public void observeAttributeTarget(double attVal, double target) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

