/*
 * Decompiled with CFR 0.152.
 */
package sample;

import beagleutil.Samples;
import blbutil.IntArray;
import haplotype.SampleHapPairs;
import java.util.Arrays;
import main.CurrentData;
import main.GeneticMap;
import main.Par;
import sample.HaplotypeCoder;
import sample.RefHapSegs;
import vcf.Markers;

public class ImputationData {
    private static final double MIN_CM_DIST = 1.0E-7;
    private final SampleHapPairs refHapPairs;
    private final SampleHapPairs targHapPairs;
    private final RefHapSegs refHapSegs;
    private final IntArray[] refAlleles;
    private final IntArray[] targAlleles;
    private final float[] errProb;
    private final float[] pRecomb;
    private final float[] weight;
    private final int nClusters;

    public ImputationData(Par par, CurrentData currentData, SampleHapPairs sampleHapPairs, GeneticMap geneticMap) {
        if (!currentData.targetMarkers().equals(sampleHapPairs.markers())) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        if (!currentData.targetSamples().equals(sampleHapPairs.samples())) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        int[] nArray = ImputationData.targClustEnd(sampleHapPairs.markers(), geneticMap, par.cluster());
        this.refAlleles = new IntArray[nArray.length];
        this.targAlleles = new IntArray[nArray.length];
        ImputationData.setCodedAlleles(currentData.restrictedRefSampleHapPairs(), sampleHapPairs, nArray, this.refAlleles, this.targAlleles);
        this.nClusters = nArray.length;
        this.refHapPairs = currentData.refSampleHapPairs();
        this.refHapSegs = ImputationData.refHapSegs(this.refHapPairs, nArray, currentData.markerIndices());
        this.targHapPairs = sampleHapPairs;
        this.errProb = ImputationData.err(par.err(), nArray);
        this.pRecomb = ImputationData.pRecomb(this.refHapSegs, geneticMap, par.ne());
        this.weight = ImputationData.wts(this.refHapSegs, geneticMap);
    }

    private static int[] targClustEnd(Markers markers, GeneticMap geneticMap, float f) {
        int n = markers.nMarkers();
        int[] nArray = new int[n];
        double d = geneticMap.genPos(markers.marker(0));
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            double d2 = geneticMap.genPos(markers.marker(i));
            if (!(d2 - d > (double)f)) continue;
            nArray[n2++] = i;
            d = d2;
        }
        nArray[n2++] = n;
        return Arrays.copyOf(nArray, n2);
    }

    private static void setCodedAlleles(SampleHapPairs sampleHapPairs, SampleHapPairs sampleHapPairs2, int[] nArray, IntArray[] intArrayArray, IntArray[] intArrayArray2) {
        HaplotypeCoder haplotypeCoder = new HaplotypeCoder(sampleHapPairs, sampleHapPairs2);
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            IntArray[] intArrayArray3 = haplotypeCoder.run(n, nArray[i]);
            intArrayArray[i] = intArrayArray3[0];
            intArrayArray2[i] = intArrayArray3[1];
            n = nArray[i];
        }
    }

    private static float[] err(float f, int[] nArray) {
        float f2 = 0.5f;
        float[] fArray = new float[nArray.length];
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = f * (float)(nArray[i] - n);
            if (fArray[i] > f2) {
                fArray[i] = f2;
            }
            n = nArray[i];
        }
        return fArray;
    }

    private static float[] pRecomb(RefHapSegs refHapSegs, GeneticMap geneticMap, float f) {
        SampleHapPairs sampleHapPairs = refHapSegs.refHapPairs();
        Markers markers = sampleHapPairs.markers();
        int n = sampleHapPairs.nHaps();
        int[] nArray = ImputationData.midPos(markers, refHapSegs);
        int n2 = markers.marker(0).chromIndex();
        return ImputationData.pRcomb(n2, nArray, n, geneticMap, f);
    }

    private static int[] midPos(Markers markers, RefHapSegs refHapSegs) {
        int[] nArray = new int[refHapSegs.nSegs() - 1];
        for (int i = 0; i < nArray.length; ++i) {
            int n = markers.marker(refHapSegs.segStart(i + 1)).pos();
            int n2 = markers.marker(refHapSegs.segEnd(i) - 1).pos();
            nArray[i] = (n + n2) / 2;
        }
        return nArray;
    }

    private static float[] pRcomb(int n, int[] nArray, int n2, GeneticMap geneticMap, float f) {
        float[] fArray = new float[nArray.length];
        double d = -(0.04 * (double)f / (double)n2);
        double d2 = geneticMap.genPos(n, nArray[0]);
        fArray[0] = 0.0f;
        for (int i = 1; i < fArray.length; ++i) {
            double d3 = geneticMap.genPos(n, nArray[i]);
            double d4 = Math.max(Math.abs(d3 - d2), 1.0E-7);
            fArray[i] = (float)(-Math.expm1(d * d4));
            d2 = d3;
        }
        return fArray;
    }

    private static float[] wts(RefHapSegs refHapSegs, GeneticMap geneticMap) {
        Markers markers = refHapSegs.refHapPairs().markers();
        double[] dArray = ImputationData.cumPos(markers, geneticMap);
        int n = markers.nMarkers();
        int n2 = refHapSegs.nSegs() - 1;
        float[] fArray = new float[dArray.length];
        if (n2 > 0) {
            Arrays.fill(fArray, 0, refHapSegs.segStart(1), Float.NaN);
        }
        for (int i = 1; i < n2; ++i) {
            int n3 = refHapSegs.segStart(i);
            int n4 = refHapSegs.segEnd(i - 1);
            int n5 = refHapSegs.segStart(i + 1);
            double d = dArray[n5];
            double d2 = d - dArray[n4 - 1];
            Arrays.fill(fArray, n3, n4, 1.0f);
            for (int j = n4; j < n5; ++j) {
                fArray[j] = (float)((d - dArray[j]) / d2);
            }
        }
        Arrays.fill(fArray, refHapSegs.segStart(n2), n, Float.NaN);
        return fArray;
    }

    private static double[] cumPos(Markers markers, GeneticMap geneticMap) {
        double[] dArray = new double[markers.nMarkers()];
        double d = geneticMap.genPos(markers.marker(0));
        dArray[0] = 0.0;
        for (int i = 1; i < dArray.length; ++i) {
            double d2 = geneticMap.genPos(markers.marker(i));
            double d3 = Math.max(Math.abs(d2 - d), 1.0E-7);
            dArray[i] = dArray[i - 1] + d3;
            d = d2;
        }
        return dArray;
    }

    private static RefHapSegs refHapSegs(SampleHapPairs sampleHapPairs, int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int[] nArray3 = new int[n + 1];
        int[] nArray4 = new int[n + 1];
        nArray3[0] = 0;
        nArray4[0] = nArray2[nArray[0] - 1] + 1;
        nArray3[1] = nArray2[0];
        nArray4[1] = nArray2[nArray[1] - 1] + 1;
        for (int i = 2; i < n; ++i) {
            nArray3[i] = nArray2[nArray[i - 2]];
            nArray4[i] = nArray2[nArray[i] - 1] + 1;
        }
        nArray3[n] = nArray2[nArray[n - 2]];
        nArray4[n] = sampleHapPairs.nMarkers();
        return new RefHapSegs(sampleHapPairs, nArray3, nArray4);
    }

    public SampleHapPairs refHapPairs() {
        return this.refHapPairs;
    }

    public SampleHapPairs targHapPairs() {
        return this.targHapPairs;
    }

    public RefHapSegs refHapSegs() {
        return this.refHapSegs;
    }

    public int nClusters() {
        return this.nClusters;
    }

    public Samples targetSamples() {
        return this.targHapPairs.samples();
    }

    public int refAllele(int n, int n2) {
        return this.refAlleles[n].get(n2);
    }

    public int targetAllele(int n, int n2) {
        return this.targAlleles[n].get(n2);
    }

    public float errProb(int n) {
        return this.errProb[n];
    }

    public float noErrProb(int n) {
        return 1.0f - this.errProb[n];
    }

    public float pRecomb(int n) {
        return this.pRecomb[n];
    }

    public double weight(int n) {
        return this.weight[n];
    }
}

