/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel._examples;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.search.MiningTask;
import org.vikamine.kernel.xpdl.DatasetProvider;
import org.vikamine.kernel.xpdl.DirectoryDatasetProvider;
import org.vikamine.kernel.xpdl.MiningTaskInterpreter;
import org.vikamine.kernel.xpdl.XMLSGPatternExport;

public class XMLTaskRunnerExample {
    private static final String FILENAME = "../org.vikamine.kernel.test/resources/tests/simple/credit-g_nom_3_Pietatsky-ShapiroQF.xml";

    public static void main(String[] args) throws IOException {
        XMLTaskRunnerExample.createResultFile(FILENAME, "results_../org.vikamine.kernel.test/resources/tests/simple/credit-g_nom_3_Pietatsky-ShapiroQF.xml");
        System.out.println("COMPLETE!");
    }

    private static void createResultFile(String sourceFilename, String resultFilename) throws IOException {
        File sourceFile = new File(sourceFilename);
        if (!sourceFile.exists()) {
            throw new IllegalArgumentException("Target File does not exist: " + sourceFilename);
        }
        DirectoryDatasetProvider provider = new DirectoryDatasetProvider("../org.vikamine.kernel.test/resources/datasets/");
        MiningTaskInterpreter interpreter = new MiningTaskInterpreter(sourceFile, (DatasetProvider)provider);
        MiningTask task = interpreter.getTask();
        SGSet sgSet = task.performSubgroupDiscovery();
        Document doc = XMLSGPatternExport.getXML(sgSet, task.getOntology());
        new XMLOutputter(Format.getPrettyFormat()).output(doc, (Writer)new FileWriter(new File(resultFilename)));
    }
}

