/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.functions.LinearRegression;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.instance.RemoveRange;

public class LeastMedSq
extends Classifier
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 4288954049987652970L;
    private double[] m_Residuals;
    private double[] m_weight;
    private double m_SSR;
    private double m_scalefactor;
    private double m_bestMedian = Double.POSITIVE_INFINITY;
    private LinearRegression m_currentRegression;
    private LinearRegression m_bestRegression;
    private LinearRegression m_ls;
    private Instances m_Data;
    private Instances m_RLSData;
    private Instances m_SubSample;
    private ReplaceMissingValues m_MissingFilter;
    private NominalToBinary m_TransformFilter;
    private RemoveRange m_SplitFilter;
    private int m_samplesize = 4;
    private int m_samples;
    private boolean m_israndom = false;
    private boolean m_debug = false;
    private Random m_random;
    private long m_randomseed = 0L;

    public String globalInfo() {
        return "Implements a least median sqaured linear regression utilising the existing weka LinearRegression class to form predictions. \nLeast squared regression functions are generated from random subsamples of the data. The least squared regression with the lowest meadian squared error is chosen as the final model.\n\nThe basis of the algorithm is \n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Peter J. Rousseeuw and Annick M. Leroy");
        result.setValue(TechnicalInformation.Field.YEAR, "1987");
        result.setValue(TechnicalInformation.Field.TITLE, "Robust regression and outlier detection");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        this.cleanUpData(data);
        this.getSamples();
        this.findBestRegression();
        this.buildRLSRegression();
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        Instance transformedInstance = instance;
        this.m_TransformFilter.input(transformedInstance);
        transformedInstance = this.m_TransformFilter.output();
        this.m_MissingFilter.input(transformedInstance);
        transformedInstance = this.m_MissingFilter.output();
        return this.m_ls.classifyInstance(transformedInstance);
    }

    private void cleanUpData(Instances data) throws Exception {
        this.m_Data = data;
        this.m_TransformFilter = new NominalToBinary();
        this.m_TransformFilter.setInputFormat(this.m_Data);
        this.m_Data = Filter.useFilter(this.m_Data, this.m_TransformFilter);
        this.m_MissingFilter = new ReplaceMissingValues();
        this.m_MissingFilter.setInputFormat(this.m_Data);
        this.m_Data = Filter.useFilter(this.m_Data, this.m_MissingFilter);
        this.m_Data.deleteWithMissingClass();
    }

    private void getSamples() throws Exception {
        int[] stuf = new int[]{500, 50, 22, 17, 15, 14};
        this.m_samples = this.m_samplesize < 7 ? (this.m_Data.numInstances() < stuf[this.m_samplesize - 1] ? LeastMedSq.combinations(this.m_Data.numInstances(), this.m_samplesize) : this.m_samplesize * 500) : 3000;
        if (this.m_debug) {
            System.out.println("m_samplesize: " + this.m_samplesize);
            System.out.println("m_samples: " + this.m_samples);
            System.out.println("m_randomseed: " + this.m_randomseed);
        }
    }

    private void setRandom() {
        this.m_random = new Random(this.getRandomSeed());
    }

    private void findBestRegression() throws Exception {
        this.setRandom();
        this.m_bestMedian = Double.POSITIVE_INFINITY;
        if (this.m_debug) {
            System.out.println("Starting:");
        }
        int s = 0;
        int r = 0;
        while (s < this.m_samples) {
            if (this.m_debug && s % (this.m_samples / 100) == 0) {
                System.out.print("*");
            }
            this.genRegression();
            this.getMedian();
            ++s;
            ++r;
        }
        if (this.m_debug) {
            System.out.println("");
        }
        this.m_currentRegression = this.m_bestRegression;
    }

    private void genRegression() throws Exception {
        this.m_currentRegression = new LinearRegression();
        this.m_currentRegression.setOptions(new String[]{"-S", "1"});
        this.selectSubSample(this.m_Data);
        this.m_currentRegression.buildClassifier(this.m_SubSample);
    }

    private void findResiduals() throws Exception {
        this.m_SSR = 0.0;
        this.m_Residuals = new double[this.m_Data.numInstances()];
        int i = 0;
        while (i < this.m_Data.numInstances()) {
            this.m_Residuals[i] = this.m_currentRegression.classifyInstance(this.m_Data.instance(i));
            int n = i;
            this.m_Residuals[n] = this.m_Residuals[n] - this.m_Data.instance(i).value(this.m_Data.classAttribute());
            int n2 = i;
            this.m_Residuals[n2] = this.m_Residuals[n2] * this.m_Residuals[i];
            this.m_SSR += this.m_Residuals[i];
            ++i;
        }
    }

    private void getMedian() throws Exception {
        this.findResiduals();
        int p = this.m_Residuals.length;
        LeastMedSq.select(this.m_Residuals, 0, p - 1, p / 2);
        if (this.m_Residuals[p / 2] < this.m_bestMedian) {
            this.m_bestMedian = this.m_Residuals[p / 2];
            this.m_bestRegression = this.m_currentRegression;
        }
    }

    public String toString() {
        if (this.m_ls == null) {
            return "model has not been built";
        }
        return this.m_ls.toString();
    }

    private void buildWeight() throws Exception {
        this.findResiduals();
        this.m_scalefactor = 1.4826 * (double)(1 + 5 / (this.m_Data.numInstances() - this.m_Data.numAttributes())) * Math.sqrt(this.m_bestMedian);
        this.m_weight = new double[this.m_Residuals.length];
        int i = 0;
        while (i < this.m_Residuals.length) {
            this.m_weight[i] = Math.sqrt(this.m_Residuals[i]) / this.m_scalefactor < 2.5 ? 1.0 : 0.0;
            ++i;
        }
    }

    private void buildRLSRegression() throws Exception {
        this.buildWeight();
        this.m_RLSData = new Instances(this.m_Data);
        int x = 0;
        int y = 0;
        int n = this.m_RLSData.numInstances();
        while (y < n) {
            if (this.m_weight[x] == 0.0) {
                this.m_RLSData.delete(y);
                n = this.m_RLSData.numInstances();
                --y;
            }
            ++x;
            ++y;
        }
        if (this.m_RLSData.numInstances() == 0) {
            System.err.println("rls regression unbuilt");
            this.m_ls = this.m_currentRegression;
        } else {
            this.m_ls = new LinearRegression();
            this.m_ls.setOptions(new String[]{"-S", "1"});
            this.m_ls.buildClassifier(this.m_RLSData);
            this.m_currentRegression = this.m_ls;
        }
    }

    private static void select(double[] a, int l, int r, int k) {
        if (r <= l) {
            return;
        }
        int i = LeastMedSq.partition(a, l, r);
        if (i > k) {
            LeastMedSq.select(a, l, i - 1, k);
        }
        if (i < k) {
            LeastMedSq.select(a, i + 1, r, k);
        }
    }

    private static int partition(double[] a, int l, int r) {
        double temp;
        int i = l - 1;
        int j = r;
        double v = a[r];
        while (true) {
            if (a[++i] < v) {
                continue;
            }
            while (v < a[--j]) {
                if (j == l) break;
            }
            if (i >= j) break;
            temp = a[i];
            a[i] = a[j];
            a[j] = temp;
        }
        temp = a[i];
        a[i] = a[r];
        a[r] = temp;
        return i;
    }

    private void selectSubSample(Instances data) throws Exception {
        this.m_SplitFilter = new RemoveRange();
        this.m_SplitFilter.setInvertSelection(true);
        this.m_SubSample = data;
        this.m_SplitFilter.setInputFormat(this.m_SubSample);
        this.m_SplitFilter.setInstancesIndices(this.selectIndices(this.m_SubSample));
        this.m_SubSample = Filter.useFilter(this.m_SubSample, this.m_SplitFilter);
    }

    private String selectIndices(Instances data) {
        StringBuffer text = new StringBuffer();
        int i = 0;
        int x = 0;
        while (i < this.m_samplesize) {
            while ((x = (int)(this.m_random.nextDouble() * (double)data.numInstances())) == 0) {
            }
            text.append(Integer.toString(x));
            if (i < this.m_samplesize - 1) {
                text.append(",");
            } else {
                text.append("\n");
            }
            ++i;
        }
        return text.toString();
    }

    public String sampleSizeTipText() {
        return "Set the size of the random samples used to generate the least sqaured regression functions.";
    }

    public void setSampleSize(int samplesize) {
        this.m_samplesize = samplesize;
    }

    public int getSampleSize() {
        return this.m_samplesize;
    }

    public String randomSeedTipText() {
        return "Set the seed for selecting random subsamples of the training data.";
    }

    public void setRandomSeed(long randomseed) {
        this.m_randomseed = randomseed;
    }

    public long getRandomSeed() {
        return this.m_randomseed;
    }

    @Override
    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    @Override
    public boolean getDebug() {
        return this.m_debug;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tSet sample size\n\t(default: 4)\n", "S", 4, "-S <sample size>"));
        newVector.addElement(new Option("\tSet the seed used to generate samples\n\t(default: 0)\n", "G", 0, "-G <seed>"));
        newVector.addElement(new Option("\tProduce debugging output\n\t(default no debugging output)\n", "D", 0, "-D"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String curropt = Utils.getOption('S', options);
        if (curropt.length() != 0) {
            this.setSampleSize(Integer.parseInt(curropt));
        } else {
            this.setSampleSize(4);
        }
        curropt = Utils.getOption('G', options);
        if (curropt.length() != 0) {
            this.setRandomSeed(Long.parseLong(curropt));
        } else {
            this.setRandomSeed(0L);
        }
        this.setDebug(Utils.getFlag('D', options));
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[9];
        int current = 0;
        options[current++] = "-S";
        options[current++] = "" + this.getSampleSize();
        options[current++] = "-G";
        options[current++] = "" + this.getRandomSeed();
        if (this.getDebug()) {
            options[current++] = "-D";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public static int combinations(int n, int r) throws Exception {
        int c = 1;
        int denom = 1;
        int num = 1;
        int orig = r;
        if (r > n) {
            throw new Exception("r must be less that or equal to n.");
        }
        r = Math.min(r, n - r);
        int i = 1;
        while (i <= r) {
            num *= n - i + 1;
            denom *= i;
            ++i;
        }
        c = num / denom;
        return c;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5523 $");
    }

    public static void main(String[] argv) {
        LeastMedSq.runClassifier(new LeastMedSq(), argv);
    }
}

