/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.cost.tsp.heap;

import java.util.BitSet;
import org.chocosolver.solver.constraints.graph.cost.tsp.heap.BinarySimpleHeap;
import org.chocosolver.solver.constraints.graph.cost.tsp.heap.ISimpleHeap;

public class FastSimpleHeap
implements ISimpleHeap {
    private final BitSet inBest;
    private final BitSet obsolete;
    private final int[] stack;
    private int k;
    private final ISimpleHeap heap_rest;

    public FastSimpleHeap(int n) {
        this(n, new BinarySimpleHeap(n));
    }

    public FastSimpleHeap(int n, ISimpleHeap heap) {
        this.inBest = new BitSet(n);
        this.obsolete = new BitSet(n);
        this.stack = new int[n];
        this.k = 0;
        this.heap_rest = heap;
    }

    @Override
    public boolean isEmpty() {
        return this.k == 0 && this.heap_rest.isEmpty();
    }

    @Override
    public int removeFirstElement() {
        if (this.k == 0) {
            int f;
            while ((f = this.heap_rest.removeFirstElement()) != -1 && this.obsolete.get(f)) {
            }
            return f;
        }
        int first = this.stack[--this.k];
        this.inBest.clear(first);
        return first;
    }

    @Override
    public boolean addOrUpdateElement(int element, double value) {
        if (value < -2.147483648E9) {
            throw new UnsupportedOperationException("cannot use a FastSimpleHeap on such data");
        }
        if (this.inBest.get(element)) {
            return false;
        }
        if (value == Double.MIN_VALUE) {
            this.inBest.set(element);
            this.stack[this.k++] = element;
            this.obsolete.set(element);
            return true;
        }
        return this.heap_rest.addOrUpdateElement(element, value);
    }

    @Override
    public void clear() {
        this.k = 0;
        this.inBest.clear();
        this.obsolete.clear();
        this.heap_rest.clear();
    }
}

