/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@Deprecated
public class MDLReader
extends DefaultChemObjectReader {
    BufferedReader input;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLReader.class);
    private BooleanIOSetting forceReadAs3DCoords;
    private static final Pattern TRAILING_SPACE = Pattern.compile("\\s+$");

    public MDLReader() {
        this(new StringReader(""));
    }

    public MDLReader(InputStream in) {
        this(in, IChemObjectReader.Mode.RELAXED);
    }

    public MDLReader(InputStream in, IChemObjectReader.Mode mode) {
        this(new InputStreamReader(in));
        this.mode = mode;
    }

    public MDLReader(Reader in) {
        this(in, IChemObjectReader.Mode.RELAXED);
    }

    public MDLReader(Reader in, IChemObjectReader.Mode mode) {
        this.mode = mode;
        this.input = new BufferedReader(in);
        this.initIOSettings();
    }

    public IResourceFormat getFormat() {
        return MDLFormat.getInstance();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        if (IChemModel.class.equals(classObject)) {
            return true;
        }
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (IChemFile.class.equals(anInterface)) {
                return true;
            }
            if (IChemModel.class.equals(anInterface)) {
                return true;
            }
            if (!IAtomContainer.class.equals(anInterface)) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        if (object instanceof IChemModel) {
            return (T)this.readChemModel((IChemModel)object);
        }
        if (object instanceof IAtomContainer) {
            return (T)this.readMolecule((IAtomContainer)object);
        }
        throw new CDKException("Only supported are ChemFile and Molecule.");
    }

    private IChemModel readChemModel(IChemModel chemModel) throws CDKException {
        IAtomContainer m;
        IAtomContainerSet setOfMolecules = chemModel.getMoleculeSet();
        if (setOfMolecules == null) {
            setOfMolecules = (IAtomContainerSet)chemModel.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        }
        if ((m = this.readMolecule((IAtomContainer)chemModel.getBuilder().newInstance(IAtomContainer.class, new Object[0]))) != null) {
            setOfMolecules.addAtomContainer(m);
        }
        chemModel.setMoleculeSet(setOfMolecules);
        return chemModel;
    }

    private IChemFile readChemFile(IChemFile chemFile) throws CDKException {
        IChemSequence chemSequence = (IChemSequence)chemFile.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel chemModel = (IChemModel)chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
        IAtomContainerSet setOfMolecules = (IAtomContainerSet)chemFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        IAtomContainer m = this.readMolecule((IAtomContainer)chemFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]));
        if (m != null) {
            setOfMolecules.addAtomContainer(m);
        }
        chemModel.setMoleculeSet(setOfMolecules);
        chemSequence.addChemModel(chemModel);
        setOfMolecules = (IAtomContainerSet)chemFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        chemModel = (IChemModel)chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
        try {
            String line;
            while ((line = this.input.readLine()) != null) {
                logger.debug((Object)"line: ", new Object[]{line});
                String str = line;
                if (line.equals("M  END")) continue;
                if (str.equals("$$$$")) {
                    m = this.readMolecule((IAtomContainer)chemFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]));
                    if (m == null) continue;
                    setOfMolecules.addAtomContainer(m);
                    chemModel.setMoleculeSet(setOfMolecules);
                    chemSequence.addChemModel(chemModel);
                    setOfMolecules = (IAtomContainerSet)chemFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                    chemModel = (IChemModel)chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
                    continue;
                }
                if (m == null) continue;
                String fieldName = null;
                if (str.startsWith("> ")) {
                    int index2;
                    int index = (str = str.substring(2)).indexOf(60);
                    if (index != -1 && (index2 = str.substring(index).indexOf(62)) != -1) {
                        fieldName = str.substring(index + 1, index + index2);
                    }
                    while ((line = this.input.readLine()) != null && line.startsWith(">")) {
                        logger.debug((Object)"data header line: ", new Object[]{line});
                    }
                }
                if (line == null) {
                    throw new CDKException("Expecting data line here, but found null!");
                }
                String data = line;
                while ((line = this.input.readLine()) != null && line.trim().length() > 0) {
                    if (line.equals("$$$$")) {
                        logger.error((Object)"Expecting data line here, but found end of molecule: ", new Object[]{line});
                        break;
                    }
                    logger.debug((Object)"data line: ", new Object[]{line});
                    data = data + line;
                    if (line.length() >= 80) continue;
                    data = data + "\n";
                }
                if (fieldName == null) continue;
                logger.info((Object)"fieldName, data: ", new Object[]{fieldName, ", ", data});
                m.setProperty((Object)fieldName, (Object)data);
            }
        }
        catch (CDKException cdkexc) {
            throw cdkexc;
        }
        catch (IOException | IllegalArgumentException exception) {
            String error = "Error while parsing SDF";
            logger.error((Object)error);
            logger.debug((Object)exception);
            throw new CDKException(error, (Throwable)exception);
        }
        try {
            this.input.close();
        }
        catch (Exception exc) {
            String error = "Error while closing file: " + exc.getMessage();
            logger.error((Object)error);
            throw new CDKException(error, (Throwable)exc);
        }
        chemFile.addChemSequence(chemSequence);
        return chemFile;
    }

    private IAtomContainer readMolecule(IAtomContainer molecule) throws CDKException {
        logger.debug((Object)"Reading new molecule");
        int linecount = 0;
        IBond.Stereo stereo = (IBond.Stereo)CDKConstants.UNSET;
        int RGroupCounter = 1;
        double totalX = 0.0;
        double totalY = 0.0;
        double totalZ = 0.0;
        String line = "";
        try {
            Isotopes isotopeFactory = Isotopes.getInstance();
            logger.info((Object)"Reading header");
            line = this.input.readLine();
            ++linecount;
            if (line == null) {
                return null;
            }
            logger.debug((Object)("Line " + linecount + ": " + line));
            if (line.startsWith("$$$$")) {
                logger.debug((Object)"File is empty, returning empty molecule");
                return molecule;
            }
            if (line.length() > 0) {
                molecule.setTitle(line);
            }
            line = this.input.readLine();
            logger.debug((Object)("Line " + ++linecount + ": " + line));
            line = this.input.readLine();
            logger.debug((Object)("Line " + ++linecount + ": " + line));
            if (line.length() > 0) {
                molecule.setProperty((Object)"cdk:Remark", (Object)line);
            }
            logger.info((Object)"Reading rest of file");
            line = this.input.readLine();
            logger.debug((Object)("Line " + ++linecount + ": " + line));
            if (this.mode == IChemObjectReader.Mode.STRICT) {
                if (line.contains("V2000") || line.contains("v2000")) {
                    throw new CDKException("This file must be read with the MDLV2000Reader.");
                }
                if (line.contains("V3000") || line.contains("v3000")) {
                    throw new CDKException("This file must be read with the MDLV3000Reader.");
                }
            }
            int atoms = Integer.parseInt(line.substring(0, 3).trim());
            logger.debug((Object)("Atomcount: " + atoms));
            int bonds = Integer.parseInt(line.substring(3, 6).trim());
            logger.debug((Object)("Bondcount: " + bonds));
            logger.info((Object)"Reading atom block");
            for (int f = 0; f < atoms; ++f) {
                IAtom atom;
                line = this.input.readLine();
                ++linecount;
                Matcher trailingSpaceMatcher = TRAILING_SPACE.matcher(line);
                if (trailingSpaceMatcher.find()) {
                    this.handleError("Trailing space found", linecount, trailingSpaceMatcher.start(), trailingSpaceMatcher.end());
                    line = trailingSpaceMatcher.replaceAll("");
                }
                double x = new Double(line.substring(0, 10).trim());
                double y = new Double(line.substring(10, 20).trim());
                double z = new Double(line.substring(20, 30).trim());
                totalX += Math.abs(x);
                totalY += Math.abs(y);
                totalZ += Math.abs(z);
                logger.debug((Object)("Coordinates: " + x + "; " + y + "; " + z));
                String element = line.substring(31, Math.min(34, line.length())).trim();
                if (line.length() < 34) {
                    this.handleError("Element atom type does not follow V2000 format type should of length three and padded with space if required", linecount, 31, 34);
                }
                logger.debug((Object)"Atom type: ", new Object[]{element});
                if (isotopeFactory.isElement(element)) {
                    atom = isotopeFactory.configure((IAtom)molecule.getBuilder().newInstance(IAtom.class, new Object[]{element}));
                } else if ("A".equals(element)) {
                    atom = (IAtom)molecule.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
                } else if ("Q".equals(element)) {
                    atom = (IAtom)molecule.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
                } else if ("*".equals(element)) {
                    atom = (IAtom)molecule.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
                } else if ("LP".equals(element)) {
                    atom = (IAtom)molecule.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
                } else if ("L".equals(element)) {
                    atom = (IAtom)molecule.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
                } else if (element.length() > 0 && element.charAt(0) == 'R') {
                    logger.debug((Object)"Atom ", new Object[]{element, " is not an regular element. Creating a PseudoAtom."});
                    String[] rGroup = element.split("^R");
                    if (rGroup.length > 1) {
                        int Rnumber;
                        try {
                            RGroupCounter = Rnumber = Integer.parseInt(rGroup[rGroup.length - 1]);
                        }
                        catch (Exception ex) {
                            Rnumber = RGroupCounter++;
                        }
                        element = "R" + Rnumber;
                    }
                    atom = (IAtom)molecule.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
                } else {
                    if (this.mode == IChemObjectReader.Mode.STRICT) {
                        throw new CDKException("Invalid element type. Must be an existing element, or one in: A, Q, L, LP, *.");
                    }
                    atom = (IAtom)molecule.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
                }
                atom.setPoint3d(new Point3d(x, y, z));
                if (line.length() >= 36) {
                    String massDiffString = line.substring(34, 36).trim();
                    logger.debug((Object)"Mass difference: ", new Object[]{massDiffString});
                    if (!(atom instanceof IPseudoAtom)) {
                        try {
                            int massDiff = Integer.parseInt(massDiffString);
                            if (massDiff != 0) {
                                IIsotope major = Isotopes.getInstance().getMajorIsotope(element);
                                atom.setMassNumber(Integer.valueOf(major.getMassNumber() + massDiff));
                            }
                        }
                        catch (IOException | NumberFormatException exception) {
                            logger.error((Object)"Could not parse mass difference field");
                        }
                    } else {
                        logger.error((Object)"Cannot set mass difference for a non-element!");
                    }
                } else {
                    this.handleError("Mass difference is missing", linecount, 34, 36);
                }
                if (line.length() >= 39) {
                    String chargeCodeString = line.substring(36, 39).trim();
                    logger.debug((Object)"Atom charge code: ", new Object[]{chargeCodeString});
                    int chargeCode = Integer.parseInt(chargeCodeString);
                    if (chargeCode != 0) {
                        if (chargeCode == 1) {
                            atom.setFormalCharge(Integer.valueOf(3));
                        } else if (chargeCode == 2) {
                            atom.setFormalCharge(Integer.valueOf(2));
                        } else if (chargeCode == 3) {
                            atom.setFormalCharge(Integer.valueOf(1));
                        } else if (chargeCode != 4) {
                            if (chargeCode == 5) {
                                atom.setFormalCharge(Integer.valueOf(-1));
                            } else if (chargeCode == 6) {
                                atom.setFormalCharge(Integer.valueOf(-2));
                            } else if (chargeCode == 7) {
                                atom.setFormalCharge(Integer.valueOf(-3));
                            }
                        }
                    }
                } else {
                    this.handleError("Atom charge count is empty", linecount, 35, 39);
                }
                if (line.length() >= 64) {
                    String reactionAtomIDString = line.substring(60, 63).trim();
                    logger.debug((Object)"Parsing mapping id: ", new Object[]{reactionAtomIDString});
                    try {
                        int reactionAtomID = Integer.parseInt(reactionAtomIDString);
                        if (reactionAtomID != 0) {
                            atom.setProperty((Object)"cdk:AtomAtomMapping", (Object)reactionAtomID);
                        }
                    }
                    catch (Exception exception) {
                        logger.error((Object)"Mapping number ", new Object[]{reactionAtomIDString, " is not an integer."});
                        logger.debug((Object)exception);
                    }
                }
                if (line.length() >= 78) {
                    double shift = Double.parseDouble(line.substring(69, 80).trim());
                    atom.setProperty((Object)"first shift", (Object)shift);
                }
                if (line.length() >= 87) {
                    double shift = Double.parseDouble(line.substring(79, 87).trim());
                    atom.setProperty((Object)"second shift", (Object)shift);
                }
                molecule.addAtom(atom);
            }
            if (totalX == 0.0 && totalY == 0.0 && totalZ == 0.0) {
                logger.info((Object)"All coordinates are 0.0");
                for (IAtom atomToUpdate : molecule.atoms()) {
                    atomToUpdate.setPoint3d(null);
                }
            } else if (totalZ == 0.0 && !this.forceReadAs3DCoords.isSet()) {
                logger.info((Object)"Total 3D Z is 0.0, interpreting it as a 2D structure");
                for (IAtom atomToUpdate : molecule.atoms()) {
                    Point3d p3d = atomToUpdate.getPoint3d();
                    atomToUpdate.setPoint2d(new Point2d(p3d.x, p3d.y));
                    atomToUpdate.setPoint3d(null);
                }
            }
            logger.info((Object)"Reading bond block");
            for (int f = 0; f < bonds; ++f) {
                line = this.input.readLine();
                ++linecount;
                int atom1 = Integer.parseInt(line.substring(0, 3).trim());
                int atom2 = Integer.parseInt(line.substring(3, 6).trim());
                int order = Integer.parseInt(line.substring(6, 9).trim());
                if (line.length() > 12) {
                    int mdlStereo = Integer.parseInt(line.substring(9, 12).trim());
                    if (mdlStereo == 1) {
                        stereo = IBond.Stereo.UP;
                    } else if (mdlStereo == 6) {
                        stereo = IBond.Stereo.DOWN;
                    } else if (mdlStereo == 0) {
                        stereo = IBond.Stereo.NONE;
                    } else if (mdlStereo == 4) {
                        stereo = IBond.Stereo.UP_OR_DOWN;
                    } else if (mdlStereo == 3) {
                        stereo = IBond.Stereo.E_OR_Z;
                    }
                } else {
                    logger.warn((Object)("Missing expected stereo field at line: " + line));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Bond: " + atom1 + " - " + atom2 + "; order " + order));
                }
                IAtom a1 = molecule.getAtom(atom1 - 1);
                IAtom a2 = molecule.getAtom(atom2 - 1);
                IBond newBond = null;
                if (order >= 1 && order <= 3) {
                    IBond.Order cdkOrder = IBond.Order.SINGLE;
                    if (order == 2) {
                        cdkOrder = IBond.Order.DOUBLE;
                    }
                    if (order == 3) {
                        cdkOrder = IBond.Order.TRIPLE;
                    }
                    newBond = stereo != null ? (IBond)molecule.getBuilder().newInstance(IBond.class, new Object[]{a1, a2, cdkOrder, stereo}) : (IBond)molecule.getBuilder().newInstance(IBond.class, new Object[]{a1, a2, cdkOrder});
                } else if (order == 4) {
                    newBond = stereo != null ? (IBond)molecule.getBuilder().newInstance(IBond.class, new Object[]{a1, a2, IBond.Order.SINGLE, stereo}) : (IBond)molecule.getBuilder().newInstance(IBond.class, new Object[]{a1, a2, IBond.Order.SINGLE});
                    newBond.setFlag(32, true);
                    a1.setFlag(32, true);
                    a2.setFlag(32, true);
                }
                molecule.addBond(newBond);
            }
        }
        catch (IOException | IllegalArgumentException | CDKException exception) {
            String error = "Error while parsing line " + linecount + ": " + line + " -> " + exception.getMessage();
            logger.error((Object)error);
            logger.debug((Object)exception);
            throw new CDKException(error, exception);
        }
        return molecule;
    }

    public void close() throws IOException {
        this.input.close();
    }

    private void initIOSettings() {
        this.forceReadAs3DCoords = (BooleanIOSetting)this.addSetting((IOSetting)new BooleanIOSetting("ForceReadAs3DCoordinates", IOSetting.Importance.LOW, "Should coordinates always be read as 3D?", "false"));
    }

    public void customizeJob() {
        this.fireIOSettingQuestion((IOSetting)this.forceReadAs3DCoords);
    }
}

