/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.DerivedOutputField;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.OrdinalLabel;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.converter.regression.RegressionModelUtil;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RMSConverter;
import org.jpmml.rexp.RStringVector;

public class ORMConverter
extends RMSConverter {
    public ORMConverter(RGenericVector orm) {
        super(orm);
    }

    @Override
    public void encodeSchema(RExpEncoder encoder) {
        RGenericVector orm = (RGenericVector)this.getObject();
        RStringVector yUnique = orm.getStringElement("yunique");
        super.encodeSchema(encoder);
        ContinuousLabel continuousLabel = (ContinuousLabel)encoder.getLabel();
        DataField dataField = (DataField)encoder.toOrdinal(continuousLabel.getName(), yUnique.getValues());
        dataField.setDataType(DataType.STRING);
        encoder.setLabel(dataField);
    }

    @Override
    public Model encodeModel(Schema schema) {
        Double coefficient;
        RGenericVector orm = (RGenericVector)this.getObject();
        RStringVector family = orm.getStringElement("family");
        RDoubleVector coefficients = orm.getDoubleElement("coefficients");
        ModelEncoder encoder = schema.getEncoder();
        OrdinalLabel ordinalLabel = (OrdinalLabel)schema.getLabel();
        List features = schema.getFeatures();
        ArrayList<Double> thresholdCoefficients = new ArrayList<Double>();
        ArrayList<Double> featureCoefficients = new ArrayList<Double>();
        int max = ordinalLabel.size() - 1;
        for (int i = 0; i < max; ++i) {
            coefficient = coefficients.getValue(i);
            coefficient = -1.0 * coefficient;
            thresholdCoefficients.add(coefficient);
        }
        for (Feature feature : features) {
            coefficient = this.getFeatureCoefficient(feature, coefficients);
            featureCoefficients.add(coefficient);
        }
        Schema segmentSchema = schema.toAnonymousRegressorSchema(DataType.DOUBLE);
        RegressionModel firstRegressionModel = RegressionModelUtil.createRegression((List)features, featureCoefficients, null, null, (Schema)segmentSchema).setTargets(ModelUtil.createRescaleTargets((Number)-1.0, null, (ContinuousLabel)((ContinuousLabel)segmentSchema.getLabel())));
        OutputField linpredOutputField = ModelUtil.createPredictedField((String)"linpred", (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE);
        DerivedOutputField linpredField = encoder.createDerivedField((Model)firstRegressionModel, linpredOutputField, true);
        ContinuousFeature feature = new ContinuousFeature((PMMLEncoder)encoder, (Field)linpredField);
        RegressionModel secondRegressionModel = RegressionModelUtil.createOrdinalClassification((Feature)feature, thresholdCoefficients, (RegressionModel.NormalizationMethod)ORMConverter.parseNormalizationMethod((String)family.asScalar()), (boolean)true, (Schema)schema);
        return MiningModelUtil.createModelChain(Arrays.asList(firstRegressionModel, secondRegressionModel), (Segmentation.MissingPredictionTreatment)Segmentation.MissingPredictionTreatment.RETURN_MISSING);
    }

    private static RegressionModel.NormalizationMethod parseNormalizationMethod(String family) {
        switch (family) {
            case "logistic": {
                return RegressionModel.NormalizationMethod.LOGIT;
            }
            case "probit": {
                return RegressionModel.NormalizationMethod.PROBIT;
            }
            case "cauchit": {
                return RegressionModel.NormalizationMethod.CAUCHIT;
            }
        }
        throw new IllegalArgumentException(family);
    }
}

