/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified.leaves.bool;

import choco.cp.solver.constraints.global.Occurrence;
import choco.cp.solver.constraints.reified.ReifiedFactory;
import choco.cp.solver.constraints.reified.leaves.bool.AbstractBoolNode;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.constraints.reified.BoolNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class AndNode
extends AbstractBoolNode {
    public AndNode(INode ... subt) {
        super(subt, NodeType.AND);
    }

    @Override
    public boolean checkTuple(int[] tuple) {
        for (INode subtree : this.subtrees) {
            if (((BoolNode)((Object)subtree)).checkTuple(tuple)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IntDomainVar extractResult(Solver s) {
        IntExp[] vs = new IntDomainVar[this.subtrees.length];
        IntDomainVar sand = s.createBoundIntVar(StringUtils.randomName(), 0, this.subtrees.length);
        IntDomainVar v = s.createBooleanVar(StringUtils.randomName());
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = this.subtrees[i].extractResult(s);
        }
        s.post(s.eq(s.sum(vs), (IntExp)sand));
        s.post(ReifiedFactory.builder(v, s.eq((IntExp)sand, this.subtrees.length), s));
        return v;
    }

    @Override
    public SConstraint extractConstraint(Solver s) {
        IntDomainVar[] vs = new IntDomainVar[this.subtrees.length + 1];
        for (int i = 0; i < vs.length - 1; ++i) {
            vs[i] = this.subtrees[i].extractResult(s);
        }
        vs[vs.length - 1] = new IntDomainVarImpl(s, StringUtils.randomName(), 6, this.subtrees.length, this.subtrees.length);
        return new Occurrence(vs, 1, true, true, s.getEnvironment());
    }

    @Override
    public boolean isReified() {
        return true;
    }

    @Override
    public String pretty() {
        int i;
        StringBuilder st = new StringBuilder("(");
        for (i = 0; i < this.subtrees.length - 1; ++i) {
            st.append(this.subtrees[i].pretty()).append(" and ");
        }
        st.append(this.subtrees[i].pretty()).append(')');
        return st.toString();
    }
}

