/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators;

import java.util.Random;
import moa.core.InstancesHeader;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.FlagOption;
import moa.options.FloatOption;
import moa.options.IntOption;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class AgrawalGenerator
extends AbstractOptionHandler
implements InstanceStream {
    private static final long serialVersionUID = 1L;
    public IntOption functionOption = new IntOption("function", 'f', "Classification function used, as defined in the original paper.", 1, 1, 10);
    public IntOption instanceRandomSeedOption = new IntOption("instanceRandomSeed", 'i', "Seed for random generation of instances.", 1);
    public FloatOption peturbFractionOption = new FloatOption("peturbFraction", 'p', "The amount of peturbation (noise) introduced to numeric values.", 0.05, 0.0, 1.0);
    public FlagOption balanceClassesOption = new FlagOption("balanceClasses", 'b', "Balance the number of instances of each class.");
    protected static ClassFunction[] classificationFunctions = new ClassFunction[]{new ClassFunction(){

        public int determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            return age < 40 || 60 <= age ? 0 : 1;
        }
    }, new ClassFunction(){

        public int determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            if (age < 40) {
                return 50000.0 <= salary && salary <= 100000.0 ? 0 : 1;
            }
            if (age < 60) {
                return 75000.0 <= salary && salary <= 125000.0 ? 0 : 1;
            }
            return 25000.0 <= salary && salary <= 75000.0 ? 0 : 1;
        }
    }, new ClassFunction(){

        public int determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            if (age < 40) {
                return elevel == 0 || elevel == 1 ? 0 : 1;
            }
            if (age < 60) {
                return elevel == 1 || elevel == 2 || elevel == 3 ? 0 : 1;
            }
            return elevel == 2 || elevel == 3 || elevel == 4 ? 0 : 1;
        }
    }, new ClassFunction(){

        public int determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            if (age < 40) {
                if (elevel == 0 || elevel == 1) {
                    return 25000.0 <= salary && salary <= 75000.0 ? 0 : 1;
                }
                return 50000.0 <= salary && salary <= 100000.0 ? 0 : 1;
            }
            if (age < 60) {
                if (elevel == 1 || elevel == 2 || elevel == 3) {
                    return 50000.0 <= salary && salary <= 100000.0 ? 0 : 1;
                }
                return 75000.0 <= salary && salary <= 125000.0 ? 0 : 1;
            }
            if (elevel == 2 || elevel == 3 || elevel == 4) {
                return 50000.0 <= salary && salary <= 100000.0 ? 0 : 1;
            }
            return 25000.0 <= salary && salary <= 75000.0 ? 0 : 1;
        }
    }, new ClassFunction(){

        public int determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            if (age < 40) {
                if (50000.0 <= salary && salary <= 100000.0) {
                    return 100000.0 <= loan && loan <= 300000.0 ? 0 : 1;
                }
                return 200000.0 <= loan && loan <= 400000.0 ? 0 : 1;
            }
            if (age < 60) {
                if (75000.0 <= salary && salary <= 125000.0) {
                    return 200000.0 <= loan && loan <= 400000.0 ? 0 : 1;
                }
                return 300000.0 <= loan && loan <= 500000.0 ? 0 : 1;
            }
            if (25000.0 <= salary && salary <= 75000.0) {
                return 300000.0 <= loan && loan <= 500000.0 ? 0 : 1;
            }
            return 100000.0 <= loan && loan <= 300000.0 ? 0 : 1;
        }
    }, new ClassFunction(){

        public int determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            double totalSalary = salary + commission;
            if (age < 40) {
                return 50000.0 <= totalSalary && totalSalary <= 100000.0 ? 0 : 1;
            }
            if (age < 60) {
                return 75000.0 <= totalSalary && totalSalary <= 125000.0 ? 0 : 1;
            }
            return 25000.0 <= totalSalary && totalSalary <= 75000.0 ? 0 : 1;
        }
    }, new ClassFunction(){

        public int determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            double disposable = 2.0 * (salary + commission) / 3.0 - loan / 5.0 - 20000.0;
            return disposable > 0.0 ? 0 : 1;
        }
    }, new ClassFunction(){

        public int determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            double disposable = 2.0 * (salary + commission) / 3.0 - 5000.0 * (double)elevel - 20000.0;
            return disposable > 0.0 ? 0 : 1;
        }
    }, new ClassFunction(){

        public int determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            double disposable = 2.0 * (salary + commission) / 3.0 - 5000.0 * (double)elevel - loan / 5.0 - 10000.0;
            return disposable > 0.0 ? 0 : 1;
        }
    }, new ClassFunction(){

        public int determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            double disposable;
            double equity = 0.0;
            if (hyears >= 20) {
                equity = hvalue * ((double)hyears - 20.0) / 10.0;
            }
            return (disposable = 2.0 * (salary + commission) / 3.0 - 5000.0 * (double)elevel + equity / 5.0 - 10000.0) > 0.0 ? 0 : 1;
        }
    }};
    protected InstancesHeader streamHeader;
    protected Random instanceRandom;
    protected boolean nextClassShouldBeZero;

    public String getPurposeString() {
        return "Generates one of ten different pre-defined loan functions.";
    }

    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        attributes.addElement(new Attribute("salary"));
        attributes.addElement(new Attribute("commission"));
        attributes.addElement(new Attribute("age"));
        FastVector<String> elevelLabels = new FastVector<String>();
        for (int i = 0; i < 5; ++i) {
            elevelLabels.addElement("level" + i);
        }
        attributes.addElement(new Attribute("elevel", elevelLabels));
        FastVector<String> carLabels = new FastVector<String>();
        for (int i = 0; i < 20; ++i) {
            carLabels.addElement("car" + (i + 1));
        }
        attributes.addElement(new Attribute("car", carLabels));
        FastVector<String> zipCodeLabels = new FastVector<String>();
        for (int i = 0; i < 9; ++i) {
            zipCodeLabels.addElement("zipcode" + (i + 1));
        }
        attributes.addElement(new Attribute("zipcode", zipCodeLabels));
        attributes.addElement(new Attribute("hvalue"));
        attributes.addElement(new Attribute("hyears"));
        attributes.addElement(new Attribute("loan"));
        FastVector<String> classLabels = new FastVector<String>();
        classLabels.addElement("groupA");
        classLabels.addElement("groupB");
        attributes.addElement(new Attribute("class", classLabels));
        this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), attributes, 0));
        this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
        this.restart();
    }

    public long estimatedRemainingInstances() {
        return -1L;
    }

    public InstancesHeader getHeader() {
        return this.streamHeader;
    }

    public boolean hasMoreInstances() {
        return true;
    }

    public boolean isRestartable() {
        return true;
    }

    public Instance nextInstance() {
        double salary = 0.0;
        double commission = 0.0;
        double hvalue = 0.0;
        double loan = 0.0;
        int age = 0;
        int elevel = 0;
        int car = 0;
        int zipcode = 0;
        int hyears = 0;
        int group = 0;
        boolean desiredClassFound = false;
        while (!desiredClassFound) {
            salary = 20000.0 + 130000.0 * this.instanceRandom.nextDouble();
            commission = salary >= 75000.0 ? 0.0 : 10000.0 + 65000.0 * this.instanceRandom.nextDouble();
            age = 20 + this.instanceRandom.nextInt(61);
            elevel = this.instanceRandom.nextInt(5);
            car = this.instanceRandom.nextInt(20);
            zipcode = this.instanceRandom.nextInt(9);
            hvalue = (9.0 - (double)zipcode) * 100000.0 * (0.5 + this.instanceRandom.nextDouble());
            hyears = 1 + this.instanceRandom.nextInt(30);
            loan = this.instanceRandom.nextDouble() * 500000.0;
            group = classificationFunctions[this.functionOption.getValue() - 1].determineClass(salary, commission, age, elevel, car, zipcode, hvalue, hyears, loan);
            if (!this.balanceClassesOption.isSet()) {
                desiredClassFound = true;
                continue;
            }
            if ((!this.nextClassShouldBeZero || group != 0) && (this.nextClassShouldBeZero || group != 1)) continue;
            desiredClassFound = true;
            this.nextClassShouldBeZero = !this.nextClassShouldBeZero;
        }
        if (this.peturbFractionOption.getValue() > 0.0) {
            salary = this.perturbValue(salary, 20000.0, 150000.0);
            if (commission > 0.0) {
                commission = this.perturbValue(commission, 10000.0, 75000.0);
            }
            age = (int)Math.round(this.perturbValue(age, 20.0, 80.0));
            hvalue = this.perturbValue(hvalue, (9.0 - (double)zipcode) * 100000.0, 0.0, 135000.0);
            hyears = (int)Math.round(this.perturbValue(hyears, 1.0, 30.0));
            loan = this.perturbValue(loan, 0.0, 500000.0);
        }
        InstancesHeader header = this.getHeader();
        DenseInstance inst = new DenseInstance(header.numAttributes());
        inst.setValue(0, salary);
        inst.setValue(1, commission);
        inst.setValue(2, (double)age);
        inst.setValue(3, (double)elevel);
        inst.setValue(4, (double)car);
        inst.setValue(5, (double)zipcode);
        inst.setValue(6, hvalue);
        inst.setValue(7, (double)hyears);
        inst.setValue(8, loan);
        inst.setDataset(header);
        inst.setClassValue(group);
        return inst;
    }

    protected double perturbValue(double val, double min, double max) {
        return this.perturbValue(val, max - min, min, max);
    }

    protected double perturbValue(double val, double range, double min, double max) {
        if ((val += range * (2.0 * (this.instanceRandom.nextDouble() - 0.5)) * this.peturbFractionOption.getValue()) < min) {
            val = min;
        } else if (val > max) {
            val = max;
        }
        return val;
    }

    public void restart() {
        this.instanceRandom = new Random(this.instanceRandomSeedOption.getValue());
        this.nextClassShouldBeZero = false;
    }

    public void getDescription(StringBuilder sb, int indent) {
    }

    protected static interface ClassFunction {
        public int determineClass(double var1, double var3, int var5, int var6, int var7, int var8, double var9, int var11, double var12);
    }
}

