/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierCPAR;

import keel.Algorithms.Associative_Classification.ClassifierCPAR.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierCPAR.Rule;
import keel.Algorithms.Associative_Classification.ClassifierCPAR.myDataset;

public class PNArray {
    int nVariables;
    int nData;
    int[] nLabels;
    double P;
    double N;
    double[][] PLiteral;
    double[][] NLiteral;
    myDataset train;
    DataBase dataBase;

    public PNArray() {
    }

    public PNArray(myDataset train, DataBase dataBase) {
        this.nData = train.getnData();
        this.nVariables = train.getnInputs();
        this.nLabels = dataBase.getnLabels();
        this.train = train;
        this.dataBase = dataBase;
        this.PLiteral = new double[this.nVariables][];
        this.NLiteral = new double[this.nVariables][];
        for (int i = 0; i < this.nVariables; ++i) {
            this.PLiteral[i] = new double[this.nLabels[i]];
            this.NLiteral[i] = new double[this.nLabels[i]];
        }
    }

    public void copy(PNArray a) {
        this.nData = a.nData;
        this.nVariables = a.nVariables;
        this.nLabels = a.nLabels;
        this.train = a.train;
        this.dataBase = a.dataBase;
        this.P = a.P;
        this.N = a.N;
        this.PLiteral = new double[a.nVariables][];
        this.NLiteral = new double[a.nVariables][];
        for (int i = 0; i < a.nVariables; ++i) {
            this.PLiteral[i] = new double[a.nLabels[i]];
            this.NLiteral[i] = new double[a.nLabels[i]];
            for (int j = 0; j < a.nLabels[i]; ++j) {
                this.PLiteral[i][j] = a.PLiteral[i][j];
                this.NLiteral[i][j] = a.NLiteral[i][j];
            }
        }
    }

    public void ini(int clas) {
        int j;
        int i;
        this.P = this.train.numberInstances(clas);
        this.N = (double)this.nData - this.P;
        for (i = 0; i < this.nVariables; ++i) {
            for (j = 0; j < this.nLabels[i]; ++j) {
                this.PLiteral[i][j] = 0.0;
                this.NLiteral[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.nData; ++i) {
            int[] example = this.train.getExample(i);
            if (this.train.getOutputAsInteger(i) == clas) {
                for (j = 0; j < this.nVariables; ++j) {
                    double[] dArray = this.PLiteral[j];
                    int n = example[j];
                    dArray[n] = dArray[n] + 1.0;
                }
                continue;
            }
            for (j = 0; j < this.nVariables; ++j) {
                double[] dArray = this.NLiteral[j];
                int n = example[j];
                dArray[n] = dArray[n] + 1.0;
            }
        }
    }

    public void ini(Rule r) {
        int j;
        int i;
        this.P = 0.0;
        this.N = 0.0;
        for (i = 0; i < this.nVariables; ++i) {
            for (j = 0; j < this.nLabels[i]; ++j) {
                this.PLiteral[i][j] = 0.0;
                this.NLiteral[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.nData; ++i) {
            int[] example = this.train.getExample(i);
            if (!(r.matching(example) > 0.0)) continue;
            if (this.train.getOutputAsInteger(i) == r.getClas()) {
                this.P += this.train.getWeight(i);
                for (j = 0; j < this.nVariables; ++j) {
                    double[] dArray = this.PLiteral[j];
                    int n = example[j];
                    dArray[n] = dArray[n] + this.train.getWeight(i);
                }
                continue;
            }
            this.N += this.train.getWeight(i);
            for (j = 0; j < this.nVariables; ++j) {
                double[] dArray = this.NLiteral[j];
                int n = example[j];
                dArray[n] = dArray[n] + this.train.getWeight(i);
            }
        }
    }

    public void reducePositive(int pos) {
        int[] example = this.train.getExample(pos);
        for (int i = 0; i < this.nVariables; ++i) {
            double[] dArray = this.PLiteral[i];
            int n = example[i];
            dArray[n] = dArray[n] - this.train.getWeight(pos);
        }
        this.P -= this.train.getWeight(pos);
    }

    public void reduceNegative(int pos) {
        int[] example = this.train.getExample(pos);
        for (int i = 0; i < this.nVariables; ++i) {
            double[] dArray = this.NLiteral[i];
            int n = example[i];
            dArray[n] = dArray[n] - this.train.getWeight(pos);
        }
        this.N -= this.train.getWeight(pos);
    }

    public void incrPositive(int pos) {
        int[] example = this.train.getExample(pos);
        for (int i = 0; i < this.nVariables; ++i) {
            double[] dArray = this.PLiteral[i];
            int n = example[i];
            dArray[n] = dArray[n] + this.train.getWeight(pos);
        }
        this.P += this.train.getWeight(pos);
    }

    public double getP() {
        return this.P;
    }

    public double getN() {
        return this.N;
    }

    public double getP(int var, int value) {
        return this.PLiteral[var][value];
    }

    public double getN(int var, int value) {
        return this.NLiteral[var][value];
    }
}

