## ----include=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

knitr::opts_chunk$set(eval = TRUE, message = FALSE, results = 'asis', comment='')
options(width = 200)



## ----load-data----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(ProAE)

data(tox_acute)


## ----results='markup'---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

acute <- tox_acute

str(acute)
  

## ----results='markup'---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

figure_1 <- toxFigures(dsn = acute,
                      cycle_var = "Cycle",
                      baseline_val = 1,
                      arm_var = "arm",
                      id_var = "id")


## ----fig.width=9,fig.height=4-------------------------------------------------------------------------------------------------------------------------------------------------------------------------

figure_1[[1]][2]


## ----results='markup'---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

figure_2 <- toxFigures(dsn = acute,
                      cycle_var = "Cycle",
                      baseline_val = 1,
                      arm_var = "arm",
                      add_item_title=TRUE, #1
                      bar_label = 3, #2
                      cycle_vals=c(1,2,3,4,5,6), #3
                      cycle_label=TRUE,
                      cycle_labs=c("Baseline",
                                   "Week 1",
                                   "Week 2",
                                   "Day 30",
                                   "Month 2",
                                   "Month 3"
                                   ), #4
                      colors = 2, #5
                      id_var = "id",
                      x_label = "Assigned Treatment Group",  #6
                      summary_highlight = TRUE, #7
                      x_lab_angle=45,
                      x_lab_hjust=1) #8
           


## ----fig.width=9,fig.height=6-------------------------------------------------------------------------------------------------------------------------------------------------------------------------

figure_2[[1]][2]


