/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.jdbc4;

import com.amazon.dsi.core.interfaces.IConnection;
import com.amazon.jdbc.jdbc4.S4Connection;
import com.amazon.redshift.client.interfaces.Notification;
import com.amazon.redshift.core.NotifiedConnection;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGDSIOverrideHelper;
import com.amazon.redshift.core.PGJDBCConnection;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import java.sql.SQLException;
import java.util.List;

public class S4NotifiedConnection
extends S4Connection
implements NotifiedConnection {
    public S4NotifiedConnection(IConnection iConnection, String string) throws SQLException {
        super(iConnection, string);
    }

    @Override
    public List<Notification> getNotifications() {
        IWarningListener iWarningListener = this.getWarningListener();
        return PGCoreUtils.getNotifications(iWarningListener);
    }

    @Override
    public void clearNotifications() {
        IWarningListener iWarningListener = this.getWarningListener();
        PGCoreUtils.clearNotifications(iWarningListener);
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        if (!super.isValid(n)) {
            return false;
        }
        PGJDBCConnection pGJDBCConnection = (PGJDBCConnection)this.getDSIConnection();
        return PGDSIOverrideHelper.checkIsValidQuery(pGJDBCConnection);
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_logger.isEnabled()) {
            LogUtilities.logDebug("value of autocommit in S4NotifiedConnection " + bl, this.m_logger);
        }
        PGJDBCConnection pGJDBCConnection = (PGJDBCConnection)this.getDSIConnection();
        pGJDBCConnection.getPostgresqlClient().setConnectionAutoCommit(bl);
        super.setAutoCommit(bl);
    }
}

