/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.jayes.util;

import java.lang.reflect.Array;
import java.util.List;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static <T extends Number> Object unboxArray(T[] array) {
        Class<?> primitiveClass = ArrayUtils.getPrimitiveClass(array.getClass().getComponentType());
        Object arr = Array.newInstance(primitiveClass, array.length);
        int i = 0;
        while (i < array.length) {
            Array.set(arr, i, array[i]);
            ++i;
        }
        return arr;
    }

    public static <T extends Number> T[] boxArray(Object primitiveArray) {
        if (!primitiveArray.getClass().isArray()) {
            throw new IllegalArgumentException("not an array");
        }
        Class<?> primitiveClass = ArrayUtils.getWrapperClass(primitiveArray.getClass().getComponentType());
        Object arr = Array.newInstance(primitiveClass, Array.getLength(primitiveArray));
        int i = 0;
        while (i < Array.getLength(primitiveArray)) {
            Array.set(arr, i, Array.get(primitiveArray, i));
            ++i;
        }
        return (Number[])arr;
    }

    private static Class<?> getWrapperClass(Class<?> componentType) {
        if (Integer.TYPE.isAssignableFrom(componentType)) {
            return Integer.class;
        }
        if (Double.TYPE.isAssignableFrom(componentType)) {
            return Double.class;
        }
        throw new UnsupportedOperationException("Mapping not implemented");
    }

    private static Class<?> getPrimitiveClass(Class<?> componentType) {
        if (Integer.class.isAssignableFrom(componentType)) {
            return Integer.TYPE;
        }
        if (Double.class.isAssignableFrom(componentType)) {
            return Double.TYPE;
        }
        throw new UnsupportedOperationException("Mapping not implemented");
    }

    public static float[] toFloatArray(double[] array) {
        float[] result = new float[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = (float)array[i];
            ++i;
        }
        return result;
    }

    public static double[] toDoubleArray(float[] array) {
        double[] result = new double[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i];
            ++i;
        }
        return result;
    }

    public static int[] toIntArray(List<? extends Number> ints) {
        int[] result = new int[ints.size()];
        int i = 0;
        for (Number number : ints) {
            result[i] = number.intValue();
            ++i;
        }
        return result;
    }
}

