/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.SimpleAlignment;
import dr.evolution.alignment.SiteList;
import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.Codons;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.Nucleotides;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.util.Pair;
import dr.util.XHTMLable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class SitePatterns
implements SiteList,
XHTMLable {
    private final boolean DEBUG = false;
    public static final CompressionType DEFAULT_COMPRESSION_TYPE = CompressionType.UNIQUE_ONLY;
    public static final double DEFAULT_AMBIGUITY_THRESHOLD = 0.25;
    public static final int MINIMUM_UNAMBIGUOUS = 2;
    private final boolean isCompressed;
    protected final SiteList siteList;
    protected int siteCount = 0;
    protected int patternCount = 0;
    protected int[] sitePatternIndices;
    protected int invariantCount;
    protected double[] weights;
    protected int[][] patterns;
    protected double[][][] uncertainPatterns;
    private boolean uncertainSites = false;
    protected String id = null;

    public SitePatterns(Alignment alignment) {
        this(alignment, null, -1, -1, 1);
    }

    public SitePatterns(Alignment alignment, TaxonList taxonList) {
        this(alignment, taxonList, -1, -1, 1, true);
    }

    public SitePatterns(Alignment alignment, TaxonList taxonList, CompressionType compressionType) {
        this(alignment, taxonList, -1, -1, 1, true, compressionType);
    }

    public SitePatterns(Alignment alignment, int n, int n2, int n3) {
        this(alignment, null, n, n2, n3);
    }

    public SitePatterns(Alignment alignment, TaxonList taxonList, int n, int n2, int n3) {
        this(alignment, taxonList, n, n2, n3, true);
    }

    public SitePatterns(Alignment alignment, TaxonList taxonList, int n, int n2, int n3, boolean bl) {
        this(alignment, taxonList, n, n2, n3, bl, DEFAULT_COMPRESSION_TYPE);
    }

    public SitePatterns(Alignment alignment, TaxonList taxonList, int n, int n2, int n3, boolean bl, CompressionType compressionType) {
        this(alignment, taxonList, n, n2, n3, bl, null, compressionType, 0.25);
    }

    public SitePatterns(Alignment alignment, TaxonList taxonList, int n, int n2, int n3, boolean bl, int[] nArray, CompressionType compressionType, double d) {
        this.siteList = alignment;
        boolean bl2 = this.isCompressed = compressionType != CompressionType.UNCOMPRESSED;
        if (taxonList != null) {
            SimpleAlignment simpleAlignment = new SimpleAlignment();
            for (int i = 0; i < alignment.getSequenceCount(); ++i) {
                if (taxonList.getTaxonIndex(alignment.getTaxonId(i)) == -1) continue;
                simpleAlignment.addSequence(alignment.getSequence(i));
            }
            alignment = simpleAlignment;
        }
        if (nArray != null && nArray.length != alignment.getStateCount()) {
            throw new IllegalArgumentException("Constant site count array length doesn't equal the number of states");
        }
        this.addPatterns(alignment, n, n2, n3, bl, nArray, compressionType, d);
    }

    public SitePatterns(SiteList siteList) {
        this(siteList, -1, -1, 1);
    }

    public SitePatterns(SiteList siteList, int n, int n2, int n3) {
        this(siteList, n, n2, n3, true, DEFAULT_COMPRESSION_TYPE, 0.25);
    }

    public SitePatterns(SiteList siteList, int n, int n2, int n3, boolean bl) {
        this(siteList, n, n2, n3, bl, DEFAULT_COMPRESSION_TYPE, 0.25);
    }

    public SitePatterns(SiteList siteList, int n, int n2, int n3, boolean bl, CompressionType compressionType, double d) {
        this.siteList = siteList;
        this.isCompressed = compressionType != CompressionType.UNCOMPRESSED;
        this.addPatterns(siteList, n, n2, n3, bl, null, compressionType, d);
    }

    public SiteList getSiteList() {
        return this.siteList;
    }

    private void addPatterns(SiteList siteList, int n, int n2, int n3, boolean bl, int[] nArray, CompressionType compressionType, double d) {
        int n4;
        int n5;
        if (siteList == null) {
            return;
        }
        if (n <= -1) {
            n = 0;
        }
        if (n2 <= -1) {
            n2 = siteList.getSiteCount() - 1;
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        this.siteCount = (n2 - n) / n3 + 1;
        if (compressionType == CompressionType.AMBIGUOUS_CONSTANT || compressionType == CompressionType.AMBIGUOUS_UNIQUE) {
            this.siteCount += siteList.getStateCount();
        }
        this.patternCount = 0;
        this.patterns = new int[this.siteCount][];
        this.sitePatternIndices = new int[this.siteCount];
        this.weights = new double[this.siteCount];
        this.invariantCount = 0;
        this.uncertainSites = siteList.areUncertain();
        if (this.uncertainSites) {
            this.uncertainPatterns = new double[this.siteCount][][];
        }
        if (compressionType == CompressionType.AMBIGUOUS_CONSTANT || compressionType == CompressionType.AMBIGUOUS_UNIQUE) {
            for (n5 = 0; n5 < siteList.getStateCount(); ++n5) {
                int[] nArray2 = new int[siteList.getPatternLength()];
                for (n4 = 0; n4 < siteList.getPatternLength(); ++n4) {
                    nArray2[n4] = n5;
                }
                this.addPattern(nArray2, nArray != null ? (double)nArray[n5] : 0.0, null);
            }
        }
        n5 = 0;
        int n6 = 0;
        for (n4 = n; n4 <= n2; n4 += n3) {
            int[] nArray3 = siteList.getSitePattern(n4);
            double d2 = siteList.getPatternWeight(n4);
            if (this.uncertainSites) {
                this.sitePatternIndices[n5] = this.addUncertainPattern(nArray3, d2, siteList.getUncertainSitePattern(n4));
            } else if (!(bl && this.isInvariant(nArray3, false) && (this.isGapped(nArray3) || this.isAmbiguous(nArray3) || this.isUnknown(nArray3)))) {
                this.sitePatternIndices[n5] = this.addPattern(nArray3, d2, compressionType);
                ++n6;
            } else {
                this.sitePatternIndices[n5] = -1;
            }
            ++n5;
        }
        if (compressionType != CompressionType.UNCOMPRESSED && compressionType != CompressionType.UNIQUE_ONLY) {
            this.compressAmbiguousPatterns(compressionType == CompressionType.AMBIGUOUS_CONSTANT, d);
            this.sitePatternIndices = null;
        }
        this.countInvariantSites();
    }

    private int addPattern(int[] nArray, double d, CompressionType compressionType) {
        int n;
        if (compressionType != CompressionType.UNCOMPRESSED) {
            for (n = 0; n < this.patternCount; ++n) {
                if (!this.comparePatterns(this.patterns[n], nArray, false)) continue;
                this.patterns[n] = nArray;
                int n2 = n;
                this.weights[n2] = this.weights[n2] + d;
                return n;
            }
        }
        n = this.patternCount++;
        this.patterns[n] = nArray;
        this.weights[n] = d;
        return n;
    }

    private int addUncertainPattern(int[] nArray, double d, double[][] dArray) {
        int n = this.patternCount;
        this.patterns[n] = nArray;
        this.weights[n] = d;
        if (this.uncertainSites) {
            if (dArray == null) {
                this.uncertainPatterns[n] = new double[nArray.length][];
                for (int i = 0; i < nArray.length; ++i) {
                    int[] nArray2;
                    double[] dArray2 = new double[this.getDataType().getStateCount()];
                    for (int n2 : nArray2 = this.getDataType().getStates(nArray[i])) {
                        dArray2[n2] = 1.0;
                    }
                    this.uncertainPatterns[n][i] = dArray2;
                }
            } else {
                this.uncertainPatterns[n] = dArray;
            }
        }
        ++this.patternCount;
        return n;
    }

    private void countInvariantSites() {
        this.invariantCount = 0;
        for (int i = 0; i < this.patternCount; ++i) {
            if (!this.isInvariant(this.patterns[i], false)) continue;
            this.invariantCount += (int)this.weights[i];
        }
    }

    private void sortPatternsByWeight() {
        int n;
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        for (n = 0; n < this.patterns.length; ++n) {
            arrayList.add(new Pair<int[], Double>(this.patterns[n], this.weights[n]));
        }
        arrayList.sort(Comparator.comparingDouble(pair -> -((Double)pair.getSecond()).doubleValue()));
        n = 0;
        for (Pair pair2 : arrayList) {
            this.patterns[n] = (int[])pair2.getFirst();
            this.weights[n] = (Double)pair2.getSecond();
            ++n;
        }
    }

    private void compressAmbiguousPatterns(boolean bl, double d) {
        int n;
        int n2;
        int n3 = (int)((1.0 - d) * (double)this.getPatternLength());
        n3 = Math.min(n3, 2);
        block0: for (n2 = this.getStateCount(); n2 < this.patternCount; ++n2) {
            n = bl ? this.getStateCount() : n2;
            for (int i = 0; i < n; ++i) {
                if (this.patterns[i] == null || this.getCanonicalStateCount(this.patterns[n2]) < n3 || !this.comparePatterns(this.patterns[n2], this.patterns[i], true)) continue;
                if (!bl && this.getCanonicalStateCount(this.patterns[n2]) > this.getCanonicalStateCount(this.patterns[i])) {
                    this.patterns[i] = this.patterns[n2];
                }
                int n4 = i;
                this.weights[n4] = this.weights[n4] + this.weights[n2];
                this.weights[n2] = 0.0;
                this.patterns[n2] = null;
                continue block0;
            }
        }
        for (n2 = 0; n2 < this.patternCount; ++n2) {
            if (this.patterns[n2] != null) continue;
            for (n = n2 + 1; n < this.patternCount && this.patterns[n] == null; ++n) {
            }
            if (n < this.patternCount) {
                this.patterns[n2] = this.patterns[n];
                this.weights[n2] = this.weights[n];
                this.patterns[n] = null;
                this.weights[n] = 0.0;
                continue;
            }
            this.patternCount = n2;
        }
    }

    private boolean isGapped(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this.getDataType().isGapState(nArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isAmbiguous(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this.getDataType().isAmbiguousState(nArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isUnknown(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this.getDataType().isUnknownState(nArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isInvariant(int[] nArray, boolean bl) {
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (!(bl ? this.getDataType().areUnambiguouslyDifferent(n, nArray[i]) : n != nArray[i])) continue;
            return false;
        }
        return true;
    }

    private int getCanonicalStateCount(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            if (n2 >= this.getDataType().getStateCount()) continue;
            ++n;
        }
        return n;
    }

    protected boolean comparePatterns(int[] nArray, int[] nArray2) {
        return this.comparePatterns(nArray, nArray2, false);
    }

    protected boolean comparePatterns(int[] nArray, int[] nArray2, boolean bl) {
        if (!bl) {
            return Arrays.equals(nArray, nArray2);
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.getDataType().areUnambiguouslyDifferent(nArray[i], nArray2[i])) continue;
            return false;
        }
        return true;
    }

    public int getInvariantCount() {
        return this.invariantCount;
    }

    @Override
    public int getSiteCount() {
        return this.siteCount;
    }

    @Override
    public int[] getSitePattern(int n) {
        int n2 = this.sitePatternIndices[n];
        return n2 >= 0 ? this.patterns[n2] : null;
    }

    @Override
    public double[][] getUncertainSitePattern(int n) {
        throw new UnsupportedOperationException("getUncertainSitePattern not implemented yet");
    }

    @Override
    public int getPatternIndex(int n) {
        return this.sitePatternIndices[n];
    }

    @Override
    public int getState(int n, int n2) {
        int n3 = this.sitePatternIndices[n2];
        return n3 >= 0 ? this.patterns[n3][n] : this.getDataType().getGapState();
    }

    @Override
    public double[] getUncertainState(int n, int n2) {
        throw new UnsupportedOperationException("getUncertainState not implemented yet");
    }

    @Override
    public int getPatternCount() {
        return this.patternCount;
    }

    @Override
    public int getStateCount() {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getStateCount();
    }

    @Override
    public int getPatternLength() {
        return this.getTaxonCount();
    }

    @Override
    public int[] getPattern(int n) {
        return this.patterns[n];
    }

    @Override
    public double[][] getUncertainPattern(int n) {
        throw new UnsupportedOperationException("getUncertainPattern not implemented yet");
    }

    @Override
    public int getPatternState(int n, int n2) {
        return this.patterns[n2][n];
    }

    @Override
    public double[] getUncertainPatternState(int n, int n2) {
        return this.uncertainPatterns[n2][n];
    }

    @Override
    public double getPatternWeight(int n) {
        return this.weights[n];
    }

    @Override
    public double[] getPatternWeights() {
        return this.weights;
    }

    @Override
    public DataType getDataType() {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getDataType();
    }

    @Override
    public double[] getStateFrequencies() {
        return PatternList.Utils.empiricalStateFrequencies(this);
    }

    @Override
    public boolean areUnique() {
        return this.isCompressed;
    }

    @Override
    public boolean areUncertain() {
        return this.uncertainSites;
    }

    @Override
    public int getTaxonCount() {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxon(n);
    }

    @Override
    public String getTaxonId(int n) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonId(n);
    }

    @Override
    public int getTaxonIndex(String string) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonIndex(string);
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonIndex(taxon);
    }

    @Override
    public List<Taxon> asList() {
        ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getTaxon(i));
        }
        return arrayList;
    }

    @Override
    public Iterator<Taxon> iterator() {
        return new Iterator<Taxon>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index < SitePatterns.this.getTaxonCount() - 1;
            }

            @Override
            public Taxon next() {
                ++this.index;
                return SitePatterns.this.getTaxon(this.index);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonAttribute(n, string);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String toXHTML() {
        int n;
        int n2;
        String string = "<p><em>Pattern List</em>  pattern count = ";
        string = string + this.getPatternCount();
        string = string + "  invariant count = ";
        string = string + this.getInvariantCount();
        string = string + "</p>";
        string = string + "<pre>";
        int n3 = this.getDataType().getType();
        int n4 = this.getPatternCount();
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            n = Integer.toString((int)this.getPatternWeight(n2)).length();
            if (n <= n5) continue;
            n5 = n;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            int n6;
            for (n6 = n = Integer.toString(n2 + 1).length(); n6 < n5; ++n6) {
                string = string + " ";
            }
            string = string + Integer.toString(n2 + 1) + ": ";
            n = Integer.toString((int)this.getPatternWeight(n2)).length();
            string = string + Integer.toString((int)this.getPatternWeight(n2));
            for (n6 = n; n6 <= n5; ++n6) {
                string = string + " ";
            }
            for (n6 = 0; n6 < this.getTaxonCount(); ++n6) {
                int n7 = this.getPatternState(n6, n2);
                string = n3 == 0 ? string + Nucleotides.INSTANCE.getChar(n7) + " " : (n3 == 2 ? string + Codons.UNIVERSAL.getTriplet(n7) + " " : string + AminoAcids.INSTANCE.getChar(n7) + " ");
            }
            string = string + "\n";
        }
        string = string + "</pre>";
        return string;
    }

    public static enum CompressionType {
        UNCOMPRESSED,
        UNIQUE_ONLY,
        AMBIGUOUS_UNIQUE,
        AMBIGUOUS_CONSTANT;

    }
}

