/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jebl.evolution.align.CompoundAlignmentProgressListener;
import jebl.evolution.align.MultipleAligner;
import jebl.evolution.align.PairwiseAligner;
import jebl.evolution.align.SequenceAlignmentsDistanceMatrix;
import jebl.evolution.alignments.Alignment;
import jebl.evolution.distances.CannotBuildDistanceMatrixException;
import jebl.evolution.distances.DistanceMatrix;
import jebl.evolution.distances.F84DistanceMatrix;
import jebl.evolution.distances.HKYDistanceMatrix;
import jebl.evolution.distances.JukesCantorDistanceMatrix;
import jebl.evolution.distances.TamuraNeiDistanceMatrix;
import jebl.evolution.graphs.Node;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.trees.ClusteringTreeBuilder;
import jebl.evolution.trees.SimpleRootedTree;
import jebl.evolution.trees.Tree;
import jebl.evolution.trees.TreeBuilderFactory;
import jebl.util.CompositeProgressListener;
import jebl.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignmentTreeBuilderFactory {
    private static final Logger logger = Logger.getLogger(AlignmentTreeBuilderFactory.class.getName());

    private static Result build(DistanceMatrixBuilder distanceMatrixBuilder, TreeBuilderFactory.Method method, ProgressListener _progressListener) throws CannotBuildDistanceMatrixException {
        if (_progressListener == null) {
            logger.warning("ProgressListener is null");
            _progressListener = ProgressListener.EMPTY;
        }
        CompositeProgressListener progressListener = new CompositeProgressListener(_progressListener, 0.5, 0.5);
        progressListener.beginSubtask("Computing genetic distance for all pairs");
        long start = System.currentTimeMillis();
        DistanceMatrix distanceMatrix = distanceMatrixBuilder.buildDistanceMatrix(progressListener);
        logger.fine("took " + (System.currentTimeMillis() - start) + " to build distance matrix");
        progressListener.beginSubtask("Building tree");
        ClusteringTreeBuilder treeBuilder = TreeBuilderFactory.getBuilder(method, distanceMatrix);
        treeBuilder.addProgressListener(progressListener);
        Result result = new Result((Tree)treeBuilder.build(), distanceMatrix);
        treeBuilder.removeProgressListener(progressListener);
        return result;
    }

    public static Result build(final Alignment alignment, TreeBuilderFactory.Method method, final TreeBuilderFactory.DistanceModel model, ProgressListener progressListener, final boolean useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable) throws CannotBuildDistanceMatrixException {
        DistanceMatrixBuilder matrixBuilder = new DistanceMatrixBuilder(){

            public DistanceMatrix buildDistanceMatrix(ProgressListener progressListener) throws CannotBuildDistanceMatrixException {
                switch (model) {
                    case F84: {
                        return new F84DistanceMatrix(alignment, progressListener);
                    }
                    case HKY: {
                        return new HKYDistanceMatrix(alignment, progressListener, useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable);
                    }
                    case TamuraNei: {
                        return new TamuraNeiDistanceMatrix(alignment, progressListener, useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable);
                    }
                }
                return new JukesCantorDistanceMatrix(alignment, progressListener, useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable);
            }
        };
        return AlignmentTreeBuilderFactory.build(matrixBuilder, method, progressListener);
    }

    public static Result build(Alignment alignment, TreeBuilderFactory.Method method, TreeBuilderFactory.DistanceModel model, ProgressListener progressListener) throws CannotBuildDistanceMatrixException {
        return AlignmentTreeBuilderFactory.build(alignment, method, model, progressListener, false);
    }

    public static Result build(List<Sequence> seqs, TreeBuilderFactory.Method method, PairwiseAligner aligner, ProgressListener progressListener) throws CannotBuildDistanceMatrixException {
        return AlignmentTreeBuilderFactory.build(seqs, method, aligner, progressListener, SequenceAlignmentsDistanceMatrix.getDefaultDistanceModel(seqs));
    }

    public static Result build(final List<Sequence> seqs, TreeBuilderFactory.Method method, final PairwiseAligner aligner, ProgressListener progressListener, final TreeBuilderFactory.DistanceModel model) throws CannotBuildDistanceMatrixException {
        DistanceMatrixBuilder matrixBuilder = new DistanceMatrixBuilder(){

            public DistanceMatrix buildDistanceMatrix(ProgressListener progressListener) throws CannotBuildDistanceMatrixException {
                return new SequenceAlignmentsDistanceMatrix(seqs, aligner, progressListener, model);
            }
        };
        return AlignmentTreeBuilderFactory.build(matrixBuilder, method, progressListener);
    }

    public static Result build(List<Sequence> seqs, TreeBuilderFactory.Method method, MultipleAligner aligner, ProgressListener progress, boolean useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable) throws CannotBuildDistanceMatrixException {
        SimpleRootedTree gtree = new SimpleRootedTree();
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Sequence s : seqs) {
            Node tip = gtree.createExternalNode(s.getTaxon());
            nodes.add(tip);
        }
        int nnodes = nodes.size();
        while (nnodes > 1) {
            ArrayList<SimpleRootedTree.SimpleRootedNode> upnodes = new ArrayList<SimpleRootedTree.SimpleRootedNode>();
            for (int k = 0; k < nnodes / 2; ++k) {
                upnodes.add(gtree.createInternalNode(nodes.subList(2 * k, 2 * k + 2)));
            }
            if ((nnodes & 1) != 0) {
                upnodes.add((SimpleRootedTree.SimpleRootedNode)nodes.get(nnodes - 1));
            }
            nodes = upnodes;
            nnodes = nodes.size();
        }
        int alignWork = seqs.size() - 1;
        boolean treeWork = true;
        boolean matrixWork = false;
        CompoundAlignmentProgressListener p = new CompoundAlignmentProgressListener(progress, alignWork + 1 + 0);
        ProgressListener minorProgress = p.getMinorProgress();
        progress.setMessage("Building alignment for guide");
        p.setSectionSize(alignWork);
        Alignment alignment = aligner.doAlign(seqs, gtree, minorProgress);
        if (p.isCanceled()) {
            return null;
        }
        p.incrementSectionsCompleted(alignWork);
        boolean isProtein = seqs.get(0).getSequenceType().getCanonicalStateCount() > 4;
        TreeBuilderFactory.DistanceModel distanceModel = isProtein ? TreeBuilderFactory.DistanceModel.JukesCantor : TreeBuilderFactory.DistanceModel.HKY;
        p.setSectionSize(1);
        progress.setMessage("Building guide tree from alignment");
        Result result = AlignmentTreeBuilderFactory.build(alignment, method, distanceModel, minorProgress, useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable);
        p.incrementSectionsCompleted(1);
        return result;
    }

    public static class Result {
        public final Tree tree;
        public final DistanceMatrix distance;

        Result(Tree tree, DistanceMatrix distance) {
            this.tree = tree;
            this.distance = distance;
        }
    }

    private static interface DistanceMatrixBuilder {
        public DistanceMatrix buildDistanceMatrix(ProgressListener var1) throws CannotBuildDistanceMatrixException;
    }
}

