## ----include=FALSE------------------------------------------------------------
knitr::opts_chunk$set(
  comment = "#>",
  collapse = TRUE,
  echo = TRUE,
  message = FALSE,
  knitr.table.format = "html"
)

options(
  vlkr.fig.settings=list(
    html = list(
      dpi = 96, scale = 1, width = 910, pxperline = 12
    )
  )
)

## ----warning=FALSE------------------------------------------------------------
# Load the package
library(volker)

# Set the basic plot theme
theme_set(theme_vlkr())

# Load an example dataset ds from the package
ds <- volker::chatgpt


## ----eval=FALSE---------------------------------------------------------------
# # A single variable
# report_counts(ds, use_private)

## ----eval=FALSE---------------------------------------------------------------
# # A list of variables
# report_counts(ds, c(use_private, use_work))

## ----eval=FALSE---------------------------------------------------------------
# # Variables matched by a pattern
# report_counts(ds, starts_with("use_"))

## ----eval=FALSE---------------------------------------------------------------
# # One metric variable
# report_metrics(ds, sd_age)

## ----eval=FALSE---------------------------------------------------------------
# # Multiple metric items
# report_metrics(ds, starts_with("cg_adoption_"))

## ----eval=FALSE---------------------------------------------------------------
# report_counts(ds, adopter, sd_gender)

## ----eval=FALSE---------------------------------------------------------------
# report_metrics(ds, sd_age, sd_gender)

## ----eval=FALSE---------------------------------------------------------------
# report_metrics(ds, sd_age, use_work, metric = TRUE)

## ----eval=FALSE---------------------------------------------------------------
# ds |>
#   filter(sd_gender != "diverse") |>
#   report_metrics(sd_age, sd_gender, ci = TRUE)

## ----eval=FALSE---------------------------------------------------------------
# ds |>
#   filter(sd_gender != "diverse") |>
#   report_counts(adopter, sd_gender, effect = TRUE)

## ----eval=FALSE---------------------------------------------------------------
# ds |>
#   filter(sd_gender != "diverse") |>
#   report_counts(adopter, sd_gender, prop="rows", numbers= "n")

## -----------------------------------------------------------------------------
theme_set(theme_vlkr(
  base_fill = c("#F0983A","#3ABEF0","#95EF39","#E35FF5","#7A9B59"),
  base_gradient = c("#FAE2C4","#F0983A")
))

## -----------------------------------------------------------------------------
codebook(ds)

## ----eval = FALSE-------------------------------------------------------------
# ds %>%
#   labs_apply(
#     items = list(
#       "cg_adoption_advantage_01" = "General advantages",
#       "cg_adoption_advantage_02" = "Financial advantages",
#       "cg_adoption_advantage_03" = "Work-related advantages",
#       "cg_adoption_advantage_04" = "More fun"
#     )
#   ) %>%
#   report_metrics(starts_with("cg_adoption_advantage_"))

## ----eval=FALSE---------------------------------------------------------------
# ds %>%
#   labs_apply(
#     cols = starts_with("cg_adoption"),
#     values = list(
#       "1" = "Strongly disagree",
#       "2" = "Disagree",
#       "3" = "Neutral",
#       "4" = "Agree",
#       "5" = "Strongly agree"
#     )
#   ) %>%
#   report_metrics(starts_with("cg_adoption"))

## ----eval=FALSE---------------------------------------------------------------
# library(readxl)
# library(writexl)
# 
# # Save codebook to a file
# codes <- codebook(ds)
# write_xlsx(codes,"codebook.xlsx")
# 
# # Load and apply a codebook from a file
# codes <- read_xlsx("codebook_revised.xlsx")
# ds <- labs_apply(ds, codebook)

## ----eval=FALSE---------------------------------------------------------------
# ds %>%
#   labs_store() %>%
#   mutate(sd_age = 2024 - sd_age) %>%
#   labs_restore() %>%
# 
#   report_metrics(sd_age)

## -----------------------------------------------------------------------------

#> ```{r echo=FALSE}
#> ds %>% 
#>   filter(sd_gender != "diverse") %>% 
#>   report_counts(adopter, sd_gender, 
#> ```


## -----------------------------------------------------------------------------

#> ### Adoption types
#> 
#> ```{r echo=FALSE}
#> ds %>% 
#>   filter(sd_gender != "diverse") %>% 
#>   report_counts(adopter, sd_gender, prop="rows", title=FALSE, close=FALSE)
#> ```
#>
#> ##### Method
#> Basis: Only male and female respondents.
#> 
#> #### {-}


## ----eval=FALSE---------------------------------------------------------------
# ds |>
#   report_metrics(starts_with("cg_adoption"), index = TRUE)

## ----eval=FALSE---------------------------------------------------------------
# ds %>%
#   add_index(starts_with("cg_adoption_"), newcol = "idx_cg_adoption") %>%
#   report_metrics(idx_cg_adoption)

## ----eval=FALSE---------------------------------------------------------------
# ds %>%
#   add_index(starts_with("cg_adoption_"), newcol = "idx_cg_adoption") %>%
#   report_metrics(idx_cg_adoption, adopter)

## ----eval=FALSE---------------------------------------------------------------
# ds %>%
#   add_index(starts_with("cg_adoption_")) %>%
#   add_index(starts_with("cg_adoption_advantage")) %>%
#   add_index(starts_with("cg_adoption_fearofuse")) %>%
#   add_index(starts_with("cg_adoption_social")) %>%
#   tab_metrics(starts_with("idx_cg_adoption"))

## ----eval=FALSE---------------------------------------------------------------
# ds |>
#   report_metrics(starts_with("cg_adoption"), factors = TRUE, clusters = TRUE)

## ----eval=FALSE---------------------------------------------------------------
# 
# ds |>
#   add_factors(starts_with("cg_adoption"), k = 3) |>
#   select(starts_with("fct_"))

## ----eval=FALSE---------------------------------------------------------------
# ds |>
#   add_factors(starts_with("cg_adoption"), k = 3)  |>
#   report_metrics(fct_cg_adoption_1, fct_cg_adoption_2, metric = TRUE)
# 

## ----eval=FALSE---------------------------------------------------------------
# ds |>
#   add_clusters(starts_with("cg_adoption"), k = 3) |>
#   report_counts(sd_gender, cls_cg_adoption, prop = "cols")

## ----eval=FALSE---------------------------------------------------------------
# ds |>
#   add_factors(starts_with("cg_adoption"), k = 3)  |>
#   factor_tab(starts_with("fct_"))

## ----eval=FALSE---------------------------------------------------------------
# ds |>
#   add_factors(starts_with("cg_adoption"), k = NULL) |>
#   factor_tab(starts_with("fct_cg_adoption"))

## ----eval=FALSE---------------------------------------------------------------
# ds |>
#  filter(sd_gender != "diverse") |>
#  report_metrics(
#    use_work,
#    cross = c(sd_gender, adopter),
#    metric = sd_age,
#    model = TRUE,
#    diagnostics = TRUE
#  )

## ----eval=FALSE---------------------------------------------------------------
# ds <- ds |>
#   add_model(
#    use_work,
#    categorical = c(sd_gender, adopter),
#    metric = sd_age
#  )
# 
# report_metrics(ds, use_work, prd_use_work, metric = T)

## ----eval=FALSE---------------------------------------------------------------
# model_tab(ds, prd_use_work)
# model_plot(ds, prd_use_work)
# 

## -----------------------------------------------------------------------------

print(volker:::VLKR_NA_LEVELS)

print(volker:::VLKR_NA_NUMBERS)


