ui = fluidPage(theme = teachingApps::add_theme(getShinyOption("theme")), 
               teachingApps::add_css(),

sidebarLayout(
  sidebarPanel(width = 3,
  hr(),
  sliderInput("range.lget", 
              label = "Range",
              min = 0, 
              max = 20, 
              value = c(0,4)),
  sliderInput("al.lget", 
              label = h2(HTML("&alpha;")),
              min =  0, 
              max =  3, 
              step = 0.5, 
              value = 1, 
              animate = TRUE),
  sliderInput("si.lget", 
              label = h2(HTML("&sigma;")),
              min = -5, 
              max =  5, 
              step = 0.5, 
              value = 0, 
              animate = TRUE),
  sliderInput("xi.lget", 
              label = h2(HTML("&xi;")),
              min = .5, 
              max = 10, 
              step = 0.5, 
              value = 1, 
              animate = TRUE)),

  mainPanel(width = 9,
 tabsetPanel(type = 'pills',
  tabPanel('Distribution Function',metricsgraphicsOutput("lgetC",height = "600px")),
  tabPanel('Density',              metricsgraphicsOutput("lgetP",height = "600px")),
  tabPanel('Survival',             metricsgraphicsOutput("lgetR",height = "600px")),
  tabPanel('Hazard',               metricsgraphicsOutput("lgeth",height = "600px")),
  tabPanel('Cumulative Hazard',    metricsgraphicsOutput("lgetH",height = "600px")),
  tabPanel('Quantile',             metricsgraphicsOutput("lgetQ",height = "600px"))
  ))))
