/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml.print;

import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.TabStopAlignEnum;
import net.sf.jasperreports.engine.xml.print.XmlLoader;

public class ParagraphsLoader {
    private static final ParagraphsLoader INSTANCE = new ParagraphsLoader();

    public static ParagraphsLoader instance() {
        return INSTANCE;
    }

    public void loadParagraph(XmlLoader xmlLoader, JRParagraph paragraph) {
        xmlLoader.setEnumAttribute("lineSpacing", LineSpacingEnum::getByName, paragraph::setLineSpacing);
        xmlLoader.setFloatAttribute("lineSpacingSize", paragraph::setLineSpacingSize);
        xmlLoader.setIntAttribute("firstLineIndent", paragraph::setFirstLineIndent);
        xmlLoader.setIntAttribute("leftIndent", paragraph::setLeftIndent);
        xmlLoader.setIntAttribute("rightIndent", paragraph::setRightIndent);
        xmlLoader.setIntAttribute("spacingBefore", paragraph::setSpacingBefore);
        xmlLoader.setIntAttribute("spacingAfter", paragraph::setSpacingAfter);
        xmlLoader.setIntAttribute("tabStopWidth", paragraph::setTabStopWidth);
        xmlLoader.loadElements(element -> {
            switch (element) {
                case "tabStop": {
                    TabStop tabStop = new TabStop();
                    xmlLoader.setIntAttribute("position", tabStop::setPosition);
                    xmlLoader.setEnumAttribute("alignment", TabStopAlignEnum::getByName, tabStop::setAlignment);
                    xmlLoader.endElement();
                    paragraph.addTabStop(tabStop);
                    break;
                }
                default: {
                    xmlLoader.unexpectedElement((String)element);
                }
            }
        });
    }
}

