/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.codegen;

import com.google.gxp.com.google.common.base.Charsets;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.io.Characters;
import com.google.gxp.compiler.base.FormalParameter;
import com.google.gxp.compiler.base.Parameter;
import com.google.gxp.compiler.base.Root;
import com.google.gxp.compiler.base.Tree;
import com.google.gxp.compiler.codegen.CodeGenerator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class BaseCodeGenerator<T extends Tree<Root>>
implements CodeGenerator {
    protected final T tree;

    public BaseCodeGenerator(T tree) {
        this.tree = (Tree)Preconditions.checkNotNull(tree);
    }

    protected static String loadFormat(String name) {
        String resourceName = "/com/google/gxp/compiler/" + name + ".format";
        InputStream stream = BaseCodeGenerator.class.getResourceAsStream(resourceName);
        try {
            if (stream == null) {
                throw new FileNotFoundException("Can't load resource " + resourceName);
            }
            return Characters.toString(new InputStreamReader(stream, Charsets.US_ASCII)).trim();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String getDefaultMethodName(FormalParameter param) {
        String s = param.getPrimaryName();
        s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
        return "getDefault" + s;
    }

    protected static String getDefaultMethodName(Parameter param) {
        return BaseCodeGenerator.getDefaultMethodName(param.getFormalParameter());
    }

    protected static String getConstructorMethodName(FormalParameter param) {
        String s = param.getPrimaryName();
        s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
        return "construct" + s;
    }

    protected static String getConstructorMethodName(Parameter param) {
        return BaseCodeGenerator.getConstructorMethodName(param.getFormalParameter());
    }
}

