/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.sf.oval.internal.util.Assert;
import net.sf.oval.logging.Logger;

public class LoggerJDKImpl
implements Logger {
    private final java.util.logging.Logger jdkLogger;
    private final String name;

    public LoggerJDKImpl(String name) throws IllegalArgumentException {
        Assert.argumentNotNull("name", name);
        this.name = name;
        this.jdkLogger = java.util.logging.Logger.getLogger(name);
    }

    @Override
    public void debug(String msg) {
        this.log(Level.FINE, msg, null);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.log(Level.FINE, msg, t);
    }

    @Override
    public void error(String msg) {
        this.log(Level.SEVERE, msg, null);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.log(Level.SEVERE, msg, t);
    }

    @Override
    public void info(String msg) {
        this.log(Level.INFO, msg, null);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.log(Level.INFO, msg, t);
    }

    @Override
    public boolean isDebug() {
        return this.jdkLogger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isError() {
        return this.jdkLogger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isInfo() {
        return this.jdkLogger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isTrace() {
        return this.jdkLogger.isLoggable(Level.FINEST);
    }

    @Override
    public boolean isWarn() {
        return this.jdkLogger.isLoggable(Level.WARNING);
    }

    private void log(Level level, String msg, Throwable t) {
        LogRecord entry = new LogRecord(level, msg);
        entry.setLoggerName(this.name);
        entry.setThrown(t);
        StackTraceElement[] steArray = new Throwable().getStackTrace();
        entry.setSourceClassName(steArray[2].getClassName());
        entry.setSourceMethodName(steArray[2].getMethodName());
        this.jdkLogger.log(entry);
    }

    @Override
    public void trace(String msg) {
        this.log(Level.FINEST, msg, null);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.log(Level.FINEST, msg, t);
    }

    @Override
    public void warn(String msg) {
        this.log(Level.WARNING, msg, null);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.log(Level.WARNING, msg, t);
    }
}

