/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class IdentityHashSet<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IdentityHashMap<E, Boolean> map;
    private transient Set<E> entries;

    public IdentityHashSet() {
        this.map = new IdentityHashMap(16);
        this.entries = this.map.keySet();
    }

    public IdentityHashSet(int initialCapacity) {
        this.map = new IdentityHashMap(initialCapacity);
        this.entries = this.map.keySet();
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, Boolean.TRUE) == null;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.entries.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return o == this || this.entries.equals(o);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.entries.forEach(action);
    }

    @Override
    public int hashCode() {
        return this.entries.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.entries.iterator();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.entries.parallelStream();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.entries = this.map.keySet();
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.entries.removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        return this.entries.removeIf(filter);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.entries.retainAll(c);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.entries.spliterator();
    }

    @Override
    public Stream<E> stream() {
        return this.entries.stream();
    }

    @Override
    public Object[] toArray() {
        return this.entries.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    public String toString() {
        return this.entries.toString();
    }
}

