/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.internal.concurrent;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.jackrabbit.oak.commons.collections.IteratorUtils;
import org.apache.jackrabbit.oak.commons.collections.StreamUtils;

public class FutureUtils {
    private FutureUtils() {
    }

    public static <T> CompletableFuture<List<T>> successfulAsList(List<CompletableFuture<T>> futures) {
        List<CompletableFuture> handled = futures.stream().map(f -> f.handle((value, ex) -> ex == null ? value : null)).collect(Collectors.toList());
        return CompletableFuture.allOf(handled.toArray(new CompletableFuture[0])).thenApply(v -> handled.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static <T> CompletableFuture<List<T>> allAsList(Iterable<? extends CompletableFuture<? extends T>> tasks) {
        return CompletableFuture.allOf(IteratorUtils.toArray(tasks.iterator(), CompletableFuture.class)).thenApply(v -> StreamUtils.toStream(tasks).map(CompletableFuture::join).collect(Collectors.toList()));
    }
}

