/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.evaluator;

import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.qpid.server.query.engine.evaluator.EvaluationPhase;
import org.apache.qpid.server.query.engine.parsing.expression.Expression;
import org.apache.qpid.server.query.engine.parsing.query.QueryExpression;

public class EvaluationContext {
    public static final String BROKER = "broker";
    public static final String STATISTICS = "statistics";
    public static final String QUERY_AGGREGATED_RESULT = "query.aggregated.result";
    public static final String QUERY_ALIASES = "query.aliases";
    public static final String QUERY_DATETIME_PATTERN_OVERRIDEN = "query.datetime.pattern.overriden";
    public static final String QUERY_DEPTH = "query.depth";
    public static final String QUERY_ORDERING = "query.ordering";
    public static final String QUERY_ITEMS_FOR_REMOVAL = "query.items.for.removal";
    public static final String QUERY_ORDER_ITEMS_FOR_REMOVAL = "query.order.items.for.removal";
    public static final String QUERY_SETTINGS = "query.settings";
    public static final String COMPARATORS = "comparators";
    private final Map<Object, Object> _values = new ConcurrentHashMap<Object, Object>();
    private final Deque<QueryExpression<?, ?>> _expressions = new LinkedBlockingDeque();

    public EvaluationContext put(Object key, Object value) {
        this._values.put(key, value);
        return this;
    }

    public <T> T get(Object key, Class<T> type) {
        return type.cast(this._values.get(key));
    }

    public <T> T get(Object key) {
        return (T)this._values.get(key);
    }

    public boolean contains(Object key) {
        return this._values.containsKey(key);
    }

    public <T> T remove(String key) {
        return (T)this._values.remove(key);
    }

    public void clear() {
        this._values.clear();
    }

    public void incrementDepth() {
        AtomicInteger depth = (AtomicInteger)this.get(QUERY_DEPTH);
        depth.incrementAndGet();
    }

    public int getDepth() {
        AtomicInteger depth = (AtomicInteger)this.get(QUERY_DEPTH);
        return depth.get();
    }

    public void startBuilding() {
        this._values.put(EvaluationPhase.class, (Object)EvaluationPhase.BUILDING);
    }

    public boolean isBuilding() {
        return EvaluationPhase.BUILDING.equals(this._values.get(EvaluationPhase.class));
    }

    public boolean isExecuting() {
        return EvaluationPhase.EXECUTING.equals(this._values.get(EvaluationPhase.class));
    }

    public <T, R> void putAlias(String alias, Expression<T, R> expression) {
        Map aliases = (Map)this._values.get(QUERY_ALIASES);
        aliases.put(alias, expression);
    }

    public boolean containsAlias(String alias) {
        return this.get(QUERY_ALIASES, Map.class).containsKey(alias);
    }

    public <T, R> Expression<T, R> removeAlias(String alias) {
        return (Expression)this.get(QUERY_ALIASES, Map.class).remove(alias);
    }

    public <T, R> Expression<T, R> getAlias(String alias) {
        return (Expression)this.get(QUERY_ALIASES, Map.class).get(alias);
    }

    public <T, R> void startExecution(QueryExpression<T, R> query) {
        this._expressions.push(query);
        this._values.put(EvaluationPhase.class, (Object)EvaluationPhase.EXECUTING);
        this._values.put(QUERY_ALIASES, new HashMap());
    }

    public <T, R> QueryExpression<T, R> currentExecution() {
        return this._expressions.peek();
    }
}

